/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.StreamsGraphNode;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

class StreamSourceNode<K, V>
extends StreamsGraphNode {
    private Collection<String> topics;
    private Pattern topicPattern;
    private final ConsumedInternal<K, V> consumedInternal;

    StreamSourceNode(String parentProcessorNodeName, String processorNodeName, Collection<String> topics, ConsumedInternal<K, V> consumedInternal) {
        super(parentProcessorNodeName, processorNodeName, false);
        this.topics = topics;
        this.consumedInternal = consumedInternal;
    }

    StreamSourceNode(String parentProcessorNodeName, String processorNodeName, Pattern topicPattern, ConsumedInternal<K, V> consumedInternal) {
        super(parentProcessorNodeName, processorNodeName, false);
        this.topicPattern = topicPattern;
        this.consumedInternal = consumedInternal;
    }

    List<String> getTopics() {
        return new ArrayList<String>(this.topics);
    }

    Pattern getTopicPattern() {
        return this.topicPattern;
    }

    Serde<K> keySerde() {
        return this.consumedInternal.keySerde();
    }

    Deserializer<K> keyDeserializer() {
        return this.consumedInternal.keySerde() != null ? this.consumedInternal.keySerde().deserializer() : null;
    }

    TimestampExtractor timestampExtractor() {
        return this.consumedInternal.timestampExtractor();
    }

    Topology.AutoOffsetReset autoOffsetReset() {
        return this.consumedInternal.offsetResetPolicy();
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }
}

