/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

class WindowStoreIteratorWrapper<K, V> {
    private final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final StateSerdes<K, V> serdes;
    private final long windowSize;

    WindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes, long windowSize) {
        this.bytesIterator = bytesIterator;
        this.serdes = serdes;
        this.windowSize = windowSize;
    }

    public WindowStoreIterator<V> valuesIterator() {
        return new WrappedWindowStoreIterator<V>(this.bytesIterator, this.serdes);
    }

    public KeyValueIterator<Windowed<K>, V> keyValueIterator() {
        return new WrappedKeyValueIterator<K, V>(this.bytesIterator, this.serdes, this.windowSize);
    }

    private static class WrappedKeyValueIterator<K, V>
    implements KeyValueIterator<Windowed<K>, V> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final StateSerdes<K, V> serdes;
        final long windowSize;

        WrappedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes, long windowSize) {
            this.bytesIterator = bytesIterator;
            this.serdes = serdes;
            this.windowSize = windowSize;
        }

        @Override
        public Windowed<K> peekNextKey() {
            byte[] nextKey = this.bytesIterator.peekNextKey().get();
            long timestamp = WindowKeySchema.extractStoreTimestamp(nextKey);
            K key = WindowKeySchema.extractStoreKey(nextKey, this.serdes);
            return new Windowed<K>(key, WindowKeySchema.timeWindowForSize(timestamp, this.windowSize));
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Windowed<K>, V> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = WindowKeySchema.extractStoreTimestamp(((Bytes)next.key).get());
            K key = WindowKeySchema.extractStoreKey(((Bytes)next.key).get(), this.serdes);
            V value = this.serdes.valueFrom((byte[])next.value);
            return KeyValue.pair(new Windowed<K>(key, WindowKeySchema.timeWindowForSize(timestamp, this.windowSize)), value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }

    private static class WrappedWindowStoreIterator<V>
    implements WindowStoreIterator<V> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final StateSerdes<?, V> serdes;

        WrappedWindowStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<?, V> serdes) {
            this.bytesIterator = bytesIterator;
            this.serdes = serdes;
        }

        @Override
        public Long peekNextKey() {
            return WindowKeySchema.extractStoreTimestamp(this.bytesIterator.peekNextKey().get());
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Long, V> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = WindowKeySchema.extractStoreTimestamp(((Bytes)next.key).get());
            V value = this.serdes.valueFrom((byte[])next.value);
            return KeyValue.pair(timestamp, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }
}

