/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.RecordContext;

public class ProcessorRecordContext
implements RecordContext {
    long timestamp;
    final long offset;
    final String topic;
    final int partition;
    final Headers headers;

    public ProcessorRecordContext(long timestamp, long offset, int partition, String topic, Headers headers) {
        this.timestamp = timestamp;
        this.offset = offset;
        this.topic = topic;
        this.partition = partition;
        this.headers = headers;
    }

    public ProcessorRecordContext(long timestamp, long offset, int partition, String topic) {
        this(timestamp, offset, partition, topic, null);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public long sizeBytes() {
        long size = 0L;
        size += 8L;
        size += 8L;
        if (this.topic != null) {
            size += (long)this.topic.toCharArray().length;
        }
        size += 4L;
        if (this.headers != null) {
            for (Header header : this.headers) {
                size += (long)header.key().toCharArray().length;
                size += (long)header.value().length;
            }
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorRecordContext that = (ProcessorRecordContext)o;
        return this.timestamp == that.timestamp && this.offset == that.offset && this.partition == that.partition && Objects.equals(this.topic, that.topic) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.offset, this.topic, this.partition, this.headers);
    }
}

