/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.OrderedBytes;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.Segments;

public class SessionKeySchema
implements SegmentedBytesStore.KeySchema {
    private static final int TIMESTAMP_SIZE = 8;
    private static final int SUFFIX_SIZE = 16;
    private static final byte[] MIN_SUFFIX = new byte[16];

    @Override
    public Bytes upperRangeFixedSize(Bytes key, long to) {
        Windowed<Bytes> sessionKey = new Windowed<Bytes>(key, new SessionWindow(to, Long.MAX_VALUE));
        return Bytes.wrap((byte[])SessionKeySchema.toBinary(sessionKey));
    }

    @Override
    public Bytes lowerRangeFixedSize(Bytes key, long from) {
        Windowed<Bytes> sessionKey = new Windowed<Bytes>(key, new SessionWindow(0L, Math.max(0L, from)));
        return Bytes.wrap((byte[])SessionKeySchema.toBinary(sessionKey));
    }

    @Override
    public Bytes upperRange(Bytes key, long to) {
        byte[] maxSuffix = ByteBuffer.allocate(16).putLong(Long.MAX_VALUE).putLong(to).array();
        return OrderedBytes.upperRange(key, maxSuffix);
    }

    @Override
    public Bytes lowerRange(Bytes key, long from) {
        return OrderedBytes.lowerRange(key, MIN_SUFFIX);
    }

    @Override
    public long segmentTimestamp(Bytes key) {
        return SessionKeySchema.extractEndTimestamp(key.get());
    }

    @Override
    public HasNextCondition hasNextCondition(final Bytes binaryKeyFrom, final Bytes binaryKeyTo, final long from, final long to) {
        return new HasNextCondition(){

            @Override
            public boolean hasNext(KeyValueIterator<Bytes, ?> iterator) {
                while (iterator.hasNext()) {
                    Bytes bytes = iterator.peekNextKey();
                    Windowed<Bytes> windowedKey = SessionKeySchema.from(bytes);
                    if (!(binaryKeyFrom != null && windowedKey.key().compareTo(binaryKeyFrom) < 0 || binaryKeyTo != null && windowedKey.key().compareTo(binaryKeyTo) > 0 || windowedKey.window().end() < from || windowedKey.window().start() > to)) {
                        return true;
                    }
                    iterator.next();
                }
                return false;
            }
        };
    }

    @Override
    public List<Segment> segmentsToSearch(Segments segments, long from, long to) {
        return segments.segments(from, Long.MAX_VALUE);
    }

    private static <K> K extractKey(byte[] binaryKey, Deserializer<K> deserializer, String topic) {
        return (K)deserializer.deserialize(topic, SessionKeySchema.extractKeyBytes(binaryKey));
    }

    public static byte[] extractKeyBytes(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 16];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return bytes;
    }

    public static long extractEndTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 16);
    }

    public static long extractStartTimestamp(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8);
    }

    public static Window extractWindow(byte[] binaryKey) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8);
        long end = buffer.getLong(binaryKey.length - 16);
        return new SessionWindow(start, end);
    }

    public static <K> Windowed<K> from(byte[] binaryKey, Deserializer<K> keyDeserializer, String topic) {
        K key = SessionKeySchema.extractKey(binaryKey, keyDeserializer, topic);
        Window window = SessionKeySchema.extractWindow(binaryKey);
        return new Windowed<K>(key, window);
    }

    public static Windowed<Bytes> from(Bytes bytesKey) {
        byte[] binaryKey = bytesKey.get();
        Window window = SessionKeySchema.extractWindow(binaryKey);
        return new Windowed<Bytes>(Bytes.wrap((byte[])SessionKeySchema.extractKeyBytes(binaryKey)), window);
    }

    public static <K> byte[] toBinary(Windowed<K> sessionKey, Serializer<K> serializer, String topic) {
        byte[] bytes = serializer.serialize(topic, sessionKey.key());
        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 16);
        buf.put(bytes);
        buf.putLong(sessionKey.window().end());
        buf.putLong(sessionKey.window().start());
        return buf.array();
    }

    public static byte[] toBinary(Windowed<Bytes> sessionKey) {
        byte[] bytes = sessionKey.key().get();
        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 16);
        buf.put(bytes);
        buf.putLong(sessionKey.window().end());
        buf.putLong(sessionKey.window().start());
        return buf.array();
    }
}

