/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.state.internals.ContextualRecord;

public final class BufferValue {
    private final ContextualRecord record;
    private final byte[] priorValue;

    BufferValue(ContextualRecord record, byte[] priorValue) {
        this.record = record;
        this.priorValue = priorValue;
    }

    ContextualRecord record() {
        return this.record;
    }

    byte[] priorValue() {
        return this.priorValue;
    }

    static BufferValue deserialize(ByteBuffer buffer) {
        ContextualRecord record = ContextualRecord.deserialize(buffer);
        int priorValueLength = buffer.getInt();
        if (priorValueLength == -1) {
            return new BufferValue(record, null);
        }
        byte[] priorValue = new byte[priorValueLength];
        buffer.get(priorValue);
        return new BufferValue(record, priorValue);
    }

    ByteBuffer serialize(int endPadding) {
        int sizeOfPriorValueLength = 4;
        int sizeOfPriorValue = this.priorValue == null ? 0 : this.priorValue.length;
        ByteBuffer buffer = this.record.serialize(4 + sizeOfPriorValue + endPadding);
        if (this.priorValue == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(this.priorValue.length);
            buffer.put(this.priorValue);
        }
        return buffer;
    }

    long sizeBytes() {
        return (long)(this.priorValue == null ? 0 : this.priorValue.length) + this.record.sizeBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferValue that = (BufferValue)o;
        return Objects.equals(this.record, that.record) && Arrays.equals(this.priorValue, that.priorValue);
    }

    public int hashCode() {
        int result = Objects.hash(this.record);
        result = 31 * result + Arrays.hashCode(this.priorValue);
        return result;
    }

    public String toString() {
        return "BufferValue{record=" + this.record + ", priorValue=" + Arrays.toString(this.priorValue) + '}';
    }
}

