/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;

public interface Task {
    public static final long LATEST_OFFSET = -2L;

    public TaskId id();

    public State state();

    default public boolean needsInitializationOrRestoration() {
        return this.state() == State.CREATED || this.state() == State.RESTORING;
    }

    public boolean isActive();

    public boolean isClosed();

    public void initializeIfNeeded();

    public void completeRestoration();

    public void addRecords(TopicPartition var1, Iterable<ConsumerRecord<byte[], byte[]>> var2);

    public boolean commitNeeded();

    public Map<TopicPartition, OffsetAndMetadata> prepareCommit();

    public void postCommit();

    public void suspend();

    public void resume();

    public void closeClean();

    public void closeDirty();

    public void update(Set<TopicPartition> var1, Map<String, List<String>> var2);

    public void closeCleanAndRecycleState();

    public void revive();

    public StateStore getStore(String var1);

    public Set<TopicPartition> inputPartitions();

    public Collection<TopicPartition> changelogPartitions();

    public Map<TopicPartition, Long> changelogOffsets();

    public void markChangelogAsCorrupted(Collection<TopicPartition> var1);

    default public Map<TopicPartition, Long> purgeableOffsets() {
        return Collections.emptyMap();
    }

    default public void recordProcessBatchTime(long processBatchTime) {
    }

    default public void recordProcessTimeRatioAndBufferSize(long allTaskProcessMs, long now) {
    }

    default public boolean process(long wallClockTime) {
        return false;
    }

    default public boolean commitRequested() {
        return false;
    }

    default public boolean maybePunctuateStreamTime() {
        return false;
    }

    default public boolean maybePunctuateSystemTime() {
        return false;
    }

    public static enum TaskType {
        ACTIVE("ACTIVE"),
        STANDBY("STANDBY"),
        GLOBAL("GLOBAL");

        public final String name;

        private TaskType(String name) {
            this.name = name;
        }
    }

    public static enum State {
        CREATED(1, 3),
        RESTORING(2, 3),
        RUNNING(3),
        SUSPENDED(1, 4),
        CLOSED(0);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isValidTransition(State newState) {
            return this.validTransitions.contains(newState.ordinal());
        }
    }
}

