/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class RocksDBMetrics {
    private static final String BYTES_WRITTEN_TO_DB = "bytes-written";
    private static final String BYTES_READ_FROM_DB = "bytes-read";
    private static final String MEMTABLE_BYTES_FLUSHED = "memtable-bytes-flushed";
    private static final String MEMTABLE_HIT_RATIO = "memtable-hit-ratio";
    private static final String MEMTABLE_FLUSH_TIME = "memtable-flush-time";
    private static final String MEMTABLE_FLUSH_TIME_AVG = "memtable-flush-time-avg";
    private static final String MEMTABLE_FLUSH_TIME_MIN = "memtable-flush-time-min";
    private static final String MEMTABLE_FLUSH_TIME_MAX = "memtable-flush-time-max";
    private static final String WRITE_STALL_DURATION = "write-stall-duration";
    private static final String BLOCK_CACHE_DATA_HIT_RATIO = "block-cache-data-hit-ratio";
    private static final String BLOCK_CACHE_INDEX_HIT_RATIO = "block-cache-index-hit-ratio";
    private static final String BLOCK_CACHE_FILTER_HIT_RATIO = "block-cache-filter-hit-ratio";
    private static final String BYTES_READ_DURING_COMPACTION = "bytes-read-compaction";
    private static final String BYTES_WRITTEN_DURING_COMPACTION = "bytes-written-compaction";
    private static final String COMPACTION_TIME = "compaction-time";
    private static final String COMPACTION_TIME_AVG = "compaction-time-avg";
    private static final String COMPACTION_TIME_MIN = "compaction-time-min";
    private static final String COMPACTION_TIME_MAX = "compaction-time-max";
    private static final String NUMBER_OF_OPEN_FILES = "number-open-files";
    private static final String NUMBER_OF_FILE_ERRORS = "number-file-errors";
    private static final String BYTES_WRITTEN_TO_DB_RATE_DESCRIPTION = "Average number of bytes written per second to the RocksDB state store";
    private static final String BYTES_WRITTEN_TO_DB_TOTAL_DESCRIPTION = "Total number of bytes written to the RocksDB state store";
    private static final String BYTES_READ_FROM_DB_RATE_DESCRIPTION = "Average number of bytes read per second from the RocksDB state store";
    private static final String BYTES_READ_FROM_DB_TOTAL_DESCRIPTION = "Total number of bytes read from the RocksDB state store";
    private static final String MEMTABLE_BYTES_FLUSHED_RATE_DESCRIPTION = "Average number of bytes flushed per second from the memtable to disk";
    private static final String MEMTABLE_BYTES_FLUSHED_TOTAL_DESCRIPTION = "Total number of bytes flushed from the memtable to disk";
    private static final String MEMTABLE_HIT_RATIO_DESCRIPTION = "Ratio of memtable hits relative to all lookups to the memtable";
    private static final String MEMTABLE_FLUSH_TIME_AVG_DESCRIPTION = "Average time spent on flushing the memtable to disk in ms";
    private static final String MEMTABLE_FLUSH_TIME_MIN_DESCRIPTION = "Minimum time spent on flushing the memtable to disk in ms";
    private static final String MEMTABLE_FLUSH_TIME_MAX_DESCRIPTION = "Maximum time spent on flushing the memtable to disk in ms";
    private static final String WRITE_STALL_DURATION_AVG_DESCRIPTION = "Average duration of write stalls in ms";
    private static final String WRITE_STALL_DURATION_TOTAL_DESCRIPTION = "Total duration of write stalls in ms";
    private static final String BLOCK_CACHE_DATA_HIT_RATIO_DESCRIPTION = "Ratio of block cache hits for data relative to all lookups for data to the block cache";
    private static final String BLOCK_CACHE_INDEX_HIT_RATIO_DESCRIPTION = "Ratio of block cache hits for indexes relative to all lookups for indexes to the block cache";
    private static final String BLOCK_CACHE_FILTER_HIT_RATIO_DESCRIPTION = "Ratio of block cache hits for filters relative to all lookups for filters to the block cache";
    private static final String BYTES_READ_DURING_COMPACTION_DESCRIPTION = "Average number of bytes read per second during compaction";
    private static final String BYTES_WRITTEN_DURING_COMPACTION_DESCRIPTION = "Average number of bytes written per second during compaction";
    private static final String COMPACTION_TIME_AVG_DESCRIPTION = "Average time spent on compaction in ms";
    private static final String COMPACTION_TIME_MIN_DESCRIPTION = "Minimum time spent on compaction in ms";
    private static final String COMPACTION_TIME_MAX_DESCRIPTION = "Maximum time spent on compaction in ms";
    private static final String NUMBER_OF_OPEN_FILES_DESCRIPTION = "Number of currently open files";
    private static final String NUMBER_OF_FILE_ERRORS_DESCRIPTION = "Total number of file errors occurred";

    private RocksDBMetrics() {
    }

    public static Sensor bytesWrittenToDatabaseSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BYTES_WRITTEN_TO_DB);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BYTES_WRITTEN_TO_DB, BYTES_WRITTEN_TO_DB_RATE_DESCRIPTION, BYTES_WRITTEN_TO_DB_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor bytesReadFromDatabaseSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BYTES_READ_FROM_DB);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BYTES_READ_FROM_DB, BYTES_READ_FROM_DB_RATE_DESCRIPTION, BYTES_READ_FROM_DB_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor memtableBytesFlushedSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, MEMTABLE_BYTES_FLUSHED);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), MEMTABLE_BYTES_FLUSHED, MEMTABLE_BYTES_FLUSHED_RATE_DESCRIPTION, MEMTABLE_BYTES_FLUSHED_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor memtableHitRatioSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, MEMTABLE_HIT_RATIO);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), MEMTABLE_HIT_RATIO, MEMTABLE_HIT_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor memtableAvgFlushTimeSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, MEMTABLE_FLUSH_TIME_AVG);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), MEMTABLE_FLUSH_TIME_AVG, MEMTABLE_FLUSH_TIME_AVG_DESCRIPTION);
        return sensor;
    }

    public static Sensor memtableMinFlushTimeSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, MEMTABLE_FLUSH_TIME_MIN);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), MEMTABLE_FLUSH_TIME_MIN, MEMTABLE_FLUSH_TIME_MIN_DESCRIPTION);
        return sensor;
    }

    public static Sensor memtableMaxFlushTimeSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, MEMTABLE_FLUSH_TIME_MAX);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), MEMTABLE_FLUSH_TIME_MAX, MEMTABLE_FLUSH_TIME_MAX_DESCRIPTION);
        return sensor;
    }

    public static Sensor writeStallDurationSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, WRITE_STALL_DURATION);
        StreamsMetricsImpl.addAvgAndSumMetricsToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), WRITE_STALL_DURATION, WRITE_STALL_DURATION_AVG_DESCRIPTION, WRITE_STALL_DURATION_TOTAL_DESCRIPTION);
        return sensor;
    }

    public static Sensor blockCacheDataHitRatioSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BLOCK_CACHE_DATA_HIT_RATIO);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BLOCK_CACHE_DATA_HIT_RATIO, BLOCK_CACHE_DATA_HIT_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor blockCacheIndexHitRatioSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BLOCK_CACHE_INDEX_HIT_RATIO);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BLOCK_CACHE_INDEX_HIT_RATIO, BLOCK_CACHE_INDEX_HIT_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor blockCacheFilterHitRatioSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BLOCK_CACHE_FILTER_HIT_RATIO);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BLOCK_CACHE_FILTER_HIT_RATIO, BLOCK_CACHE_FILTER_HIT_RATIO_DESCRIPTION);
        return sensor;
    }

    public static Sensor bytesReadDuringCompactionSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BYTES_READ_DURING_COMPACTION);
        StreamsMetricsImpl.addRateOfSumMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BYTES_READ_DURING_COMPACTION, BYTES_READ_DURING_COMPACTION_DESCRIPTION);
        return sensor;
    }

    public static Sensor bytesWrittenDuringCompactionSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, BYTES_WRITTEN_DURING_COMPACTION);
        StreamsMetricsImpl.addRateOfSumMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), BYTES_WRITTEN_DURING_COMPACTION, BYTES_WRITTEN_DURING_COMPACTION_DESCRIPTION);
        return sensor;
    }

    public static Sensor compactionTimeAvgSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, COMPACTION_TIME_AVG);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), COMPACTION_TIME_AVG, COMPACTION_TIME_AVG_DESCRIPTION);
        return sensor;
    }

    public static Sensor compactionTimeMinSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, COMPACTION_TIME_MIN);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), COMPACTION_TIME_MIN, COMPACTION_TIME_MIN_DESCRIPTION);
        return sensor;
    }

    public static Sensor compactionTimeMaxSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, COMPACTION_TIME_MAX);
        StreamsMetricsImpl.addValueMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), COMPACTION_TIME_MAX, COMPACTION_TIME_MAX_DESCRIPTION);
        return sensor;
    }

    public static Sensor numberOfOpenFilesSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, NUMBER_OF_OPEN_FILES);
        StreamsMetricsImpl.addSumMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), NUMBER_OF_OPEN_FILES, false, NUMBER_OF_OPEN_FILES_DESCRIPTION);
        return sensor;
    }

    public static Sensor numberOfFileErrorsSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext) {
        Sensor sensor = RocksDBMetrics.createSensor(streamsMetrics, metricContext, NUMBER_OF_FILE_ERRORS);
        StreamsMetricsImpl.addSumMetricToSensor(sensor, "stream-state-metrics", streamsMetrics.storeLevelTagMap(metricContext.threadId(), metricContext.taskName(), metricContext.metricsScope(), metricContext.storeName()), NUMBER_OF_FILE_ERRORS, NUMBER_OF_FILE_ERRORS_DESCRIPTION);
        return sensor;
    }

    private static Sensor createSensor(StreamsMetricsImpl streamsMetrics, RocksDBMetricContext metricContext, String sensorName) {
        return streamsMetrics.storeLevelSensor(metricContext.threadId(), metricContext.taskName(), metricContext.storeName(), sensorName, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
    }

    public static class RocksDBMetricContext {
        private final String threadId;
        private final String taskName;
        private final String metricsScope;
        private final String storeName;

        public RocksDBMetricContext(String threadId, String taskName, String metricsScope, String storeName) {
            this.threadId = threadId;
            this.taskName = taskName;
            this.metricsScope = metricsScope;
            this.storeName = storeName;
        }

        public String threadId() {
            return this.threadId;
        }

        public String taskName() {
            return this.taskName;
        }

        public String metricsScope() {
            return this.metricsScope;
        }

        public String storeName() {
            return this.storeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RocksDBMetricContext that = (RocksDBMetricContext)o;
            return Objects.equals(this.threadId, that.threadId) && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.metricsScope, that.metricsScope) && Objects.equals(this.storeName, that.storeName);
        }

        public int hashCode() {
            return Objects.hash(this.threadId, this.taskName, this.metricsScope, this.storeName);
        }
    }
}

