/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;

public class SinkNode<KIn, VIn, KOut, VOut>
extends ProcessorNode<KIn, VIn, KOut, VOut> {
    private Serializer<KIn> keySerializer;
    private Serializer<VIn> valSerializer;
    private final TopicNameExtractor<KIn, VIn> topicExtractor;
    private final StreamPartitioner<? super KIn, ? super VIn> partitioner;
    private InternalProcessorContext context;

    SinkNode(String name, TopicNameExtractor<KIn, VIn> topicExtractor, Serializer<KIn> keySerializer, Serializer<VIn> valSerializer, StreamPartitioner<? super KIn, ? super VIn> partitioner) {
        super(name);
        this.topicExtractor = topicExtractor;
        this.keySerializer = keySerializer;
        this.valSerializer = valSerializer;
        this.partitioner = partitioner;
    }

    @Override
    public void addChild(ProcessorNode<KOut, VOut, ?, ?> child) {
        throw new UnsupportedOperationException("sink node does not allow addChild");
    }

    @Override
    public void init(InternalProcessorContext context) {
        super.init(context);
        this.context = context;
        Serializer<?> contextKeySerializer = ProcessorContextUtils.getKeySerializer(context);
        Serializer<?> contextValueSerializer = ProcessorContextUtils.getValueSerializer(context);
        this.keySerializer = WrappingNullableUtils.prepareKeySerializer(this.keySerializer, contextKeySerializer, contextValueSerializer);
        this.valSerializer = WrappingNullableUtils.prepareValueSerializer(this.valSerializer, contextKeySerializer, contextValueSerializer);
    }

    @Override
    public void process(Record<KIn, VIn> record) {
        RecordCollector collector = ((RecordCollector.Supplier)((Object)this.context)).recordCollector();
        KIn key = record.key();
        VIn value = record.value();
        long timestamp = record.timestamp();
        ProcessorRecordContext contextForExtraction = new ProcessorRecordContext(timestamp, this.context.offset(), this.context.partition(), this.context.topic(), record.headers());
        String topic = this.topicExtractor.extract(key, value, contextForExtraction);
        collector.send(topic, key, value, record.headers(), timestamp, this.keySerializer, this.valSerializer, this.partitioner);
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        sb.append(indent).append("\ttopic:\t\t");
        sb.append(this.topicExtractor);
        sb.append("\n");
        return sb.toString();
    }
}

