/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class ProcessorNodeMetrics {
    private static final String AVG_DESCRIPTION_PREFIX = "The average ";
    private static final String MAX_DESCRIPTION_PREFIX = "The maximum ";
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String LATENCY_DESCRIPTION = "latency of ";
    private static final String AVG_LATENCY_DESCRIPTION_PREFIX = "The average latency of ";
    private static final String MAX_LATENCY_DESCRIPTION_PREFIX = "The maximum latency of ";
    private static final String SUPPRESSION_EMIT = "suppression-emit";
    private static final String SUPPRESSION_EMIT_DESCRIPTION = "emitted records from the suppression buffer";
    private static final String SUPPRESSION_EMIT_TOTAL_DESCRIPTION = "The total number of emitted records from the suppression buffer";
    private static final String SUPPRESSION_EMIT_RATE_DESCRIPTION = "The average number of emitted records from the suppression buffer per second";
    private static final String IDEMPOTENT_UPDATE_SKIP = "idempotent-update-skip";
    private static final String IDEMPOTENT_UPDATE_SKIP_DESCRIPTION = "skipped idempotent updates";
    private static final String IDEMPOTENT_UPDATE_SKIP_TOTAL_DESCRIPTION = "The total number of skipped idempotent updates";
    private static final String IDEMPOTENT_UPDATE_SKIP_RATE_DESCRIPTION = "The average number of skipped idempotent updates per second";
    private static final String PROCESS = "process";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_TOTAL_DESCRIPTION = "The total number of calls to process";
    private static final String PROCESS_RATE_DESCRIPTION = "The average number of calls to process per second";
    private static final String PROCESS_AVG_LATENCY_DESCRIPTION = "The average latency of calls to process";
    private static final String PROCESS_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to process";
    private static final String PUNCTUATE = "punctuate";
    private static final String PUNCTUATE_DESCRIPTION = "calls to punctuate";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of calls to punctuate";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average number of calls to punctuate per second";
    private static final String PUNCTUATE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to punctuate";
    private static final String PUNCTUATE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to punctuate";
    private static final String CREATE = "create";
    private static final String CREATE_DESCRIPTION1 = "processor nodes created";
    private static final String CREATE_DESCRIPTION2 = "creations of processor nodes";
    private static final String CREATE_TOTAL_DESCRIPTION = "The total number of processor nodes created";
    private static final String CREATE_RATE_DESCRIPTION = "The average number of processor nodes created per second";
    private static final String CREATE_AVG_LATENCY_DESCRIPTION = "The average latency of creations of processor nodes";
    private static final String CREATE_MAX_LATENCY_DESCRIPTION = "The maximum latency of creations of processor nodes";
    private static final String DESTROY = "destroy";
    private static final String DESTROY_DESCRIPTION = "destructions of processor nodes";
    private static final String DESTROY_TOTAL_DESCRIPTION = "The total number of destructions of processor nodes";
    private static final String DESTROY_RATE_DESCRIPTION = "The average number of destructions of processor nodes per second";
    private static final String DESTROY_AVG_LATENCY_DESCRIPTION = "The average latency of destructions of processor nodes";
    private static final String DESTROY_MAX_LATENCY_DESCRIPTION = "The maximum latency of destructions of processor nodes";
    private static final String FORWARD = "forward";
    private static final String FORWARD_DESCRIPTION = "calls to forward";
    private static final String FORWARD_TOTAL_DESCRIPTION = "The total number of calls to forward";
    private static final String FORWARD_RATE_DESCRIPTION = "The average number of calls to forward per second";
    private static final String LATE_RECORD_DROP = "late-record-drop";
    private static final String LATE_RECORD_DROP_DESCRIPTION = "dropped late records";
    private static final String LATE_RECORD_DROP_TOTAL_DESCRIPTION = "The total number of dropped late records";
    private static final String LATE_RECORD_DROP_RATE_DESCRIPTION = "The average number of dropped late records per second";

    private ProcessorNodeMetrics() {
    }

    public static Sensor suppressionEmitSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, SUPPRESSION_EMIT, SUPPRESSION_EMIT_RATE_DESCRIPTION, SUPPRESSION_EMIT_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor skippedIdempotentUpdatesSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, IDEMPOTENT_UPDATE_SKIP, IDEMPOTENT_UPDATE_SKIP_RATE_DESCRIPTION, IDEMPOTENT_UPDATE_SKIP_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor processSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.throughputAndLatencySensorWithParent(threadId, taskId, processorNodeId, PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION, PROCESS_AVG_LATENCY_DESCRIPTION, PROCESS_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        }
        return ProcessorNodeMetrics.emptySensor(threadId, taskId, processorNodeId, PROCESS, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor processAtSourceSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        Sensor parentSensor = streamsMetrics.taskLevelSensor(threadId, taskId, PROCESS, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(parentSensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION);
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor punctuateSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.throughputAndLatencySensorWithParent(threadId, taskId, processorNodeId, PUNCTUATE, PUNCTUATE_RATE_DESCRIPTION, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_AVG_LATENCY_DESCRIPTION, PUNCTUATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        }
        return ProcessorNodeMetrics.emptySensor(threadId, taskId, processorNodeId, PUNCTUATE, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor createSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.throughputAndLatencySensorWithParent(threadId, taskId, processorNodeId, CREATE, CREATE_RATE_DESCRIPTION, CREATE_TOTAL_DESCRIPTION, CREATE_AVG_LATENCY_DESCRIPTION, CREATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        }
        return ProcessorNodeMetrics.emptySensor(threadId, taskId, processorNodeId, CREATE, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor destroySensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.throughputAndLatencySensorWithParent(threadId, taskId, processorNodeId, DESTROY, DESTROY_RATE_DESCRIPTION, DESTROY_TOTAL_DESCRIPTION, DESTROY_AVG_LATENCY_DESCRIPTION, DESTROY_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        }
        return ProcessorNodeMetrics.emptySensor(threadId, taskId, processorNodeId, DESTROY, Sensor.RecordingLevel.DEBUG, streamsMetrics);
    }

    public static Sensor forwardSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        Sensor parentSensor = ProcessorNodeMetrics.throughputParentSensor(threadId, taskId, FORWARD, FORWARD_RATE_DESCRIPTION, FORWARD_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, FORWARD, FORWARD_RATE_DESCRIPTION, FORWARD_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor lateRecordDropSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, LATE_RECORD_DROP, LATE_RECORD_DROP_RATE_DESCRIPTION, LATE_RECORD_DROP_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics, new Sensor[0]);
    }

    public static Sensor processorAtSourceSensorOrForwardSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.forwardSensor(threadId, taskId, processorNodeId, streamsMetrics);
        }
        return ProcessorNodeMetrics.processAtSourceSensor(threadId, taskId, processorNodeId, streamsMetrics);
    }

    public static Sensor e2ELatencySensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        String sensorName = processorNodeId + "-" + "record-e2e-latency";
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, sensorName, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor(sensor, "stream-processor-node-metrics", tagMap, "record-e2e-latency", "The average end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The minimum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The maximum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node");
        return sensor;
    }

    private static Sensor throughputAndLatencySensorWithParent(String threadId, String taskId, String processorNodeId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvgLatency, String descriptionOfMaxLatency, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor parentSensor = ProcessorNodeMetrics.throughputAndLatencyParentSensor(threadId, taskId, metricNamePrefix, descriptionOfRate, descriptionOfCount, descriptionOfAvgLatency, descriptionOfMaxLatency, recordingLevel, streamsMetrics);
        return ProcessorNodeMetrics.throughputAndLatencySensor(threadId, taskId, processorNodeId, metricNamePrefix, descriptionOfRate, descriptionOfCount, descriptionOfAvgLatency, descriptionOfMaxLatency, recordingLevel, streamsMetrics, parentSensor);
    }

    private static Sensor throughputAndLatencyParentSensor(String threadId, String taskId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvgLatency, String descriptionOfMaxLatency, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricNamePrefix, recordingLevel, new Sensor[0]);
        Map<String, String> parentTagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, "all");
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-processor-node-metrics", parentTagMap, metricNamePrefix + "-latency", descriptionOfAvgLatency, descriptionOfMaxLatency);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", parentTagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor throughputParentSensor(String threadId, String taskId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricNamePrefix, recordingLevel, new Sensor[0]);
        Map<String, String> parentTagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, "all");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", parentTagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor throughputSensor(String threadId, String taskId, String processorNodeId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, metricNamePrefix, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", tagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor throughputAndLatencySensor(String threadId, String taskId, String processorNodeId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, metricNamePrefix, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-processor-node-metrics", tagMap, metricNamePrefix + "-latency", descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", tagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor emptySensor(String threadId, String taskId, String processorNodeId, String metricNamePrefix, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        return streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, metricNamePrefix, recordingLevel, new Sensor[0]);
    }
}

