/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKeyValueStore
implements KeyValueStore<Bytes, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryKeyValueStore.class);
    private final String name;
    private final NavigableMap<Bytes, byte[]> map = new TreeMap<Bytes, byte[]>();
    private volatile boolean open = false;
    private long size = 0L;

    public InMemoryKeyValueStore(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.size = 0L;
        if (root != null) {
            context.register(root, (key, value) -> this.put(Bytes.wrap((byte[])key), value));
        }
        this.open = true;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized byte[] get(Bytes key) {
        return (byte[])this.map.get(key);
    }

    @Override
    public synchronized void put(Bytes key, byte[] value) {
        this.size = value == null ? (this.size -= this.map.remove(key) == null ? 0L : 1L) : (this.size += this.map.put(key, value) == null ? 1L : 0L);
    }

    @Override
    public synchronized byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            this.put((Bytes)entry.key, (byte[])entry.value);
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        Objects.requireNonNull(prefix, "prefix cannot be null");
        Objects.requireNonNull(prefixKeySerializer, "prefixKeySerializer cannot be null");
        Bytes from = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        Bytes to = Bytes.increment((Bytes)from);
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.subMap(from, true, to, false).keySet(), true));
    }

    @Override
    public synchronized byte[] delete(Bytes key) {
        byte[] oldValue = (byte[])this.map.remove(key);
        this.size -= oldValue == null ? 0L : 1L;
        return oldValue;
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return this.range(from, to, true);
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        return this.range(from, to, false);
    }

    private KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to, boolean forward) {
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.subMap(from, true, to, true).keySet(), forward));
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> all() {
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.keySet(), true));
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> reverseAll() {
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.keySet(), false));
    }

    @Override
    public long approximateNumEntries() {
        return this.size;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.map.clear();
        this.size = 0L;
        this.open = false;
    }

    private class InMemoryKeyValueIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final Iterator<Bytes> iter;

        private InMemoryKeyValueIterator(Set<Bytes> keySet, boolean forward) {
            this.iter = forward ? new TreeSet<Bytes>(keySet).iterator() : new TreeSet<Bytes>(keySet).descendingIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            Bytes key = this.iter.next();
            return new KeyValue<Bytes, byte[]>(key, (byte[])InMemoryKeyValueStore.this.map.get(key));
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

