/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.SegmentIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocksDBTimeOrderedSegmentedBytesStore
extends AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDualSchemaRocksDBSegmentedBytesStore.class);

    AbstractRocksDBTimeOrderedSegmentedBytesStore(String name, String metricsScope, long retention, long segmentInterval, SegmentedBytesStore.KeySchema baseKeySchema, Optional<SegmentedBytesStore.KeySchema> indexKeySchema) {
        super(name, baseKeySchema, indexKeySchema, new KeyValueSegments(name, metricsScope, retention, segmentInterval));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes key, long from, long to) {
        return this.fetch(key, from, to, true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> backwardFetch(Bytes key, long from, long to) {
        return this.fetch(key, from, to, false);
    }

    protected abstract IndexToBaseStoreIterator getIndexToBaseStoreIterator(SegmentIterator<KeyValueSegment> var1);

    KeyValueIterator<Bytes, byte[]> fetch(Bytes key, long from, long to, boolean forward) {
        if (this.indexKeySchema.isPresent()) {
            List searchSpace = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).segmentsToSearch(this.segments, from, to, forward);
            Bytes binaryFrom = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).lowerRangeFixedSize(key, from);
            Bytes binaryTo = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).upperRangeFixedSize(key, to);
            return this.getIndexToBaseStoreIterator(new SegmentIterator<KeyValueSegment>(searchSpace.iterator(), ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).hasNextCondition(key, key, from, to, forward), binaryFrom, binaryTo, forward));
        }
        List searchSpace = this.baseKeySchema.segmentsToSearch(this.segments, from, to, forward);
        Bytes binaryFrom = this.baseKeySchema.lowerRangeFixedSize(key, from);
        Bytes binaryTo = this.baseKeySchema.upperRangeFixedSize(key, to);
        return new SegmentIterator(searchSpace.iterator(), this.baseKeySchema.hasNextCondition(key, key, from, to, forward), binaryFrom, binaryTo, forward);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        return this.fetch(keyFrom, keyTo, from, to, true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> backwardFetch(Bytes keyFrom, Bytes keyTo, long from, long to) {
        return this.fetch(keyFrom, keyTo, from, to, false);
    }

    KeyValueIterator<Bytes, byte[]> fetch(Bytes keyFrom, Bytes keyTo, long from, long to, boolean forward) {
        if (keyFrom != null && keyTo != null && keyFrom.compareTo(keyTo) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        if (this.indexKeySchema.isPresent()) {
            List searchSpace = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).segmentsToSearch(this.segments, from, to, forward);
            Bytes binaryFrom = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).lowerRange(keyFrom, from);
            Bytes binaryTo = ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).upperRange(keyTo, to);
            return this.getIndexToBaseStoreIterator(new SegmentIterator<KeyValueSegment>(searchSpace.iterator(), ((SegmentedBytesStore.KeySchema)this.indexKeySchema.get()).hasNextCondition(keyFrom, keyTo, from, to, forward), binaryFrom, binaryTo, forward));
        }
        List searchSpace = this.baseKeySchema.segmentsToSearch(this.segments, from, to, forward);
        Bytes binaryFrom = this.baseKeySchema.lowerRange(keyFrom, from);
        Bytes binaryTo = this.baseKeySchema.upperRange(keyTo, to);
        return new SegmentIterator(searchSpace.iterator(), this.baseKeySchema.hasNextCondition(keyFrom, keyTo, from, to, forward), binaryFrom, binaryTo, forward);
    }

    @Override
    public void remove(Bytes key, long timestamp) {
        throw new UnsupportedOperationException("Not supported operation");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetchAll(long timeFrom, long timeTo) {
        List searchSpace = this.segments.segments(timeFrom, timeTo, true);
        Bytes binaryFrom = this.baseKeySchema.lowerRange(null, timeFrom);
        Bytes binaryTo = this.baseKeySchema.upperRange(null, timeTo);
        return new SegmentIterator(searchSpace.iterator(), this.baseKeySchema.hasNextCondition(null, null, timeFrom, timeTo, true), binaryFrom, binaryTo, true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> backwardFetchAll(long timeFrom, long timeTo) {
        List searchSpace = this.segments.segments(timeFrom, timeTo, false);
        Bytes binaryFrom = this.baseKeySchema.lowerRange(null, timeFrom);
        Bytes binaryTo = this.baseKeySchema.upperRange(null, timeTo);
        return new SegmentIterator(searchSpace.iterator(), this.baseKeySchema.hasNextCondition(null, null, timeFrom, timeTo, false), binaryFrom, binaryTo, false);
    }

    abstract class IndexToBaseStoreIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final KeyValueIterator<Bytes, byte[]> indexIterator;
        private byte[] cachedValue;

        IndexToBaseStoreIterator(KeyValueIterator<Bytes, byte[]> indexIterator) {
            this.indexIterator = indexIterator;
        }

        @Override
        public void close() {
            this.indexIterator.close();
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.getBaseKey(this.indexIterator.peekNextKey());
        }

        @Override
        public boolean hasNext() {
            while (this.indexIterator.hasNext()) {
                Bytes key = this.indexIterator.peekNextKey();
                Bytes baseKey = this.getBaseKey(key);
                this.cachedValue = AbstractRocksDBTimeOrderedSegmentedBytesStore.this.get(baseKey);
                if (this.cachedValue == null) {
                    this.indexIterator.next();
                    AbstractRocksDBTimeOrderedSegmentedBytesStore.this.removeIndex(key);
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            if (this.cachedValue == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyValue ret = (KeyValue)this.indexIterator.next();
            byte[] value = this.cachedValue;
            this.cachedValue = null;
            return KeyValue.pair(this.getBaseKey((Bytes)ret.key), value);
        }

        protected abstract Bytes getBaseKey(Bytes var1);
    }
}

