/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.Task;

public class TaskAndAction {
    private final Task task;
    private final TaskId taskId;
    private final Action action;

    private TaskAndAction(Task task, TaskId taskId, Action action) {
        this.task = task;
        this.taskId = taskId;
        this.action = action;
    }

    public static TaskAndAction createAddTask(Task task) {
        Objects.requireNonNull(task, "Task to add is null!");
        return new TaskAndAction(task, null, Action.ADD);
    }

    public static TaskAndAction createRemoveTask(TaskId taskId) {
        Objects.requireNonNull(taskId, "Task ID of task to remove is null!");
        return new TaskAndAction(null, taskId, Action.REMOVE);
    }

    public Task getTask() {
        if (this.action != Action.ADD) {
            throw new IllegalStateException("Action type " + (Object)((Object)this.action) + " cannot have a task!");
        }
        return this.task;
    }

    public TaskId getTaskId() {
        if (this.action != Action.REMOVE) {
            throw new IllegalStateException("Action type " + (Object)((Object)this.action) + " cannot have a task ID!");
        }
        return this.taskId;
    }

    public Action getAction() {
        return this.action;
    }

    static enum Action {
        ADD,
        REMOVE;

    }
}

