/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.NamedVariableImpact;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.attribute.expression.language.compile.CompiledExpression;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AllAttributesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AnyAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MappingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiMatchAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiNamedAttributeEvaluator;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.processor.exception.ProcessException;

public class StandardPreparedQuery
implements PreparedQuery {
    private final List<String> queryStrings;
    private final Map<String, CompiledExpression> expressions;
    private volatile VariableImpact variableImpact;

    public StandardPreparedQuery(List<String> queryStrings, Map<String, CompiledExpression> expressions) {
        this.queryStrings = queryStrings;
        this.expressions = expressions;
    }

    @Override
    public String evaluateExpressions(Map<String, String> valMap, AttributeValueDecorator decorator, Map<String, String> stateVariables) throws ProcessException {
        StringBuilder sb = new StringBuilder();
        for (String val : this.queryStrings) {
            CompiledExpression expression = this.expressions.get(val);
            if (expression == null) {
                sb.append(val);
                continue;
            }
            String evaluated = Query.evaluateExpression(expression.getTree(), val, valMap, decorator, stateVariables);
            if (evaluated == null) continue;
            sb.append(evaluated);
        }
        return sb.toString();
    }

    @Override
    public String evaluateExpressions(Map<String, String> valMap, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateExpressions(valMap, decorator, null);
    }

    @Override
    public boolean isExpressionLanguagePresent() {
        return !this.expressions.isEmpty();
    }

    @Override
    public VariableImpact getVariableImpact() {
        VariableImpact existing = this.variableImpact;
        if (existing != null) {
            return existing;
        }
        HashSet<String> variables = new HashSet<String>();
        for (CompiledExpression expression : this.expressions.values()) {
            for (Evaluator<?> evaluator : expression.getAllEvaluators()) {
                MultiAttributeEvaluator iteratingEval;
                Evaluator<Boolean> allAttrsEval;
                if (evaluator instanceof AttributeEvaluator) {
                    AttributeEvaluator attributeEval = (AttributeEvaluator)evaluator;
                    Evaluator<String> nameEval = attributeEval.getNameEvaluator();
                    if (!(nameEval instanceof StringLiteralEvaluator)) continue;
                    String referencedVar = nameEval.evaluate(Collections.emptyMap()).getValue();
                    variables.add(referencedVar);
                    continue;
                }
                if (evaluator instanceof AllAttributesEvaluator) {
                    allAttrsEval = (AllAttributesEvaluator)evaluator;
                    iteratingEval = ((AllAttributesEvaluator)allAttrsEval).getVariableIteratingEvaluator();
                    if (iteratingEval instanceof MultiNamedAttributeEvaluator) {
                        variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
                        continue;
                    }
                    if (!(iteratingEval instanceof MultiMatchAttributeEvaluator)) continue;
                    return VariableImpact.ALWAYS_IMPACTED;
                }
                if (evaluator instanceof AnyAttributeEvaluator) {
                    allAttrsEval = (AnyAttributeEvaluator)evaluator;
                    iteratingEval = ((AnyAttributeEvaluator)allAttrsEval).getVariableIteratingEvaluator();
                    if (iteratingEval instanceof MultiNamedAttributeEvaluator) {
                        variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
                        continue;
                    }
                    if (!(iteratingEval instanceof MultiMatchAttributeEvaluator)) continue;
                    return VariableImpact.ALWAYS_IMPACTED;
                }
                if (!(evaluator instanceof MappingEvaluator) || !((iteratingEval = ((MappingEvaluator)(allAttrsEval = (MappingEvaluator)evaluator)).getVariableIteratingEvaluator()) instanceof MultiNamedAttributeEvaluator)) continue;
                variables.addAll(((MultiNamedAttributeEvaluator)iteratingEval).getAttributeNames());
            }
        }
        NamedVariableImpact impact = new NamedVariableImpact(variables);
        this.variableImpact = impact;
        return impact;
    }
}

