/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.DecimalEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DecimalQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.util.NumberParsing;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class DecimalCastEvaluator
extends DecimalEvaluator {
    private final Evaluator<?> subjectEvaluator;

    public DecimalCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + subjectEvaluator.getResultType() + " to " + AttributeExpression.ResultType.DECIMAL);
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Double> evaluate(Map<String, String> attributes) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(attributes);
        if (result.getValue() == null) {
            return new DecimalQueryResult(null);
        }
        switch (result.getResultType()) {
            case DECIMAL: {
                return (DecimalQueryResult)result;
            }
            case STRING: {
                String trimmed = ((StringQueryResult)result).getValue().trim();
                NumberParsing.ParseResultType parseType = NumberParsing.parse(trimmed);
                switch (parseType) {
                    case DECIMAL: {
                        return new DecimalQueryResult(Double.valueOf(trimmed));
                    }
                    case WHOLE_NUMBER: {
                        Long resultValue;
                        try {
                            resultValue = Long.valueOf(trimmed);
                        }
                        catch (NumberFormatException e) {
                            resultValue = Long.decode(trimmed);
                        }
                        return new DecimalQueryResult(resultValue.doubleValue());
                    }
                }
                return new DecimalQueryResult(null);
            }
            case DATE: {
                Long timestamp = ((DateQueryResult)result).getValue().getTime();
                return new DecimalQueryResult(timestamp.doubleValue());
            }
            case WHOLE_NUMBER: {
                Long resultValue = ((WholeNumberQueryResult)result).getValue();
                return new DecimalQueryResult(resultValue.doubleValue());
            }
            case NUMBER: {
                Number numberValue = ((NumberQueryResult)result).getValue();
                return new DecimalQueryResult(numberValue.doubleValue());
            }
        }
        return new DecimalQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

