/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.AttributesAndState;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class GetStateVariableEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;

    public GetStateVariableEvaluator(Evaluator<String> subject) {
        this.subject = subject;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        if (!(attributes instanceof AttributesAndState)) {
            return new StringQueryResult(null);
        }
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        AttributesAndState attributesAndState = (AttributesAndState)attributes;
        Map<String, String> stateMap = attributesAndState.getStateMap();
        String stateValue = stateMap.get(subjectValue);
        return new StringQueryResult(stateValue);
    }

    @Override
    public Evaluator<String> getSubjectEvaluator() {
        return this.subject;
    }
}

