/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class IfElseEvaluator
extends StringEvaluator {
    private final Evaluator<Boolean> subject;
    private final Evaluator<String> trueEvaluator;
    private final Evaluator<String> falseEvaluator;

    public IfElseEvaluator(Evaluator<Boolean> subject, Evaluator<String> trueEvaluator, Evaluator<String> falseEvaluator) {
        this.subject = subject;
        this.trueEvaluator = trueEvaluator;
        this.falseEvaluator = falseEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        QueryResult<Boolean> subjectValue = this.subject.evaluate(attributes);
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String ifElseValue = Boolean.TRUE.equals(subjectValue.getValue()) ? this.trueEvaluator.evaluate(attributes).getValue() : this.falseEvaluator.evaluate(attributes).getValue();
        return new StringQueryResult(ifElseValue);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

