/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class DelineatedAttributeEvaluator
extends MultiAttributeEvaluator {
    private final Evaluator<String> subjectEvaluator;
    private final Evaluator<String> delimiterEvaluator;
    private final int evaluationType;
    private String[] delineatedValues;
    private int evaluationCount = 0;
    private int evaluationsLeft = 1;

    public DelineatedAttributeEvaluator(Evaluator<String> subjectEvaluator, Evaluator<String> delimiterEvaluator, int evaluationType) {
        this.subjectEvaluator = subjectEvaluator;
        this.delimiterEvaluator = delimiterEvaluator;
        this.evaluationType = evaluationType;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        if (this.delineatedValues == null) {
            QueryResult<String> subjectValue = this.subjectEvaluator.evaluate(attributes);
            if (subjectValue.getValue() == null) {
                this.evaluationsLeft = 0;
                return new StringQueryResult(null);
            }
            QueryResult<String> delimiterValue = this.delimiterEvaluator.evaluate(attributes);
            if (subjectValue.getValue() == null) {
                this.evaluationsLeft = 0;
                return new StringQueryResult(null);
            }
            this.delineatedValues = subjectValue.getValue().split(delimiterValue.getValue());
        }
        if (this.evaluationCount > this.delineatedValues.length) {
            this.evaluationsLeft = 0;
            return new StringQueryResult(null);
        }
        this.evaluationsLeft = this.delineatedValues.length - this.evaluationCount - 1;
        return new StringQueryResult(this.delineatedValues[this.evaluationCount++]);
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this.subjectEvaluator;
    }

    @Override
    public int getEvaluationsRemaining() {
        return this.evaluationsLeft;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }
}

