/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class MultiMatchAttributeEvaluator
extends MultiAttributeEvaluator {
    private final List<Pattern> attributePatterns;
    private final int evaluationType;
    private final List<String> attributeNames = new ArrayList<String>();
    private int evaluationCount = 0;

    public MultiMatchAttributeEvaluator(List<String> attributeRegexes, int evaluationType) {
        this.attributePatterns = new ArrayList<Pattern>();
        for (String regex : attributeRegexes) {
            this.attributePatterns.add(Pattern.compile(regex));
        }
        this.evaluationType = evaluationType;
    }

    @Override
    public int getEvaluationsRemaining() {
        return this.attributeNames.size() - this.evaluationCount;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        if (this.evaluationCount == 0) {
            for (Pattern pattern : this.attributePatterns) {
                for (String attrName : attributes.keySet()) {
                    if (!pattern.matcher(attrName).matches()) continue;
                    this.attributeNames.add(attrName);
                }
            }
        }
        if (this.evaluationCount >= this.attributeNames.size()) {
            return new StringQueryResult(null);
        }
        return new StringQueryResult(attributes.get(this.attributeNames.get(this.evaluationCount++)));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this;
    }
}

