/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.okhttp;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.EntitySerializer;

public class XmlEntitySerializer
implements EntitySerializer {
    private final ConcurrentMap<Class<?>, JAXBContext> jaxbContextCache = new ConcurrentHashMap();

    @Override
    public void serialize(Object entity, OutputStream out) throws IOException {
        try {
            Marshaller marshaller = this.getJaxbContext(entity.getClass()).createMarshaller();
            marshaller.marshal(entity, out);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private JAXBContext getJaxbContext(Class<?> entityType) {
        JAXBContext context = (JAXBContext)this.jaxbContextCache.get(entityType);
        if (context != null) {
            return context;
        }
        context = this.createJaxbContext(entityType);
        this.jaxbContextCache.putIfAbsent(entityType, context);
        return context;
    }

    private JAXBContext createJaxbContext(Class<?> entityType) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{entityType});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create JAXBContext for Entity Type [" + String.valueOf(entityType) + "] so could not parse incoming request", e);
        }
    }
}

