/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.hbase.AbstractHBaseLookupService;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;

public class HBase_2_ListLookupService
extends AbstractHBaseLookupService
implements LookupService<List> {
    public static final AllowableValue KEY_LIST = new AllowableValue("key_list", "List of keys", "Return the row as a list of the column qualifiers (keys)");
    public static final AllowableValue VALUE_LIST = new AllowableValue("value_list", "List of values", "Return the row as a list of the values associated with each column qualifier.");
    public static final PropertyDescriptor RETURN_TYPE = new PropertyDescriptor.Builder().name("hb-lu-list-return-type").displayName("Return Type").description("Choose whether to return a list of the keys or a list of the values for the supplied row key.").allowableValues(new AllowableValue[]{KEY_LIST, VALUE_LIST}).defaultValue(KEY_LIST.getValue()).required(true).addValidator(Validator.VALID).build();
    public static final List<PropertyDescriptor> _PROPERTIES;
    private String returnType;

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return _PROPERTIES;
    }

    public Optional<List> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        if (coordinates.get("rowKey") == null) {
            return Optional.empty();
        }
        String rowKey = coordinates.get("rowKey").toString();
        if (StringUtils.isBlank((String)rowKey)) {
            return Optional.empty();
        }
        byte[] rowKeyBytes = rowKey.getBytes(StandardCharsets.UTF_8);
        try {
            Map<String, Object> values = this.scan(rowKeyBytes);
            if (values.size() > 0) {
                ArrayList<String> retVal = this.returnType.equals(KEY_LIST.getValue()) ? new ArrayList<String>(values.keySet()) : values.values().stream().map(obj -> obj.toString()).collect(Collectors.toList());
                return Optional.ofNullable(retVal);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            this.getLogger().error("Error occurred loading {}", new Object[]{coordinates.get("rowKey"), e});
            throw new LookupFailureException((Throwable)e);
        }
    }

    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InterruptedException, IOException, InitializationException {
        super.onEnabled(context);
        this.returnType = context.getProperty(RETURN_TYPE).getValue();
    }

    public Class<?> getValueType() {
        return List.class;
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }

    static {
        ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
        _temp.addAll(PROPERTIES);
        _temp.add(RETURN_TYPE);
        _PROPERTIES = Collections.unmodifiableList(_temp);
    }
}

