/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.Tuple;

@Tags(value={"get", "fetch", "poll", "http", "https", "ingest", "source", "input"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Fetches data from an HTTP or HTTPS URL and writes the data to the content of a FlowFile. Once the content has been fetched, the ETag and Last Modified dates are remembered (if the web server supports these concepts). This allows the Processor to fetch new data only if the remote data has changed or until the state is cleared. That is, once the content has been fetched from the given URL, it will not be fetched again until the content on the remote server changes. Note that due to limitations on state management, stored \"last modified\" and etag fields never expire. If the URL in GetHttp uses Expression Language that is unbounded, there is the potential for Out of Memory Errors to occur.")
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The filename is set to the name of the file on the remote server"), @WritesAttribute(attribute="mime.type", description="The MIME Type of the FlowFile, as reported by the HTTP Content-Type header")})
@Stateful(scopes={Scope.LOCAL}, description="Stores Last Modified Time and ETag headers returned by server so that the same data will not be fetched multiple times.")
public class GetHTTP
extends AbstractSessionFactoryProcessor {
    static final int PERSISTENCE_INTERVAL_MSEC = 10000;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_ETAG = "ETag";
    public static final int NOT_MODIFIED = 304;
    public static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("URL").description("The URL to pull from").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.URL_VALIDATOR).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("https?\\://.*"))).build();
    public static final PropertyDescriptor FOLLOW_REDIRECTS = new PropertyDescriptor.Builder().name("Follow Redirects").description("If we receive a 3xx HTTP Status Code from the server, indicates whether or not we should follow the redirect that the server specifies").defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("How long to wait when attempting to connect to the remote server before giving up").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor ACCEPT_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Accept Content-Type").description("If specified, requests will only accept the provided Content-Type").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DATA_TIMEOUT = new PropertyDescriptor.Builder().name("Data Timeout").description("How long to wait between receiving segments of data from the remote server before giving up and discarding the partial file").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").description("The filename to assign to the file when pulled").expressionLanguageSupported(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).required(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username required to access the URL").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password required to access the URL").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_AGENT = new PropertyDescriptor.Builder().name("User Agent").description("What to report as the User Agent when we connect to the remote server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("The fully qualified hostname or IP address of the proxy server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("Proxy Port").description("The port of the proxy server").required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final String DEFAULT_COOKIE_POLICY_STR = "default";
    public static final String STANDARD_COOKIE_POLICY_STR = "standard";
    public static final String STRICT_COOKIE_POLICY_STR = "strict";
    public static final String NETSCAPE_COOKIE_POLICY_STR = "netscape";
    public static final String IGNORE_COOKIE_POLICY_STR = "ignore";
    public static final AllowableValue DEFAULT_COOKIE_POLICY = new AllowableValue("default", "default", "Default cookie policy that provides a higher degree of compatibility with common cookie management of popular HTTP agents for non-standard (Netscape style) cookies.");
    public static final AllowableValue STANDARD_COOKIE_POLICY = new AllowableValue("standard", "standard", "RFC 6265 compliant cookie policy (interoperability profile).");
    public static final AllowableValue STRICT_COOKIE_POLICY = new AllowableValue("strict", "strict", "RFC 6265 compliant cookie policy (strict profile).");
    public static final AllowableValue NETSCAPE_COOKIE_POLICY = new AllowableValue("netscape", "netscape", "Netscape draft compliant cookie policy.");
    public static final AllowableValue IGNORE_COOKIE_POLICY = new AllowableValue("ignore", "ignore", "A cookie policy that ignores cookies.");
    public static final PropertyDescriptor REDIRECT_COOKIE_POLICY = new PropertyDescriptor.Builder().name("redirect-cookie-policy").displayName("Redirect Cookie Policy").description("When a HTTP server responds to a request with a redirect, this is the cookie policy used to copy cookies to the following request.").allowableValues(new AllowableValue[]{DEFAULT_COOKIE_POLICY, STANDARD_COOKIE_POLICY, STRICT_COOKIE_POLICY, NETSCAPE_COOKIE_POLICY, IGNORE_COOKIE_POLICY}).defaultValue("default").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All files are transferred to the success relationship").build();
    public static final String LAST_MODIFIED_DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final String ETAG = "ETag";
    static final String LAST_MODIFIED = "LastModified";
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicBoolean clearState = new AtomicBoolean(false);

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(FILENAME);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(USERNAME);
        properties.add(PASSWORD);
        properties.add(CONNECTION_TIMEOUT);
        properties.add(DATA_TIMEOUT);
        properties.add(USER_AGENT);
        properties.add(ACCEPT_CONTENT_TYPE);
        properties.add(FOLLOW_REDIRECTS);
        properties.add(REDIRECT_COOKIE_POLICY);
        properties.add(PROXY_HOST);
        properties.add(PROXY_PORT);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.clearState.set(true);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        if (this.clearState.getAndSet(false)) {
            context.getStateManager().clear(Scope.LOCAL);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (context.getProperty(URL).evaluateAttributeExpressions().getValue().startsWith("https") && context.getProperty(SSL_CONTEXT_SERVICE).getValue() == null) {
            results.add(new ValidationResult.Builder().explanation("URL is set to HTTPS protocol but no SSLContext has been specified").valid(false).subject("SSL Context").build());
        }
        if (context.getProperty(PROXY_HOST).isSet() && !context.getProperty(PROXY_PORT).isSet()) {
            results.add(new ValidationResult.Builder().explanation("Proxy Host was set but no Proxy Port was specified").valid(false).subject("Proxy server configuration").build());
        }
        return results;
    }

    private SSLContext createSSLContext(SSLContextService service) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        Throwable throwable;
        FileInputStream in;
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        if (StringUtils.isNotBlank((CharSequence)service.getTrustStoreFile())) {
            KeyStore truststore = KeyStore.getInstance(service.getTrustStoreType());
            in = new FileInputStream(new File(service.getTrustStoreFile()));
            throwable = null;
            try {
                truststore.load(in, service.getTrustStorePassword().toCharArray());
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
            sslContextBuilder.loadTrustMaterial(truststore, (TrustStrategy)new TrustSelfSignedStrategy());
        }
        if (StringUtils.isNotBlank((CharSequence)service.getKeyStoreFile())) {
            KeyStore keystore = KeyStore.getInstance(service.getKeyStoreType());
            in = new FileInputStream(new File(service.getKeyStoreFile()));
            throwable = null;
            try {
                keystore.load(in, service.getKeyStorePassword().toCharArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
            sslContextBuilder.loadKeyMaterial(keystore, service.getKeyStorePassword().toCharArray());
        }
        sslContextBuilder.useProtocol(service.getSslAlgorithm());
        return sslContextBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block61: {
            block62: {
                block59: {
                    block60: {
                        logger = this.getLogger();
                        session = sessionFactory.createSession();
                        incomingFlowFile = session.get();
                        if (incomingFlowFile != null) {
                            session.transfer(incomingFlowFile, GetHTTP.REL_SUCCESS);
                            logger.warn("found FlowFile {} in input queue; transferring to success", new Object[]{incomingFlowFile});
                        }
                        source = url = context.getProperty(GetHTTP.URL).evaluateAttributeExpressions().getValue();
                        try {
                            uri = new URI(url);
                            source = uri.getHost();
                        }
                        catch (URISyntaxException var9_9) {
                            // empty catch block
                        }
                        sslContextService = (SSLContextService)context.getProperty(GetHTTP.SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
                        if (sslContextService == null) {
                            conMan = new BasicHttpClientConnectionManager();
                        } else {
                            try {
                                sslContext = this.createSSLContext(sslContextService);
                            }
                            catch (Exception e) {
                                throw new ProcessException((Throwable)e);
                            }
                            sslsf = new SSLConnectionSocketFactory(sslContext);
                            socketFactoryRegistry = RegistryBuilder.create().register("https", sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
                            conMan = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
                        }
                        requestConfigBuilder = RequestConfig.custom();
                        requestConfigBuilder.setConnectionRequestTimeout(context.getProperty(GetHTTP.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                        requestConfigBuilder.setConnectTimeout(context.getProperty(GetHTTP.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                        requestConfigBuilder.setSocketTimeout(context.getProperty(GetHTTP.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                        requestConfigBuilder.setRedirectsEnabled(context.getProperty(GetHTTP.FOLLOW_REDIRECTS).asBoolean().booleanValue());
                        sslsf = context.getProperty(GetHTTP.REDIRECT_COOKIE_POLICY).getValue();
                        socketFactoryRegistry = -1;
                        switch (sslsf.hashCode()) {
                            case 1312628413: {
                                if (!sslsf.equals("standard")) break;
                                socketFactoryRegistry = 0;
                                break;
                            }
                            case -891986231: {
                                if (!sslsf.equals("strict")) break;
                                socketFactoryRegistry = 1;
                                break;
                            }
                            case 1309399625: {
                                if (!sslsf.equals("netscape")) break;
                                socketFactoryRegistry = 2;
                                break;
                            }
                            case -1190396462: {
                                if (!sslsf.equals("ignore")) break;
                                socketFactoryRegistry = 3;
                                break;
                            }
                            case 1544803905: {
                                if (!sslsf.equals("default")) break;
                                socketFactoryRegistry = 4;
                                break;
                            }
                        }
                        switch (socketFactoryRegistry) {
                            case 0: {
                                requestConfigBuilder.setCookieSpec("standard");
                                break;
                            }
                            case 1: {
                                requestConfigBuilder.setCookieSpec("standard-strict");
                                break;
                            }
                            case 2: {
                                requestConfigBuilder.setCookieSpec("netscape");
                                break;
                            }
                            case 3: {
                                requestConfigBuilder.setCookieSpec("ignoreCookies");
                                break;
                            }
                            default: {
                                requestConfigBuilder.setCookieSpec("default");
                            }
                        }
                        clientBuilder = HttpClientBuilder.create();
                        clientBuilder.setConnectionManager((HttpClientConnectionManager)conMan);
                        userAgent = context.getProperty(GetHTTP.USER_AGENT).getValue();
                        if (userAgent != null) {
                            clientBuilder.setUserAgent(userAgent);
                        }
                        if (sslContextService != null) {
                            clientBuilder.setSslcontext(sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED));
                        }
                        username = context.getProperty(GetHTTP.USERNAME).getValue();
                        password = context.getProperty(GetHTTP.PASSWORD).getValue();
                        if (username != null) {
                            credentialsProvider = new BasicCredentialsProvider();
                            if (password == null) {
                                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username));
                            } else {
                                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                            }
                            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                        }
                        if (context.getProperty(GetHTTP.PROXY_HOST).isSet() && context.getProperty(GetHTTP.PROXY_PORT).isSet()) {
                            host = context.getProperty(GetHTTP.PROXY_HOST).getValue();
                            port = context.getProperty(GetHTTP.PROXY_PORT).asInteger();
                            clientBuilder.setProxy(new HttpHost(host, port));
                        }
                        get = new HttpGet(url);
                        get.setConfig(requestConfigBuilder.build());
                        try {
                            beforeStateMap = context.getStateManager().getState(Scope.LOCAL);
                            lastModified = beforeStateMap.get("LastModified:" + url);
                            if (lastModified != null) {
                                get.addHeader("If-Modified-Since", (String)GetHTTP.parseStateValue(lastModified).getValue());
                            }
                            if ((etag = beforeStateMap.get("ETag:" + url)) != null) {
                                get.addHeader("If-None-Match", (String)GetHTTP.parseStateValue(etag).getValue());
                            }
                        }
                        catch (IOException ioe) {
                            throw new ProcessException((Throwable)ioe);
                        }
                        accept = context.getProperty(GetHTTP.ACCEPT_CONTENT_TYPE).getValue();
                        if (accept != null) {
                            get.addHeader("Accept", accept);
                        }
                        try {
                            client = clientBuilder.build();
                            var20_27 = null;
                            try {
                                stopWatch = new StopWatch(true);
                                response = client.execute((HttpUriRequest)get);
                                statusCode = response.getStatusLine().getStatusCode();
                                if (statusCode == 304) {
                                    logger.info("content not retrieved because server returned HTTP Status Code {}: Not Modified", new Object[]{304});
                                    context.yield();
                                    session.commit();
                                    if (client == null) break block59;
                                    if (var20_27 == null) break block60;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (IOException e) {
                                context.yield();
                                session.rollback();
                                logger.error("Failed to retrieve file from {} due to {}; rolling back session", new Object[]{url, e.getMessage()}, (Throwable)e);
                                throw new ProcessException((Throwable)e);
                            }
                            catch (Throwable t) {
                                context.yield();
                                session.rollback();
                                logger.error("Failed to process due to {}; rolling back session", new Object[]{t.getMessage()}, t);
                                throw t;
                            }
                        }
                        catch (IOException e) {
                            logger.debug("Error closing client due to {}, continuing.", new Object[]{e.getMessage()});
                            return;
                        }
                        catch (Throwable var30_43) {
                            throw var30_43;
                        }
                        try {
                            client.close();
                        }
                        catch (Throwable x2) {
                            var20_27.addSuppressed(x2);
                        }
                        break block59;
                    }
                    client.close();
                }
                conMan.shutdown();
                return;
lbl-1000:
                // 1 sources

                {
                    statusExplanation = response.getStatusLine().getReasonPhrase();
                    if (statusCode < 300 && statusCode != 204) ** GOTO lbl-1000
                    logger.error("received status code {}:{} from {}", new Object[]{statusCode, statusExplanation, url});
                    session.commit();
                    if (client == null) break block61;
                    if (var20_27 == null) break block62;
                }
                try {
                    client.close();
                }
                catch (Throwable x2) {
                    var20_27.addSuppressed(x2);
                }
                break block61;
            }
            client.close();
        }
        conMan.shutdown();
        return;
lbl-1000:
        // 1 sources

        {
            flowFile = session.create();
            flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), context.getProperty(GetHTTP.FILENAME).evaluateAttributeExpressions().getValue());
            flowFile = session.putAttribute(flowFile, this.getClass().getSimpleName().toLowerCase() + ".remote.source", source);
            flowFile = session.importFrom(response.getEntity().getContent(), flowFile);
            contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null && !(contentType = contentTypeHeader.getValue()).trim().isEmpty()) {
                flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), contentType.trim());
            }
            flowFileSize = flowFile.getSize();
            stopWatch.stop();
            dataRate = stopWatch.calculateDataRate(flowFileSize);
            session.getProvenanceReporter().receive(flowFile, url, stopWatch.getDuration(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, GetHTTP.REL_SUCCESS);
            logger.info("Successfully received {} from {} at a rate of {}; transferred to success", new Object[]{flowFile, url, dataRate});
            session.commit();
            this.updateStateMap(context, (HttpResponse)response, beforeStateMap, url);
            return;
        }
    }

    private void updateStateMap(ProcessContext context, HttpResponse response, StateMap beforeStateMap, String url) {
        try {
            Header receivedEtag;
            HashMap<String, String> workingMap = new HashMap<String, String>();
            workingMap.putAll(beforeStateMap.toMap());
            StateManager stateManager = context.getStateManager();
            StateMap oldValue = beforeStateMap;
            long currentTime = System.currentTimeMillis();
            Header receivedLastModified = response.getFirstHeader(HEADER_LAST_MODIFIED);
            if (receivedLastModified != null) {
                workingMap.put("LastModified:" + url, currentTime + ":" + receivedLastModified.getValue());
            }
            if ((receivedEtag = response.getFirstHeader("ETag")) != null) {
                workingMap.put("ETag:" + url, currentTime + ":" + receivedEtag.getValue());
            }
            boolean replaceSucceeded = stateManager.replace(oldValue, workingMap, Scope.LOCAL);
            while (!replaceSucceeded) {
                Tuple<String, String> storedLastModifiedTuple;
                oldValue = stateManager.getState(Scope.LOCAL);
                workingMap.clear();
                workingMap.putAll(oldValue.toMap());
                boolean changed = false;
                if (receivedLastModified != null && Long.parseLong((String)(storedLastModifiedTuple = GetHTTP.parseStateValue((String)workingMap.get("LastModified:" + url))).getKey()) < currentTime) {
                    workingMap.put("LastModified:" + url, currentTime + ":" + receivedLastModified.getValue());
                    changed = true;
                }
                if (receivedEtag != null && Long.parseLong((String)(storedLastModifiedTuple = GetHTTP.parseStateValue((String)workingMap.get("ETag:" + url))).getKey()) < currentTime) {
                    workingMap.put("ETag:" + url, currentTime + ":" + receivedEtag.getValue());
                    changed = true;
                }
                if (changed) {
                    replaceSucceeded = stateManager.replace(oldValue, workingMap, Scope.LOCAL);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new ProcessException((Throwable)ioe);
        }
    }

    protected static Tuple<String, String> parseStateValue(String mapValue) {
        int indexOfColon = mapValue.indexOf(":");
        String timestamp = mapValue.substring(0, indexOfColon);
        String value = mapValue.substring(indexOfColon + 1);
        return new Tuple((Object)timestamp, (Object)value);
    }
}

