/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.FlowFileFilters;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.NLKBufferedReader;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Text", "Regular Expression", "Update", "Change", "Replace", "Modify", "Regex"})
@CapabilityDescription(value="Updates the content of a FlowFile by evaluating a Regular Expression (regex) against it and replacing the section of the content that matches the Regular Expression with some alternate value.")
public class ReplaceText
extends AbstractProcessor {
    private static Pattern REPLACEMENT_NORMALIZATION_PATTERN = Pattern.compile("(\\$\\D)");
    public static final String LINE_BY_LINE = "Line-by-Line";
    public static final String ENTIRE_TEXT = "Entire text";
    public static final String prependValue = "Prepend";
    public static final String appendValue = "Append";
    public static final String regexReplaceValue = "Regex Replace";
    public static final String literalReplaceValue = "Literal Replace";
    public static final String alwaysReplace = "Always Replace";
    private static final Pattern backReferencePattern = Pattern.compile("\\$(\\d+)");
    private static final String DEFAULT_REGEX = "(?s:^.*$)";
    private static final String DEFAULT_REPLACEMENT_VALUE = "$1";
    static final AllowableValue PREPEND = new AllowableValue("Prepend", "Prepend", "Insert the Replacement Value at the beginning of the FlowFile or the beginning of each line (depending on the Evaluation Mode). For \"Line-by-Line\" Evaluation Mode, the value will be prepended to each line. For \"Entire Text\" evaluation mode, the value will be prepended to the entire text.");
    static final AllowableValue APPEND = new AllowableValue("Append", "Append", "Insert the Replacement Value at the end of the FlowFile or the end of each line (depending on the Evluation Mode). For \"Line-by-Line\" Evaluation Mode, the value will be appended to each line. For \"Entire Text\" evaluation mode, the value will be appended to the entire text.");
    static final AllowableValue LITERAL_REPLACE = new AllowableValue("Literal Replace", "Literal Replace", "Search for all instances of the Search Value and replace the matches with the Replacement Value.");
    static final AllowableValue REGEX_REPLACE = new AllowableValue("Regex Replace", "Regex Replace", "Interpret the Search Value as a Regular Expression and replace all matches with the Replacement Value. The Replacement Value may reference Capturing Groups used in the Search Value by using a dollar-sign followed by the Capturing Group number, such as $1 or $2. If the Search Value is set to .* then everything is replaced without even evaluating the Regular Expression.");
    static final AllowableValue ALWAYS_REPLACE = new AllowableValue("Always Replace", "Always Replace", "Always replaces the entire line or the entire contents of the FlowFile (depending on the value of the <Evaluation Mode> property) and does not bother searching for any value. When this strategy is chosen, the <Search Value> property is ignored.");
    public static final PropertyDescriptor SEARCH_VALUE = new PropertyDescriptor.Builder().name("Regular Expression").displayName("Search Value").description("The Search Value to search for in the FlowFile content. Only used for 'Literal Replace' and 'Regex Replace' matching strategies").required(true).addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).expressionLanguageSupported(true).defaultValue("(?s:^.*$)").build();
    public static final PropertyDescriptor REPLACEMENT_VALUE = new PropertyDescriptor.Builder().name("Replacement Value").description("The value to insert using the 'Replacement Strategy'. Using \"Regex Replace\" back-references to Regular Expression capturing groups are supported, but back-references that reference capturing groups that do not exist in the regular expression will be treated as literal value. Back References may also be referenced using the Expression Language, as '$1', '$2', etc. The single-tick marks MUST be included, as these variables are not \"Standard\" attribute names (attribute names must be quoted unless they contain only numbers, letters, and _).").required(true).defaultValue("$1").addValidator(Validator.VALID).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the file is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final PropertyDescriptor MAX_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Maximum Buffer Size").description("Specifies the maximum amount of data to buffer (per file or per line, depending on the Evaluation Mode) in order to apply the replacement. If 'Entire Text' (in Evaluation Mode) is selected and the FlowFile is larger than this value, the FlowFile will be routed to 'failure'. In 'Line-by-Line' Mode, if a single line is larger than this value, the FlowFile will be routed to 'failure'. A default value of 1 MB is provided, primarily for 'Entire Text' mode. In 'Line-by-Line' Mode, a value such as 8 KB or 16 KB is suggested. This value is ignored if the <Replacement Strategy> property is set to one of: Append, Prepend, Always Replace").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor REPLACEMENT_STRATEGY = new PropertyDescriptor.Builder().name("Replacement Strategy").description("The strategy for how and what to replace within the FlowFile's text content.").allowableValues(new AllowableValue[]{PREPEND, APPEND, REGEX_REPLACE, LITERAL_REPLACE, ALWAYS_REPLACE}).defaultValue(REGEX_REPLACE.getValue()).required(true).build();
    public static final PropertyDescriptor EVALUATION_MODE = new PropertyDescriptor.Builder().name("Evaluation Mode").description("Run the 'Replacement Strategy' against each line separately (Line-by-Line) or buffer the entire file into memory (Entire Text) and run against that.").allowableValues(new String[]{"Line-by-Line", "Entire text"}).defaultValue("Entire text").required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that have been successfully processed are routed to this relationship. This includes both FlowFiles that had text replaced and those that did not.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that could not be updated are routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SEARCH_VALUE);
        properties.add(REPLACEMENT_VALUE);
        properties.add(CHARACTER_SET);
        properties.add(MAX_BUFFER_SIZE);
        properties.add(REPLACEMENT_STRATEGY);
        properties.add(EVALUATION_MODE);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ReplacementStrategyExecutor replacementStrategyExecutor;
        List flowFiles = session.get(FlowFileFilters.newSizeBasedFilter((double)1.0, (DataUnit)DataUnit.MB, (int)100));
        if (flowFiles.isEmpty()) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        String unsubstitutedRegex = context.getProperty(SEARCH_VALUE).getValue();
        String unsubstitutedReplacement = context.getProperty(REPLACEMENT_VALUE).getValue();
        String replacementStrategy = context.getProperty(REPLACEMENT_STRATEGY).getValue();
        if (replacementStrategy.equalsIgnoreCase(regexReplaceValue) && unsubstitutedRegex.equals(DEFAULT_REGEX) && unsubstitutedReplacement.equals(DEFAULT_REPLACEMENT_VALUE)) {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        String evaluateMode = context.getProperty(EVALUATION_MODE).getValue();
        Object buffer = replacementStrategy.equalsIgnoreCase(regexReplaceValue) || replacementStrategy.equalsIgnoreCase(literalReplaceValue) ? new byte[maxBufferSize] : null;
        switch (replacementStrategy) {
            case "Prepend": {
                replacementStrategyExecutor = new PrependReplace();
                break;
            }
            case "Append": {
                replacementStrategyExecutor = new AppendReplace();
                break;
            }
            case "Regex Replace": {
                if (context.getProperty(SEARCH_VALUE).getValue().equals(".*")) {
                    replacementStrategyExecutor = new AlwaysReplace();
                    break;
                }
                replacementStrategyExecutor = new RegexReplace((byte[])buffer, context);
                break;
            }
            case "Literal Replace": {
                replacementStrategyExecutor = new LiteralReplace((byte[])buffer);
                break;
            }
            case "Always Replace": {
                replacementStrategyExecutor = new AlwaysReplace();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (FlowFile flowFile : flowFiles) {
            if (evaluateMode.equalsIgnoreCase(ENTIRE_TEXT) && flowFile.getSize() > (long)maxBufferSize && replacementStrategyExecutor.isAllDataBufferedForEntireText()) {
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            StopWatch stopWatch = new StopWatch(true);
            flowFile = replacementStrategyExecutor.replace(flowFile, session, context, evaluateMode, charset, maxBufferSize);
            logger.info("Transferred {} to 'success'", new Object[]{flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    private static String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
        if (numCapturingGroups == 0) {
            return unescaped;
        }
        String value = unescaped;
        Matcher backRefMatcher = backReferencePattern.matcher(value);
        while (backRefMatcher.find()) {
            int originalBackRefIndex;
            int backRefIndex;
            String backRefNum = backRefMatcher.group(1);
            if (backRefNum.startsWith("0")) continue;
            for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
            }
            if (backRefIndex <= numCapturingGroups) continue;
            StringBuilder sb = new StringBuilder(value.length() + 1);
            int groupStart = backRefMatcher.start(1);
            sb.append(value.substring(0, groupStart - 1));
            sb.append("\\");
            sb.append(value.substring(groupStart - 1));
            value = sb.toString();
        }
        return value;
    }

    private static String normalizeReplacementString(String replacement) {
        String replacementFinal = replacement;
        if (REPLACEMENT_NORMALIZATION_PATTERN.matcher(replacement).find()) {
            replacementFinal = Matcher.quoteReplacement(replacement);
        }
        return replacementFinal;
    }

    private static interface ReplacementStrategyExecutor {
        public FlowFile replace(FlowFile var1, ProcessSession var2, ProcessContext var3, String var4, Charset var5, int var6);

        public boolean isAllDataBufferedForEntireText();
    }

    private static class LiteralReplace
    implements ReplacementStrategyExecutor {
        private final byte[] buffer;

        public LiteralReplace(byte[] buffer) {
            this.buffer = buffer;
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, final int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            AttributeValueDecorator quotedAttributeDecorator = new AttributeValueDecorator(){

                public String decorate(String attributeValue) {
                    return Pattern.quote(attributeValue);
                }
            };
            final String searchValue = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions(flowFile, quotedAttributeDecorator).getValue();
            final int flowFileSize = (int)flowFile.getSize();
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    StreamUtils.fillBuffer((InputStream)in, (byte[])LiteralReplace.this.buffer, (boolean)false);
                    String contentString = new String(LiteralReplace.this.buffer, 0, flowFileSize, charset);
                    String updatedValue = contentString.replace(searchValue, replacementValue);
                    out.write(updatedValue.getBytes(charset));
                }
            }) : session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                        String oneLine;
                        while (null != (oneLine = br.readLine())) {
                            String updatedValue = oneLine.replace(searchValue, replacementValue);
                            bw.write(updatedValue);
                        }
                    }
                }
            });
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return true;
        }
    }

    private static class RegexReplace
    implements ReplacementStrategyExecutor {
        private final byte[] buffer;
        private final int numCapturingGroups;
        private final Map<String, String> additionalAttrs;
        private static final AttributeValueDecorator escapeBackRefDecorator = new AttributeValueDecorator(){

            public String decorate(String attributeValue) {
                return attributeValue.replace("$", "\\$");
            }
        };

        public RegexReplace(byte[] buffer, ProcessContext context) {
            this.buffer = buffer;
            String regexValue = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions().getValue();
            this.numCapturingGroups = Pattern.compile(regexValue).matcher("").groupCount();
            this.additionalAttrs = new HashMap<String, String>(this.numCapturingGroups);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public FlowFile replace(final FlowFile flowFile, ProcessSession session, final ProcessContext context, String evaluateMode, final Charset charset, final int maxBufferSize) {
            AttributeValueDecorator quotedAttributeDecorator = new AttributeValueDecorator(){

                public String decorate(String attributeValue) {
                    return Pattern.quote(attributeValue);
                }
            };
            final String searchRegex = context.getProperty(SEARCH_VALUE).evaluateAttributeExpressions(flowFile, quotedAttributeDecorator).getValue();
            final Pattern searchPattern = Pattern.compile(searchRegex);
            int flowFileSize = (int)flowFile.getSize();
            if (!evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT)) return session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                        String oneLine;
                        while (null != (oneLine = br.readLine())) {
                            RegexReplace.this.additionalAttrs.clear();
                            Matcher matcher = searchPattern.matcher(oneLine);
                            if (matcher.find()) {
                                for (int i = 1; i <= matcher.groupCount(); ++i) {
                                    String groupValue = matcher.group(i);
                                    RegexReplace.this.additionalAttrs.put("$" + i, groupValue);
                                }
                                String replacement = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile, RegexReplace.this.additionalAttrs, escapeBackRefDecorator).getValue();
                                replacement = ReplaceText.escapeLiteralBackReferences(replacement, RegexReplace.this.numCapturingGroups);
                                String replacementFinal = ReplaceText.normalizeReplacementString(replacement);
                                String updatedValue = oneLine.replaceAll(searchRegex, replacementFinal);
                                bw.write(updatedValue);
                                continue;
                            }
                            bw.write(oneLine);
                        }
                    }
                }
            });
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    StreamUtils.fillBuffer((InputStream)in, (byte[])RegexReplace.this.buffer, (boolean)false);
                }
            });
            String contentString = new String(this.buffer, 0, flowFileSize, charset);
            this.additionalAttrs.clear();
            Matcher matcher = searchPattern.matcher(contentString);
            if (!matcher.find()) return flowFile;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String groupValue = matcher.group(i);
                this.additionalAttrs.put("$" + i, groupValue);
            }
            String replacement = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile, this.additionalAttrs, escapeBackRefDecorator).getValue();
            replacement = ReplaceText.escapeLiteralBackReferences(replacement, this.numCapturingGroups);
            String replacementFinal = ReplaceText.normalizeReplacementString(replacement);
            final String updatedValue = contentString.replaceAll(searchRegex, replacementFinal);
            return session.write(flowFile, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    out.write(updatedValue.getBytes(charset));
                }
            });
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return true;
        }
    }

    private static class AppendReplace
    implements ReplacementStrategyExecutor {
        private AppendReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, final int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.write(replacementValue.getBytes(charset));
                }
            }) : session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                        String oneLine;
                        while (null != (oneLine = br.readLine())) {
                            boolean foundNewLine = false;
                            for (int i = 0; i < oneLine.length(); ++i) {
                                char c = oneLine.charAt(i);
                                if (foundNewLine) {
                                    bw.write(c);
                                    continue;
                                }
                                if (c == '\r' || c == '\n') {
                                    bw.write(replacementValue);
                                    foundNewLine = true;
                                }
                                bw.write(c);
                            }
                            if (foundNewLine) continue;
                            bw.write(replacementValue);
                        }
                    }
                }
            });
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }

    private static class PrependReplace
    implements ReplacementStrategyExecutor {
        private PrependReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, final int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    out.write(replacementValue.getBytes(charset));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }) : session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                        String oneLine;
                        while (null != (oneLine = br.readLine())) {
                            String updatedValue = replacementValue.concat(oneLine);
                            bw.write(updatedValue);
                        }
                    }
                }
            });
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }

    private static class AlwaysReplace
    implements ReplacementStrategyExecutor {
        private AlwaysReplace() {
        }

        @Override
        public FlowFile replace(FlowFile flowFile, ProcessSession session, ProcessContext context, String evaluateMode, final Charset charset, final int maxBufferSize) {
            final String replacementValue = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile).getValue();
            final StringBuilder lineEndingBuilder = new StringBuilder(2);
            flowFile = evaluateMode.equalsIgnoreCase(ReplaceText.ENTIRE_TEXT) ? session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    out.write(replacementValue.getBytes(charset));
                }
            }) : session.write(flowFile, new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            char c;
                            lineEndingBuilder.setLength(0);
                            for (int i = line.length() - 1; i >= 0 && ((c = line.charAt(i)) == '\r' || c == '\n'); --i) {
                                lineEndingBuilder.append(c);
                            }
                            bw.write(replacementValue);
                            bw.write(lineEndingBuilder.reverse().toString());
                        }
                    }
                }
            });
            return flowFile;
        }

        @Override
        public boolean isAllDataBufferedForEntireText() {
            return false;
        }
    }
}

