/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.util.crypto.PBECipherProvider;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.stream.io.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSLPKCS5CipherProvider
implements PBECipherProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenSSLPKCS5CipherProvider.class);
    private static final int ITERATION_COUNT = 0;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final byte[] EMPTY_SALT = new byte[8];
    private static final String OPENSSL_EVP_HEADER_MARKER = "Salted__";
    private static final int OPENSSL_EVP_HEADER_SIZE = 8;

    @Override
    @Deprecated
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, int keyLength, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, password, new byte[0], keyLength, encryptMode);
    }

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, int keyLength, boolean encryptMode) throws Exception {
        try {
            return this.getInitializedCipher(encryptionMethod, password, salt, encryptMode);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessException("Error initializing the cipher", (Throwable)e);
        }
    }

    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, password, new byte[0], -1, encryptMode);
    }

    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, password, salt, -1, encryptMode);
    }

    protected Cipher getInitializedCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, boolean encryptMode) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The encryption method must be specified");
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Encryption with an empty password is not supported");
        }
        this.validateSalt(encryptionMethod, salt);
        String algorithm = encryptionMethod.getAlgorithm();
        String provider = encryptionMethod.getProvider();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm, provider);
        SecretKey tempKey = factory.generateSecret(pbeKeySpec);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, this.getIterationCount());
        Cipher cipher = Cipher.getInstance(algorithm, provider);
        cipher.init(encryptMode ? 1 : 2, (Key)tempKey, parameterSpec);
        return cipher;
    }

    protected void validateSalt(EncryptionMethod encryptionMethod, byte[] salt) {
        if (salt.length != 8 && salt.length != 0) {
            throw new IllegalArgumentException("Salt must be 8 bytes US-ASCII encoded or empty");
        }
    }

    protected int getIterationCount() {
        return 0;
    }

    @Override
    public byte[] generateSalt() {
        byte[] salt = new byte[this.getDefaultSaltLength()];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    @Override
    public int getDefaultSaltLength() {
        return 8;
    }

    @Override
    public byte[] readSalt(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Cannot read salt from null InputStream");
        }
        byte[] salt = new byte[8];
        byte[] header = new byte[8];
        in.mark(9);
        StreamUtils.fillBuffer((InputStream)in, (byte[])header);
        byte[] headerMarkerBytes = OPENSSL_EVP_HEADER_MARKER.getBytes(StandardCharsets.US_ASCII);
        if (!Arrays.equals(headerMarkerBytes, header)) {
            salt = new byte[]{};
            in.reset();
        }
        StreamUtils.fillBuffer((InputStream)in, (byte[])salt);
        return salt;
    }

    @Override
    public void writeSalt(byte[] salt, OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Cannot write salt to null OutputStream");
        }
        out.write(OPENSSL_EVP_HEADER_MARKER.getBytes(StandardCharsets.US_ASCII));
        out.write(salt);
    }
}

