/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.listen.AbstractListenEventBatchingProcessor;
import org.apache.nifi.processor.util.listen.dispatcher.ChannelDispatcher;
import org.apache.nifi.processor.util.listen.dispatcher.SocketChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.event.StandardEvent;
import org.apache.nifi.processor.util.listen.event.StandardEventFactory;
import org.apache.nifi.processor.util.listen.handler.ChannelHandlerFactory;
import org.apache.nifi.processor.util.listen.handler.socket.SocketChannelHandlerFactory;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"listen", "tcp", "tls", "ssl"})
@CapabilityDescription(value="Listens for incoming TCP connections and reads data from each connection using a line separator as the message demarcator. The default behavior is for each message to produce a single FlowFile, however this can be controlled by increasing the Batch Size to a larger value for higher throughput. The Receive Buffer Size must be set as large as the largest messages expected to be received, meaning if every 100kb there is a line separator, then the Receive Buffer Size must be greater than 100kb.")
@WritesAttributes(value={@WritesAttribute(attribute="tcp.sender", description="The sending host of the messages."), @WritesAttribute(attribute="tcp.port", description="The sending port the messages were received.")})
public class ListenTCP
extends AbstractListenEventBatchingProcessor<StandardEvent> {
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context. If this property is set, messages will be received over a secure connection.").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("Client Auth").description("The client authentication policy to use for the SSL Context. Only used if an SSL Context Service is provided.").required(false).allowableValues((Enum[])SSLContextService.ClientAuth.values()).defaultValue(SSLContextService.ClientAuth.REQUIRED.name()).build();

    protected List<PropertyDescriptor> getAdditionalProperties() {
        return Arrays.asList(MAX_CONNECTIONS, SSL_CONTEXT_SERVICE, CLIENT_AUTH);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String clientAuth = validationContext.getProperty(CLIENT_AUTH).getValue();
        SSLContextService sslContextService = (SSLContextService)validationContext.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService != null && StringUtils.isBlank((CharSequence)clientAuth)) {
            results.add(new ValidationResult.Builder().explanation("Client Auth must be provided when using TLS/SSL").valid(false).subject("Client Auth").build());
        }
        return results;
    }

    protected ChannelDispatcher createDispatcher(ProcessContext context, BlockingQueue<StandardEvent> events) throws IOException {
        int maxConnections = context.getProperty(MAX_CONNECTIONS).asInteger();
        int bufferSize = context.getProperty(RECV_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        Charset charSet = Charset.forName(context.getProperty(CHARSET).getValue());
        BlockingQueue bufferPool = this.createBufferPool(maxConnections, bufferSize);
        SSLContext sslContext = null;
        SslContextFactory.ClientAuth clientAuth = null;
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService != null) {
            String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
            sslContext = sslContextService.createSSLContext(SSLContextService.ClientAuth.valueOf((String)clientAuthValue));
            clientAuth = SslContextFactory.ClientAuth.valueOf((String)clientAuthValue);
        }
        StandardEventFactory eventFactory = new StandardEventFactory();
        SocketChannelHandlerFactory handlerFactory = new SocketChannelHandlerFactory();
        return new SocketChannelDispatcher((EventFactory)eventFactory, (ChannelHandlerFactory)handlerFactory, bufferPool, events, this.getLogger(), maxConnections, sslContext, clientAuth, charSet);
    }

    protected Map<String, String> getAttributes(AbstractListenEventBatchingProcessor.FlowFileEventBatch batch) {
        String sender = ((StandardEvent)batch.getEvents().get(0)).getSender();
        HashMap<String, String> attributes = new HashMap<String, String>(3);
        attributes.put("tcp.sender", sender);
        attributes.put("tcp.port", String.valueOf(this.port));
        return attributes;
    }

    protected String getTransitUri(AbstractListenEventBatchingProcessor.FlowFileEventBatch batch) {
        String sender = ((StandardEvent)batch.getEvents().get(0)).getSender();
        String senderHost = sender.startsWith("/") && sender.length() > 1 ? sender.substring(1) : sender;
        String transitUri = "tcp" + "://" + senderHost + ":" + this.port;
        return transitUri;
    }
}

