/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.KeyedEncryptor;
import org.apache.nifi.security.util.crypto.OpenPGPKeyBasedEncryptor;
import org.apache.nifi.security.util.crypto.OpenPGPPasswordBasedEncryptor;
import org.apache.nifi.security.util.crypto.PasswordBasedEncryptor;
import org.apache.nifi.util.StopWatch;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"encryption", "decryption", "password", "JCE", "OpenPGP", "PGP", "GPG", "KDF", "Argon2", "Bcrypt", "Scrypt", "PBKDF2", "salt", "iv"})
@CapabilityDescription(value="Encrypts or Decrypts a FlowFile using either symmetric encryption with a raw key or password and randomly generated salt, or asymmetric encryption using a public and secret key.")
@SystemResourceConsideration(resource=SystemResource.CPU)
@WritesAttributes(value={@WritesAttribute(attribute="encryptcontent.action", description="\"encrypted\" or \"decrypted\" depending on the processor action"), @WritesAttribute(attribute="encryptcontent.algorithm", description="The algorithm used for the cryptographic operation"), @WritesAttribute(attribute="encryptcontent.cipher_text_length", description="The cipher text length in bytes (including IV, salt, and delimiters if present). Determined from incoming content in decrypt mode; outgoing content in encrypt mode"), @WritesAttribute(attribute="encryptcontent.iv", description="The Initialization Vector in hex encoding (if present)"), @WritesAttribute(attribute="encryptcontent.iv_length", description="The IV length in bytes"), @WritesAttribute(attribute="encryptcontent.kdf", description="The Key Derivation Function used if Password-Based Encryption was enabled. See Admin Guide - Key Derivation Functions"), @WritesAttribute(attribute="encryptcontent.kdf_salt", description="The KDF-specific salt including algorithm and cost parameters (if present). See Admin Guide - Key Derivation Functions"), @WritesAttribute(attribute="encryptcontent.kdf_salt_length", description="The KDF salt length in bytes"), @WritesAttribute(attribute="encryptcontent.pbkdf2_iterations", description="The number of iterations used in PBKDF2 KDF (if present). PBKDF2 does not encode the cost parameter in a custom salt"), @WritesAttribute(attribute="encryptcontent.plaintext_length", description="The plaintext length in bytes. Determined from incoming content in encrypt mode; outgoing content in decrypt mode"), @WritesAttribute(attribute="encryptcontent.salt", description="The raw salt in hex encoding (if present)"), @WritesAttribute(attribute="encryptcontent.salt_length", description="The raw salt length in bytes"), @WritesAttribute(attribute="encryptcontent.timestamp", description="The timestamp at which the cryptographic operation occurred in 'yyyy-MM-dd HH:mm:ss.SSS Z' format")})
public class EncryptContent
extends AbstractProcessor {
    public static final String ENCRYPT_MODE = "Encrypt";
    public static final String DECRYPT_MODE = "Decrypt";
    private static final String WEAK_CRYPTO_ALLOWED_NAME = "allowed";
    private static final String WEAK_CRYPTO_NOT_ALLOWED_NAME = "not-allowed";
    public static final String IV_ATTR = "encryptcontent.iv";
    public static final String IV_LEN_ATTR = "encryptcontent.iv_length";
    public static final String SALT_ATTR = "encryptcontent.salt";
    public static final String SALT_LEN_ATTR = "encryptcontent.salt_length";
    public static final String KDF_SALT_ATTR = "encryptcontent.kdf_salt";
    public static final String KDF_SALT_LEN_ATTR = "encryptcontent.kdf_salt_length";
    public static final String PT_LEN_ATTR = "encryptcontent.plaintext_length";
    public static final String CT_LEN_ATTR = "encryptcontent.cipher_text_length";
    public static final String TS_ATTR = "encryptcontent.timestamp";
    public static final String ACTION_ATTR = "encryptcontent.action";
    public static final String ALGORITHM_ATTR = "encryptcontent.algorithm";
    public static final String KDF_ATTR = "encryptcontent.kdf";
    public static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").displayName("Mode").description("Specifies whether the content should be encrypted or decrypted").required(true).allowableValues(new String[]{"Encrypt", "Decrypt"}).defaultValue("Encrypt").build();
    public static final PropertyDescriptor KEY_DERIVATION_FUNCTION = new PropertyDescriptor.Builder().name("key-derivation-function").displayName("Key Derivation Function").description("Specifies the key derivation function to generate the key from the password (and salt)").required(true).allowableValues(EncryptContent.buildKeyDerivationFunctionAllowableValues()).defaultValue(KeyDerivationFunction.NONE.name()).build();
    public static final PropertyDescriptor ENCRYPTION_ALGORITHM = new PropertyDescriptor.Builder().name("Encryption Algorithm").displayName("Encryption Algorithm").description("The Encryption Algorithm to use").required(true).allowableValues(EncryptContent.buildEncryptionMethodAllowableValues()).defaultValue(EncryptionMethod.AES_GCM.name()).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").displayName("Password").description("The Password to use for encrypting or decrypting the data").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor PUBLIC_KEYRING = new PropertyDescriptor.Builder().name("public-keyring-file").displayName("Public Keyring File").description("In a PGP encrypt mode, this keyring contains the public key of the recipient").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PUBLIC_KEY_USERID = new PropertyDescriptor.Builder().name("public-key-user-id").displayName("Public Key User Id").description("In a PGP encrypt mode, this user id of the recipient").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PRIVATE_KEYRING = new PropertyDescriptor.Builder().name("private-keyring-file").displayName("Private Keyring File").description("In a PGP decrypt mode, this keyring contains the private key of the recipient").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PRIVATE_KEYRING_PASSPHRASE = new PropertyDescriptor.Builder().name("private-keyring-passphrase").displayName("Private Keyring Passphrase").description("In a PGP decrypt mode, this is the private keyring passphrase").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).build();
    public static final PropertyDescriptor PGP_SYMMETRIC_ENCRYPTION_CIPHER = new PropertyDescriptor.Builder().name("pgp-symmetric-cipher").displayName("PGP Symmetric Cipher").description("When using PGP encryption, this is the symmetric cipher to be used. This property is ignored if Encryption Algorithm is not PGP or PGP-ASCII-ARMOR\nNote that the provided cipher is only used duringthe encryption phase, while it is inferred from the ciphertext in the decryption phase").required(false).allowableValues(EncryptContent.buildPGPSymmetricCipherAllowableValues()).defaultValue(String.valueOf(7)).build();
    public static final PropertyDescriptor RAW_KEY_HEX = new PropertyDescriptor.Builder().name("raw-key-hex").displayName("Raw Key (hexadecimal)").description("In keyed encryption, this is the raw key, encoded in hexadecimal").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor ALLOW_WEAK_CRYPTO = new PropertyDescriptor.Builder().name("allow-weak-crypto").displayName("Allow insecure cryptographic modes").description("Overrides the default behavior to prevent unsafe combinations of encryption algorithms and short passwords on JVMs with limited strength cryptographic jurisdiction policies").required(true).allowableValues(EncryptContent.buildWeakCryptoAllowableValues()).defaultValue(EncryptContent.buildDefaultWeakCryptoAllowableValue().getValue()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that is successfully encrypted or decrypted will be routed to success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that cannot be encrypted or decrypted will be routed to failure").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    private static AllowableValue[] buildKeyDerivationFunctionAllowableValues() {
        KeyDerivationFunction[] keyDerivationFunctions = KeyDerivationFunction.values();
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(keyDerivationFunctions.length);
        for (KeyDerivationFunction kdf : keyDerivationFunctions) {
            allowableValues.add(new AllowableValue(kdf.name(), kdf.getKdfName(), kdf.getDescription()));
        }
        return allowableValues.toArray(new AllowableValue[0]);
    }

    private static AllowableValue[] buildEncryptionMethodAllowableValues() {
        EncryptionMethod[] encryptionMethods = EncryptionMethod.values();
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(encryptionMethods.length);
        for (EncryptionMethod em : encryptionMethods) {
            allowableValues.add(new AllowableValue(em.name(), em.name(), em.toString()));
        }
        return allowableValues.toArray(new AllowableValue[0]);
    }

    private static AllowableValue[] buildWeakCryptoAllowableValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(new AllowableValue(WEAK_CRYPTO_ALLOWED_NAME, "Allowed", "Operation will not be blocked and no alerts will be presented when unsafe combinations of encryption algorithms and passwords are provided"));
        allowableValues.add(EncryptContent.buildDefaultWeakCryptoAllowableValue());
        return allowableValues.toArray(new AllowableValue[0]);
    }

    private static AllowableValue buildDefaultWeakCryptoAllowableValue() {
        return new AllowableValue(WEAK_CRYPTO_NOT_ALLOWED_NAME, "Not Allowed", "When set, operation will be blocked and alerts will be presented to the user if unsafe combinations of encryption algorithms and passwords are provided on a JVM with limited strength crypto. To fix this, see the Admin Guide.");
    }

    private static AllowableValue[] buildPGPSymmetricCipherAllowableValues() {
        return new AllowableValue[]{new AllowableValue("1", "IDEA"), new AllowableValue("2", "TRIPLE_DES"), new AllowableValue("3", "CAST5"), new AllowableValue("4", "BLOWFISH"), new AllowableValue("6", "DES"), new AllowableValue("7", "AES_128"), new AllowableValue("8", "AES_192"), new AllowableValue("9", "AES_256"), new AllowableValue("10", "TWOFISH"), new AllowableValue("11", "CAMELLIA_128"), new AllowableValue("12", "CAMELLIA_192"), new AllowableValue("13", "CAMELLIA_256")};
    }

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(MODE);
        properties.add(KEY_DERIVATION_FUNCTION);
        properties.add(ENCRYPTION_ALGORITHM);
        properties.add(ALLOW_WEAK_CRYPTO);
        properties.add(PASSWORD);
        properties.add(RAW_KEY_HEX);
        properties.add(PUBLIC_KEYRING);
        properties.add(PUBLIC_KEY_USERID);
        properties.add(PRIVATE_KEYRING);
        properties.add(PRIVATE_KEYRING_PASSPHRASE);
        properties.add(PGP_SYMMETRIC_ENCRYPTION_CIPHER);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public static boolean isPGPAlgorithm(String algorithm) {
        return algorithm.startsWith("PGP");
    }

    public static boolean isPGPArmoredAlgorithm(String algorithm) {
        return EncryptContent.isPGPAlgorithm(algorithm) && algorithm.endsWith("ASCII-ARMOR");
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(context));
        String methodValue = context.getProperty(ENCRYPTION_ALGORITHM).getValue();
        EncryptionMethod encryptionMethod = EncryptionMethod.valueOf((String)methodValue);
        String algorithm = encryptionMethod.getAlgorithm();
        String password = context.getProperty(PASSWORD).getValue();
        KeyDerivationFunction kdf = KeyDerivationFunction.valueOf((String)context.getProperty(KEY_DERIVATION_FUNCTION).getValue());
        String keyHex = context.getProperty(RAW_KEY_HEX).getValue();
        boolean encrypt = context.getProperty(MODE).getValue().equalsIgnoreCase(ENCRYPT_MODE);
        if (EncryptContent.isPGPAlgorithm(algorithm)) {
            String publicKeyring = context.getProperty(PUBLIC_KEYRING).getValue();
            String publicUserId = context.getProperty(PUBLIC_KEY_USERID).getValue();
            String privateKeyring = context.getProperty(PRIVATE_KEYRING).getValue();
            String privateKeyringPassphrase = context.getProperty(PRIVATE_KEYRING_PASSPHRASE).evaluateAttributeExpressions().getValue();
            Integer cipher = context.getProperty(PGP_SYMMETRIC_ENCRYPTION_CIPHER).asInteger();
            validationResults.addAll(this.validatePGP(encryptionMethod, password, encrypt, publicKeyring, publicUserId, privateKeyring, privateKeyringPassphrase, cipher));
        } else {
            boolean allowWeakCrypto = context.getProperty(ALLOW_WEAK_CRYPTO).getValue().equalsIgnoreCase(WEAK_CRYPTO_ALLOWED_NAME);
            if (encryptionMethod.isKeyedCipher()) {
                validationResults.addAll(this.validateKeyed(encryptionMethod, kdf, keyHex, password, allowWeakCrypto, encrypt));
            } else {
                validationResults.addAll(this.validatePBE(encryptionMethod, kdf, password, allowWeakCrypto));
            }
        }
        return validationResults;
    }

    private static boolean isValidCipher(int cipher) {
        return PGP_SYMMETRIC_ENCRYPTION_CIPHER.getAllowableValues().stream().anyMatch(av -> av.getValue().equals(String.valueOf(cipher)));
    }

    private List<ValidationResult> validatePGP(EncryptionMethod encryptionMethod, String password, boolean encrypt, String publicKeyring, String publicUserId, String privateKeyring, String privateKeyringPassphrase, int cipher) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (encrypt && password != null && !EncryptContent.isValidCipher(cipher)) {
            validationResults.add(new ValidationResult.Builder().subject(PGP_SYMMETRIC_ENCRYPTION_CIPHER.getDisplayName()).explanation("When performing an encryption with " + encryptionMethod.getAlgorithm() + " and a symmetric " + PASSWORD.getDisplayName() + ", a" + PGP_SYMMETRIC_ENCRYPTION_CIPHER.getDisplayName() + " is required").build());
        }
        if (password == null) {
            if (encrypt) {
                if (publicKeyring == null || publicUserId == null) {
                    validationResults.add(new ValidationResult.Builder().subject(PUBLIC_KEYRING.getDisplayName()).explanation(encryptionMethod.getAlgorithm() + " encryption without a " + PASSWORD.getDisplayName() + " requires both " + PUBLIC_KEYRING.getDisplayName() + " and " + PUBLIC_KEY_USERID.getDisplayName()).build());
                } else {
                    try {
                        if (OpenPGPKeyBasedEncryptor.getPublicKey(publicUserId, publicKeyring) == null) {
                            validationResults.add(new ValidationResult.Builder().subject(PUBLIC_KEYRING.getDisplayName()).explanation(PUBLIC_KEYRING.getDisplayName() + " " + publicKeyring + " does not contain user id " + publicUserId).build());
                        }
                    }
                    catch (Exception e) {
                        validationResults.add(new ValidationResult.Builder().subject(PUBLIC_KEYRING.getDisplayName()).explanation("Invalid " + PUBLIC_KEYRING.getDisplayName() + " " + publicKeyring + " because " + e.toString()).build());
                    }
                }
            } else if (privateKeyring == null || privateKeyringPassphrase == null) {
                validationResults.add(new ValidationResult.Builder().subject(PRIVATE_KEYRING.getName()).explanation(encryptionMethod.getAlgorithm() + " decryption without a " + PASSWORD.getDisplayName() + " requires both " + PRIVATE_KEYRING.getDisplayName() + " and " + PRIVATE_KEYRING_PASSPHRASE.getDisplayName()).build());
            } else {
                String providerName = encryptionMethod.getProvider();
                try {
                    if (!OpenPGPKeyBasedEncryptor.validateKeyring(providerName, privateKeyring, privateKeyringPassphrase.toCharArray())) {
                        validationResults.add(new ValidationResult.Builder().subject(PRIVATE_KEYRING.getDisplayName()).explanation(PRIVATE_KEYRING.getDisplayName() + " " + privateKeyring + " could not be opened with the provided " + PRIVATE_KEYRING_PASSPHRASE.getDisplayName()).build());
                    }
                }
                catch (Exception e) {
                    validationResults.add(new ValidationResult.Builder().subject(PRIVATE_KEYRING.getDisplayName()).explanation("Invalid " + PRIVATE_KEYRING.getDisplayName() + " " + privateKeyring + " because " + e.toString()).build());
                }
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validatePBE(EncryptionMethod encryptionMethod, KeyDerivationFunction kdf, String password, boolean allowWeakCrypto) {
        List<ValidationResult> validationResults = this.validatePassword(encryptionMethod, kdf, password, allowWeakCrypto);
        List<String> kdfsForPBECipher = this.getKDFsForPBECipher(encryptionMethod);
        if (kdf == null || !kdfsForPBECipher.contains(kdf.name())) {
            String displayName = KEY_DERIVATION_FUNCTION.getDisplayName();
            validationResults.add(new ValidationResult.Builder().subject(displayName).explanation(displayName + " is required to be " + StringUtils.join(kdfsForPBECipher, (String)", ") + " when using algorithm " + encryptionMethod.getAlgorithm() + ". See Admin Guide.").build());
        }
        return validationResults;
    }

    private List<ValidationResult> validatePassword(EncryptionMethod encryptionMethod, KeyDerivationFunction kdf, String password, boolean allowWeakCrypto) {
        int minimumSafePasswordLength;
        boolean limitedStrengthCrypto;
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        boolean bl = limitedStrengthCrypto = !CipherUtility.isUnlimitedStrengthCryptoSupported();
        if (StringUtils.isEmpty((CharSequence)password)) {
            validationResults.add(new ValidationResult.Builder().subject(PASSWORD.getName()).explanation(PASSWORD.getDisplayName() + " is required when using algorithm " + encryptionMethod.getAlgorithm() + " and KDF " + kdf.getKdfName()).build());
            return validationResults;
        }
        int passwordBytesLength = password.getBytes(StandardCharsets.UTF_8).length;
        if (!allowWeakCrypto && passwordBytesLength < (minimumSafePasswordLength = PasswordBasedEncryptor.getMinimumSafePasswordLength())) {
            validationResults.add(new ValidationResult.Builder().subject(PASSWORD.getName()).explanation("Password length less than " + minimumSafePasswordLength + " characters is potentially unsafe. See Admin Guide.").build());
        }
        if (limitedStrengthCrypto) {
            boolean passwordLongerThanLimit;
            if (encryptionMethod.isUnlimitedStrength()) {
                validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_ALGORITHM.getName()).explanation(encryptionMethod.name() + " (" + encryptionMethod.getAlgorithm() + ") is not supported by this JVM due to lacking JCE Unlimited Strength Jurisdiction Policy files. See Admin Guide.").build());
            }
            boolean bl2 = passwordLongerThanLimit = !CipherUtility.passwordLengthIsValidForAlgorithmOnLimitedStrengthCrypto((int)passwordBytesLength, (EncryptionMethod)encryptionMethod);
            if (passwordLongerThanLimit) {
                int maxPasswordLength = CipherUtility.getMaximumPasswordLengthForAlgorithmOnLimitedStrengthCrypto((EncryptionMethod)encryptionMethod);
                validationResults.add(new ValidationResult.Builder().subject(PASSWORD.getName()).explanation("Password length greater than " + maxPasswordLength + " characters is not supported by this JVM due to lacking JCE Unlimited Strength Jurisdiction Policy files. See Admin Guide.").build());
            }
        }
        return validationResults;
    }

    private List<ValidationResult> validateKeyed(EncryptionMethod encryptionMethod, KeyDerivationFunction kdf, String keyHex, String password, boolean allowWeakCrypto, boolean encrypt) {
        boolean limitedStrengthCrypto;
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        boolean bl = limitedStrengthCrypto = !CipherUtility.isUnlimitedStrengthCryptoSupported();
        if (limitedStrengthCrypto && encryptionMethod.isUnlimitedStrength()) {
            validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_ALGORITHM.getName()).explanation(encryptionMethod.name() + " (" + encryptionMethod.getAlgorithm() + ") is not supported by this JVM due to lacking JCE Unlimited Strength Jurisdiction Policy files. See Admin Guide.").build());
        }
        int allowedKeyLength = PasswordBasedEncryptor.getMaxAllowedKeyLength(ENCRYPTION_ALGORITHM.getName());
        if (kdf == KeyDerivationFunction.NONE) {
            if (StringUtils.isEmpty((CharSequence)keyHex)) {
                validationResults.add(new ValidationResult.Builder().subject(RAW_KEY_HEX.getName()).explanation(RAW_KEY_HEX.getDisplayName() + " is required when using algorithm " + encryptionMethod.getAlgorithm() + " and KDF " + KeyDerivationFunction.NONE + ". See Admin Guide.").build());
            } else {
                this.validateKeyHex(encryptionMethod, keyHex, validationResults, allowedKeyLength);
            }
        } else if (kdf.isStrongKDF()) {
            if (StringUtils.isEmpty((CharSequence)password)) {
                validationResults.add(new ValidationResult.Builder().subject(PASSWORD.getName()).explanation(PASSWORD.getDisplayName() + " is required when using algorithm " + encryptionMethod.getAlgorithm() + " and KDF " + kdf.getKdfName() + ". See Admin Guide.").build());
            } else {
                validationResults.addAll(this.validatePassword(encryptionMethod, kdf, password, allowWeakCrypto));
            }
        } else {
            List<String> kdfsForKeyedCipher = this.getKDFsForKeyedCipher();
            validationResults.add(new ValidationResult.Builder().subject(KEY_DERIVATION_FUNCTION.getName()).explanation(KEY_DERIVATION_FUNCTION.getDisplayName() + " is required to be " + StringUtils.join(kdfsForKeyedCipher, (String)", ") + " when using algorithm " + encryptionMethod.getAlgorithm()).build());
        }
        if (encrypt && EncryptionMethod.AES_CBC_NO_PADDING == encryptionMethod) {
            validationResults.add(new ValidationResult.Builder().subject(ENCRYPTION_ALGORITHM.getDisplayName()).input(encryptionMethod.name()).explanation(String.format("Encryption not supported for [%s]", encryptionMethod.getAlgorithm())).valid(false).build());
        }
        return validationResults;
    }

    private void validateKeyHex(EncryptionMethod encryptionMethod, String keyHex, List<ValidationResult> validationResults, int allowedKeyLength) {
        byte[] keyBytes = new byte[]{};
        try {
            keyBytes = Hex.decodeHex((char[])keyHex.toCharArray());
        }
        catch (DecoderException e) {
            validationResults.add(new ValidationResult.Builder().subject(RAW_KEY_HEX.getName()).explanation("Key must be valid hexadecimal string. See Admin Guide.").build());
        }
        if (keyBytes.length * 8 > allowedKeyLength) {
            validationResults.add(new ValidationResult.Builder().subject(RAW_KEY_HEX.getName()).explanation("Key length greater than " + allowedKeyLength + " bits is not supported by this JVM due to lacking JCE Unlimited Strength Jurisdiction Policy files. See Admin Guide.").build());
        }
        if (!CipherUtility.isValidKeyLengthForAlgorithm((int)(keyBytes.length * 8), (String)encryptionMethod.getAlgorithm())) {
            List validKeyLengths = CipherUtility.getValidKeyLengthsForAlgorithm((String)encryptionMethod.getAlgorithm());
            validationResults.add(new ValidationResult.Builder().subject(RAW_KEY_HEX.getName()).explanation("Key must be valid length [" + StringUtils.join((Iterable)validKeyLengths, (String)", ") + "]. See Admin Guide.").build());
        }
    }

    private List<String> getKDFsForKeyedCipher() {
        List<String> kdfs = Arrays.stream(KeyDerivationFunction.values()).filter(KeyDerivationFunction::isStrongKDF).map(Enum::name).collect(Collectors.toList());
        kdfs.add(KeyDerivationFunction.NONE.name());
        return kdfs;
    }

    private List<String> getKDFsForPBECipher(EncryptionMethod encryptionMethod) {
        List<String> kdfsForPBECipher = encryptionMethod.isCompatibleWithStrongKDFs() ? Arrays.stream(KeyDerivationFunction.values()).map(Enum::name).collect(Collectors.toList()) : Arrays.stream(KeyDerivationFunction.values()).filter(kdf -> !kdf.isStrongKDF()).map(Enum::name).collect(Collectors.toList());
        kdfsForPBECipher.remove(KeyDerivationFunction.NONE.name());
        return kdfsForPBECipher;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        StreamCallback callback;
        Encryptor encryptor;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        String method = context.getProperty(ENCRYPTION_ALGORITHM).getValue();
        EncryptionMethod encryptionMethod = EncryptionMethod.valueOf((String)method);
        String providerName = encryptionMethod.getProvider();
        String algorithm = encryptionMethod.getAlgorithm();
        Integer pgpCipher = context.getProperty(PGP_SYMMETRIC_ENCRYPTION_CIPHER).asInteger();
        String password = context.getProperty(PASSWORD).getValue();
        KeyDerivationFunction kdf = KeyDerivationFunction.valueOf((String)context.getProperty(KEY_DERIVATION_FUNCTION).getValue());
        boolean encrypt = context.getProperty(MODE).getValue().equalsIgnoreCase(ENCRYPT_MODE);
        try {
            encryptor = EncryptContent.isPGPAlgorithm(algorithm) ? this.createPGPEncryptor(context, flowFile, providerName, algorithm, pgpCipher, password, encrypt) : (kdf.equals((Object)KeyDerivationFunction.NONE) ? this.createKeyedEncryptor(context, encryptionMethod) : this.createPBEEncryptor(encryptionMethod, password, kdf));
            callback = encrypt ? encryptor.getEncryptionCallback() : encryptor.getDecryptionCallback();
        }
        catch (Exception e) {
            logger.error("Failed to initialize {}cryption algorithm because - ", new Object[]{encrypt ? "en" : "de", e});
            session.rollback();
            context.yield();
            return;
        }
        try {
            StopWatch stopWatch = new StopWatch(true);
            flowFile = session.write(flowFile, callback);
            HashMap<String, String> clonedAttributes = new HashMap<String, String>(flowFile.getAttributes());
            encryptor.updateAttributes(clonedAttributes);
            flowFile = session.putAllAttributes(flowFile, clonedAttributes);
            logger.info("successfully {}crypted {}", new Object[]{encrypt ? "en" : "de", flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (ProcessException e) {
            logger.error("Cannot {}crypt {} - ", new Object[]{encrypt ? "en" : "de", flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private Encryptor createPGPEncryptor(ProcessContext context, FlowFile flowFile, String providerName, String algorithm, Integer pgpCipher, String password, boolean encrypt) {
        Encryptor encryptor;
        String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        String publicKeyring = context.getProperty(PUBLIC_KEYRING).getValue();
        String privateKeyring = context.getProperty(PRIVATE_KEYRING).getValue();
        if (encrypt && publicKeyring != null) {
            String publicUserId = context.getProperty(PUBLIC_KEY_USERID).getValue();
            encryptor = new OpenPGPKeyBasedEncryptor(algorithm, pgpCipher, providerName, publicKeyring, publicUserId, null, filename);
        } else if (!encrypt && privateKeyring != null) {
            char[] keyringPassphrase = context.getProperty(PRIVATE_KEYRING_PASSPHRASE).evaluateAttributeExpressions().getValue().toCharArray();
            encryptor = new OpenPGPKeyBasedEncryptor(algorithm, pgpCipher, providerName, privateKeyring, null, keyringPassphrase, filename);
        } else {
            char[] passphrase = Normalizer.normalize(password, Normalizer.Form.NFC).toCharArray();
            encryptor = new OpenPGPPasswordBasedEncryptor(algorithm, pgpCipher, providerName, passphrase, filename);
        }
        return encryptor;
    }

    private Encryptor createKeyedEncryptor(ProcessContext context, EncryptionMethod encryptionMethod) throws DecoderException {
        String keyHex = context.getProperty(RAW_KEY_HEX).getValue();
        KeyedEncryptor encryptor = new KeyedEncryptor(encryptionMethod, Hex.decodeHex((char[])keyHex.toCharArray()));
        return encryptor;
    }

    private Encryptor createPBEEncryptor(EncryptionMethod encryptionMethod, String password, KeyDerivationFunction kdf) {
        char[] passphrase = Normalizer.normalize(password, Normalizer.Form.NFC).toCharArray();
        PasswordBasedEncryptor encryptor = new PasswordBasedEncryptor(encryptionMethod, passphrase, kdf);
        return encryptor;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static interface Encryptor {
        public StreamCallback getEncryptionCallback() throws Exception;

        public StreamCallback getDecryptionCallback() throws Exception;

        public void updateAttributes(Map<String, String> var1);
    }
}

