/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.filesystem;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;

public class DefaultVirtualFileSystem
implements VirtualFileSystem {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<VirtualPath> existingPaths = new ArrayList<VirtualPath>();

    public DefaultVirtualFileSystem() {
        this.existingPaths.add(ROOT);
    }

    @Override
    public boolean mkdir(VirtualPath newFile) {
        this.lock.writeLock().lock();
        try {
            if (this.existingPaths.contains(newFile)) {
                boolean bl = false;
                return bl;
            }
            if (this.existingPaths.contains(newFile.getParent())) {
                this.existingPaths.add(newFile);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean exists(VirtualPath virtualFile) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.existingPaths.contains(virtualFile);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean delete(VirtualPath virtualFile) {
        if (virtualFile.equals(ROOT)) {
            return false;
        }
        this.lock.writeLock().lock();
        try {
            if (this.existingPaths.contains(virtualFile) && !this.hasSubDirectories(virtualFile)) {
                boolean bl = this.existingPaths.remove(virtualFile);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean hasSubDirectories(VirtualPath directory) {
        return this.existingPaths.stream().anyMatch(e -> this.isChildOf(directory, (VirtualPath)e));
    }

    private boolean isChildOf(VirtualPath parent, VirtualPath childCandidate) {
        if (childCandidate.equals(ROOT)) {
            return false;
        }
        return parent.equals(childCandidate.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualPath> listChildren(VirtualPath parent) {
        List<VirtualPath> children;
        this.lock.readLock().lock();
        try {
            if (parent.equals(ROOT)) {
                children = this.existingPaths.stream().filter(existingPath -> !existingPath.equals(ROOT) && existingPath.getNameCount() == 1).collect(Collectors.toList());
            } else {
                int parentNameCount = parent.getNameCount();
                children = this.existingPaths.stream().filter(existingPath -> existingPath.getParent() != null && existingPath.getParent().equals(parent) && existingPath.getNameCount() == parentNameCount + 1).collect(Collectors.toList());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return children;
    }

    @Override
    public int getTotalNumberOfFiles() {
        this.lock.readLock().lock();
        try {
            int n = this.existingPaths.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

