/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.nifi.toolkit.tls.commandLine.BaseTlsToolkitCommandLine;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.util.StringUtils;

public abstract class BaseCertificateAuthorityCommandLine
extends BaseTlsToolkitCommandLine {
    public static final String TOKEN_ARG = "token";
    public static final String CONFIG_JSON_ARG = "configJson";
    public static final String READ_CONFIG_JSON_ARG = "configJsonIn";
    public static final String USE_CONFIG_JSON_ARG = "useConfigJson";
    public static final String PORT_ARG = "PORT";
    public static final String DEFAULT_CONFIG_JSON = new File("config.json").getPath();
    private String token;
    private String configJsonOut;
    private String configJsonIn;
    private int port;
    private String dn;

    public BaseCertificateAuthorityCommandLine(String header) {
        super(header);
        this.addOptionWithArg("t", TOKEN_ARG, this.getTokenDescription());
        this.addOptionWithArg("f", CONFIG_JSON_ARG, "The place to write configuration info", DEFAULT_CONFIG_JSON);
        this.addOptionWithArg(null, READ_CONFIG_JSON_ARG, "The place to read configuration info from (defaults to the value of configJson), implies useConfigJson if set.", "configJson value");
        this.addOptionNoArg("F", USE_CONFIG_JSON_ARG, "Flag specifying that all configuration is read from configJson to facilitate automated use (otherwise configJson will only be written to.");
        this.addOptionWithArg("p", PORT_ARG, this.getPortDescription(), 8443);
        this.addOptionWithArg("D", "dn", this.getDnDescription(), new TlsConfig().calcDefaultDn(this.getDnHostname()));
    }

    protected abstract String getTokenDescription();

    protected abstract String getDnDescription();

    protected abstract String getPortDescription();

    protected abstract String getDnHostname();

    @Override
    protected CommandLine doParse(String[] args) throws CommandLineParseException {
        CommandLine commandLine = super.doParse(args);
        this.token = commandLine.getOptionValue(TOKEN_ARG);
        boolean useConfigJson = commandLine.hasOption(USE_CONFIG_JSON_ARG);
        this.configJsonOut = commandLine.getOptionValue(CONFIG_JSON_ARG, DEFAULT_CONFIG_JSON);
        this.configJsonIn = commandLine.getOptionValue(READ_CONFIG_JSON_ARG);
        if (StringUtils.isEmpty((String)this.configJsonIn) && useConfigJson) {
            this.configJsonIn = this.configJsonOut;
        }
        if (StringUtils.isEmpty((String)this.token) && StringUtils.isEmpty((String)this.configJsonIn)) {
            this.printUsageAndThrow("token argument must not be empty unless useConfigJson or configJsonIn set", ExitCode.ERROR_TOKEN_ARG_EMPTY);
        }
        this.port = this.getIntValue(commandLine, PORT_ARG, 8443);
        this.dn = commandLine.getOptionValue("dn", new TlsConfig().calcDefaultDn(this.getDnHostname()));
        return commandLine;
    }

    public String getToken() {
        return this.token;
    }

    public String getConfigJsonOut() {
        return this.configJsonOut;
    }

    public String getConfigJsonIn() {
        return this.configJsonIn;
    }

    public int getPort() {
        return this.port;
    }

    public String getDn() {
        return this.dn;
    }
}

