/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.service.client.TlsCertificateAuthorityClientSocketFactory;
import org.apache.nifi.toolkit.tls.service.dto.TlsCertificateAuthorityRequest;
import org.apache.nifi.toolkit.tls.service.dto.TlsCertificateAuthorityResponse;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCertificateSigningRequestPerformer {
    public static final String RECEIVED_RESPONSE_CODE = "Received response code ";
    public static final String EXPECTED_ONE_CERTIFICATE = "Expected one certificate";
    public static final String EXPECTED_RESPONSE_TO_CONTAIN_HMAC = "Expected response to contain hmac";
    public static final String UNEXPECTED_HMAC_RECEIVED_POSSIBLE_MAN_IN_THE_MIDDLE = "Unexpected hmac received, possible man in the middle";
    public static final String EXPECTED_RESPONSE_TO_CONTAIN_CERTIFICATE = "Expected response to contain certificate";
    private final Logger logger = LoggerFactory.getLogger(TlsCertificateSigningRequestPerformer.class);
    private final Supplier<HttpClientBuilder> httpClientBuilderSupplier;
    private final String caHostname;
    private final String dn;
    private final String domainAlternativeNames;
    private final String token;
    private final int port;
    private final ObjectMapper objectMapper;
    private final String signingAlgorithm;

    public TlsCertificateSigningRequestPerformer(TlsClientConfig tlsClientConfig) throws NoSuchAlgorithmException {
        this(HttpClientBuilder::create, tlsClientConfig.getCaHostname(), tlsClientConfig.getDn(), tlsClientConfig.getDomainAlternativeNames(), tlsClientConfig.getToken(), tlsClientConfig.getPort(), tlsClientConfig.getSigningAlgorithm());
    }

    protected TlsCertificateSigningRequestPerformer(Supplier<HttpClientBuilder> httpClientBuilderSupplier, TlsClientConfig tlsClientConfig) throws NoSuchAlgorithmException {
        this(httpClientBuilderSupplier, tlsClientConfig.getCaHostname(), tlsClientConfig.getDn(), tlsClientConfig.getDomainAlternativeNames(), tlsClientConfig.getToken(), tlsClientConfig.getPort(), tlsClientConfig.getSigningAlgorithm());
    }

    private TlsCertificateSigningRequestPerformer(Supplier<HttpClientBuilder> httpClientBuilderSupplier, String caHostname, String dn, String domainAlternativeNames, String token, int port, String signingAlgorithm) {
        this.httpClientBuilderSupplier = httpClientBuilderSupplier;
        this.caHostname = caHostname;
        this.dn = CertificateUtils.reorderDn((String)dn);
        this.domainAlternativeNames = domainAlternativeNames;
        this.token = token;
        this.port = port;
        this.objectMapper = new ObjectMapper();
        this.signingAlgorithm = signingAlgorithm;
    }

    public X509Certificate[] perform(KeyPair keyPair) throws IOException {
        try {
            int responseCode;
            String jsonResponseString;
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            HttpClientBuilder httpClientBuilder = this.httpClientBuilderSupplier.get();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            sslContextBuilder.useProtocol("TLSv1.2");
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new TlsCertificateAuthorityClientSocketFactory(sslContextBuilder.build(), this.caHostname, certificates));
            try (CloseableHttpClient client = httpClientBuilder.build();){
                JcaPKCS10CertificationRequest request = TlsHelper.generateCertificationRequest(this.dn, this.domainAlternativeNames, keyPair, this.signingAlgorithm);
                TlsCertificateAuthorityRequest tlsCertificateAuthorityRequest = new TlsCertificateAuthorityRequest(TlsHelper.calculateHMac(this.token, request.getPublicKey()), TlsHelper.pemEncodeJcaObject(request));
                HttpPost httpPost = new HttpPost();
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(this.objectMapper.writeValueAsBytes((Object)tlsCertificateAuthorityRequest)));
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Requesting certificate with dn " + this.dn + " from " + this.caHostname + ":" + this.port);
                }
                try (CloseableHttpResponse response = client.execute(new HttpHost(this.caHostname, this.port, "https"), (HttpRequest)httpPost);){
                    jsonResponseString = IOUtils.toString((InputStream)new BoundedInputStream(response.getEntity().getContent(), 0x100000L), (Charset)StandardCharsets.UTF_8);
                    responseCode = response.getStatusLine().getStatusCode();
                }
            }
            if (responseCode != 200) {
                throw new IOException(RECEIVED_RESPONSE_CODE + responseCode + " with payload " + jsonResponseString);
            }
            if (certificates.size() != 1) {
                throw new IOException(EXPECTED_ONE_CERTIFICATE);
            }
            TlsCertificateAuthorityResponse tlsCertificateAuthorityResponse = (TlsCertificateAuthorityResponse)this.objectMapper.readValue(jsonResponseString, TlsCertificateAuthorityResponse.class);
            if (!tlsCertificateAuthorityResponse.hasHmac()) {
                throw new IOException(EXPECTED_RESPONSE_TO_CONTAIN_HMAC);
            }
            X509Certificate caCertificate = (X509Certificate)certificates.get(0);
            byte[] expectedHmac = TlsHelper.calculateHMac(this.token, caCertificate.getPublicKey());
            if (!MessageDigest.isEqual(expectedHmac, tlsCertificateAuthorityResponse.getHmac())) {
                throw new IOException(UNEXPECTED_HMAC_RECEIVED_POSSIBLE_MAN_IN_THE_MIDDLE);
            }
            if (!tlsCertificateAuthorityResponse.hasCertificate()) {
                throw new IOException(EXPECTED_RESPONSE_TO_CONTAIN_CERTIFICATE);
            }
            X509Certificate x509Certificate = TlsHelper.parseCertificate(new StringReader(tlsCertificateAuthorityResponse.getPemEncodedCertificate()));
            x509Certificate.verify(caCertificate.getPublicKey());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Got certificate with dn " + x509Certificate.getSubjectX500Principal());
            }
            return new X509Certificate[]{x509Certificate, caCertificate};
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

