/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.instance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -8401944412490389024L;
    private Type injectionClazz;
    private Class<?> injectionPointClazz;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();
    private WebBeansContext webBeansContext;

    InstanceImpl(Type injectionClazz, Class<?> injectionPointClazz, WebBeansContext webBeansContext, Annotation ... annotations) {
        this.injectionClazz = injectionClazz;
        this.injectionPointClazz = injectionPointClazz;
        for (Annotation ann : annotations) {
            this.qualifierAnnotations.add(ann);
        }
        this.webBeansContext = webBeansContext;
    }

    public T get() {
        T instance = null;
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        Set<Bean<?>> beans = this.resolveBeans();
        this.webBeansContext.getResolutionUtil().checkResolvedBeans(beans, ClassUtil.getClazz(this.injectionClazz), anns);
        Bean<?> bean = beans.iterator().next();
        instance = (T)this.webBeansContext.getBeanManagerImpl().getInstance(bean, null);
        return instance;
    }

    private Set<Bean<?>> resolveBeans() {
        InjectionResolver injectionResolver;
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        InjectionResolver resolver = injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Set<Bean<?>> beans = resolver.implResolveByType(this.injectionClazz, this.injectionPointClazz, anns);
        return beans;
    }

    public boolean isAmbiguous() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() > 1;
    }

    public boolean isUnsatisfied() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() == 0;
    }

    public Instance<T> select(Annotation ... qualifiers) {
        Annotation[] newQualifiersArray = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(this.injectionClazz, this.injectionPointClazz, this.webBeansContext, newQualifiersArray);
        return newInstance;
    }

    private Annotation[] getAdditionalQualifiers(Annotation[] qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifierAnnotations);
        if (qualifiers != null && qualifiers.length > 0) {
            for (Annotation annot : qualifiers) {
                if (newQualifiers.contains(annot)) {
                    throw new IllegalArgumentException("Duplicate Qualifier Exception, " + this.toString());
                }
                newQualifiers.add(annot);
            }
        }
        Annotation[] newQualifiersArray = new Annotation[newQualifiers.size()];
        newQualifiersArray = newQualifiers.toArray(newQualifiersArray);
        return newQualifiersArray;
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        Type sub = subtype;
        if (sub == null) {
            sub = this.injectionClazz;
        }
        Annotation[] newQualifiers = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(sub, this.injectionPointClazz, this.webBeansContext, newQualifiers);
        return newInstance;
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.select(subtype.getRawType(), qualifiers);
    }

    public Iterator<T> iterator() {
        Set<Bean<?>> beans = this.resolveBeans();
        HashSet instances = new HashSet();
        for (Bean<?> bean : beans) {
            Object instance = this.webBeansContext.getBeanManagerImpl().getInstance(bean, null);
            instances.add(instance);
        }
        return instances.iterator();
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(op);
        oos.writeObject(this.injectionClazz);
        oos.writeObject(this.qualifierAnnotations);
        oos.writeObject(this.injectionPointClazz);
        oos.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        OwbCustomObjectInputStream inputStream = new OwbCustomObjectInputStream(in, WebBeansUtil.getCurrentClassLoader());
        this.injectionClazz = (Type)inputStream.readObject();
        this.qualifierAnnotations = (Set)inputStream.readObject();
        this.injectionPointClazz = (Class)inputStream.readObject();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance<");
        builder.append(ClassUtil.getClazz(this.injectionClazz).getName());
        builder.append("> injectionPointClazz=").append(this.injectionPointClazz);
        builder.append(",with qualifier annotations {");
        boolean i = false;
        for (Annotation qualifier : this.qualifierAnnotations) {
            if (i) {
                builder.append(",");
            }
            builder.append(((Object)qualifier).toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

