/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.Nonbinding;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.NullableDependencyException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionResolver {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(InjectionResolver.class);
    private WebBeansContext webBeansContext;
    private static final Annotation[] DEFAULT_LITERAL_ARRAY = new Annotation[]{new DefaultLiteral()};
    private static final Annotation[] ANY_LITERAL_ARRAY = new Annotation[]{new AnyLiteral()};
    private Map<Long, Set<Bean<?>>> resolvedBeansByType = new ConcurrentHashMap();
    private Map<String, Set<Bean<?>>> resolvedBeansByName = new ConcurrentHashMap();
    public static ThreadLocal<InjectionPoint> injectionPoints = new ThreadLocal();

    public InjectionResolver(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void clearCaches() {
        this.resolvedBeansByName.clear();
        this.resolvedBeansByType.clear();
    }

    public void checkInjectionPointType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define Type Variable generic type");
        }
    }

    public void checkInjectionPoints(InjectionPoint injectionPoint) {
        Bean bean;
        Class clazz;
        WebBeansUtil.checkInjectionPointNamedQualifier(injectionPoint);
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " type can not be defined as Typevariable or Wildcard type!");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
        qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
        Set beanSet = this.implResolveByType(type, injectionPoint.getBean().getBeanClass(), qualifiers);
        if (beanSet.isEmpty() && qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
            New newQualifier = (New)qualifiers[0];
            if (newQualifier.value() == New.class) {
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(clazz, type));
            } else {
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newQualifier.value(), null));
            }
        }
        if ((bean = this.resolve(beanSet)) == null) {
            InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
        }
        if (clazz.isPrimitive() && bean.isNullable()) {
            throw new NullableDependencyException("Injection point type : " + injectionPoint + " type is primitive but resolved bean can have nullable objects!");
        }
    }

    public Bean<?> getInjectionPointBean(InjectionPoint injectionPoint) {
        Set beanSet;
        Class clazz;
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Set qualSet = injectionPoint.getQualifiers();
        Annotation[] qualifiers = qualSet.toArray(new Annotation[qualSet.size()]);
        if (this.isInstanceOrEventInjection(type)) {
            qualifiers = new Annotation[]{new AnyLiteral()};
        }
        Class injectionPointClass = null;
        if (injectionPoint.getBean() != null) {
            injectionPointClass = injectionPoint.getBean().getBeanClass();
        }
        if ((beanSet = this.implResolveByType(type, injectionPointClass, qualifiers)).isEmpty()) {
            if (qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
                New newQualifier = (New)qualifiers[0];
                if (newQualifier.value() == New.class) {
                    beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(clazz, type));
                } else {
                    beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newQualifier.value(), null));
                }
            } else {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
            }
        }
        return this.resolve(beanSet);
    }

    private boolean isInstanceOrEventInjection(Type type) {
        ParameterizedType pt;
        Class clazz;
        boolean injectInstanceOrEventProvider = false;
        if (type instanceof ParameterizedType && ((clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Instance.class) || clazz.isAssignableFrom(Event.class))) {
            injectInstanceOrEventProvider = true;
        }
        return injectInstanceOrEventProvider;
    }

    public Set<Bean<?>> implResolveByName(String name) {
        Set<Bean<?>> specializedComponents;
        Asserts.assertNotNull(name, "name parameter can not be null");
        String cacheKey = name;
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByName.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        Set<Bean<?>> deployedComponents = this.webBeansContext.getBeanManagerImpl().getBeans();
        for (Bean<?> component : deployedComponents) {
            if (component.getName() == null || !component.getName().equals(name)) continue;
            resolvedComponents.add(component);
        }
        if ((resolvedComponents = this.findByEnabled(resolvedComponents)).size() > 1 && (specializedComponents = this.findSpecializedForNameResolution(resolvedComponents)).size() > 0) {
            resolvedComponents = specializedComponents;
        }
        if (resolvedComponents.isEmpty()) {
            this.resolvedBeansByName.put(cacheKey, Collections.EMPTY_SET);
        } else {
            this.resolvedBeansByName.put(cacheKey, resolvedComponents);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DEBUG_ADD_BYNAME_CACHE_BEANS", cacheKey);
        }
        return resolvedComponents;
    }

    private Set<Bean<?>> findByEnabled(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isEnabled()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    private Set<Bean<?>> findSpecializedForNameResolution(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isSpecializedBean()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    public Set<Bean<?>> implResolveByType(Type injectionPointType, Annotation ... qualifiers) {
        return this.implResolveByType(injectionPointType, (Class<?>)null, qualifiers);
    }

    private String getBDABeansXMLPath(Class<?> injectionPointBeanClass) {
        if (injectionPointBeanClass == null) {
            return null;
        }
        ScannerService scannerService = this.webBeansContext.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        return beansXMLScanner.getBeansXml(injectionPointBeanClass);
    }

    public Set<Bean<?>> implResolveByType(Type injectionPointType, Class<?> injectinPointClass, Annotation ... qualifiers) {
        ScannerService scannerService = this.webBeansContext.getScannerService();
        String bdaBeansXMLFilePath = null;
        if (scannerService.isBDABeansXmlScanningEnabled()) {
            InjectionPoint ip;
            if (injectinPointClass == null && (ip = injectionPoints.get()) != null) {
                injectinPointClass = ip.getBean().getBeanClass();
            }
            bdaBeansXMLFilePath = this.getBDABeansXMLPath(injectinPointClass);
        }
        boolean currentQualifier = false;
        if (this.isInstanceOrEventInjection(injectionPointType)) {
            qualifiers = ANY_LITERAL_ARRAY;
        } else if (qualifiers.length == 0) {
            qualifiers = DEFAULT_LITERAL_ARRAY;
            currentQualifier = true;
        }
        Long cacheKey = this.getBeanCacheKey(injectionPointType, bdaBeansXMLFilePath, qualifiers);
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByType.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        boolean returnAll = false;
        if (injectionPointType.equals(Object.class) && currentQualifier) {
            returnAll = true;
        }
        block0: for (Bean<?> component : this.webBeansContext.getBeanManagerImpl().getBeans()) {
            if (!((OwbBean)component).isEnabled()) continue;
            if (returnAll) {
                resolvedComponents.add(component);
                continue;
            }
            for (Type componentApiType : component.getTypes()) {
                if (!ClassUtil.isAssignable(componentApiType, injectionPointType)) continue;
                resolvedComponents.add(component);
                continue block0;
            }
        }
        if ((resolvedComponents = this.findByQualifier(resolvedComponents, qualifiers)).size() > 1) {
            resolvedComponents = this.findBySpecialization(resolvedComponents);
        }
        this.resolvedBeansByType.put(cacheKey, resolvedComponents);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DEBUG_ADD_BYTYPE_CACHE_BEANS", cacheKey);
        }
        return resolvedComponents;
    }

    private Long getBeanCacheKey(Type injectionPointType, String bdaBeansXMLPath, Annotation ... qualifiers) {
        long cacheKey = this.getTypeHashCode(injectionPointType);
        if (bdaBeansXMLPath != null) {
            cacheKey += 29L * (long)bdaBeansXMLPath.hashCode();
        }
        for (Annotation a : qualifiers) {
            cacheKey += 29L * this.getQualifierHashCode(a);
        }
        return cacheKey;
    }

    private int getTypeHashCode(Type type) {
        int typeHash = type.hashCode();
        if (typeHash == 0) {
            return type.toString().hashCode();
        }
        return typeHash;
    }

    private long getQualifierHashCode(Annotation a) {
        Method[] methods;
        Class annotationClass = this.getAnnotationClass(a.getClass());
        if (annotationClass == null) {
            return this.getTypeHashCode(a.getClass());
        }
        long hashCode = this.getTypeHashCode(annotationClass);
        for (Method method : methods = annotationClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Nonbinding.class)) continue;
            int name = 127 * method.getName().hashCode();
            Object object = this.callMethod(a, method);
            int value = 0;
            if (object.getClass().isArray()) {
                Class<?> type = object.getClass().getComponentType();
                if (type.isPrimitive()) {
                    if (Long.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Integer.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Integer[])object));
                    } else if (Short.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Short[])object));
                    } else if (Double.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Double[])object));
                    } else if (Float.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Float[])object));
                    } else if (Boolean.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Byte.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Byte[])object));
                    } else if (Character.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Character[])object));
                    }
                } else {
                    value = Arrays.hashCode((Object[])object);
                }
            } else {
                value = object.hashCode();
            }
            hashCode += (long)(name ^ value);
            hashCode += 29L * (long)((Object)a).hashCode();
        }
        return hashCode;
    }

    private Class getAnnotationClass(Class a) {
        for (Class<?> i : a.getInterfaces()) {
            if (!i.isAnnotation()) continue;
            return i;
        }
        return null;
    }

    private Object callMethod(Object instance, Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, AnnotationUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in method call : " + method.getName(), e);
        }
    }

    public Set<Bean<?>> findBySpecialization(Set<Bean<?>> result) {
        Iterator<Bean<?>> it = result.iterator();
        HashSet res = new HashSet();
        while (it.hasNext()) {
            AbstractOwbBean component = (AbstractOwbBean)it.next();
            if (!component.isSpecializedBean() || !component.isEnabled()) continue;
            res.add(component);
        }
        if (res.size() > 0) {
            return res;
        }
        return result;
    }

    public Set<Bean<?>> findByAlternatives(Set<Bean<?>> result) {
        return this.findByAlternatives(result, null);
    }

    public Set<Bean<?>> findByAlternatives(Set<Bean<?>> result, String bdaBeansXMLFilePath) {
        HashSet alternativeSet = new HashSet();
        HashSet enableSet = new HashSet();
        boolean containsAlternative = false;
        if (bdaBeansXMLFilePath != null) {
            for (Bean<?> bean : result) {
                if (bean.isAlternative()) {
                    if (!this.isAltBeanInInjectionPointBDA(bdaBeansXMLFilePath, bean)) continue;
                    if (!containsAlternative) {
                        containsAlternative = true;
                    }
                    alternativeSet.add(bean);
                    continue;
                }
                if (containsAlternative) continue;
                enableSet.add(bean);
            }
        } else {
            for (Bean<?> bean : result) {
                AbstractOwbBean temp;
                if (bean.isAlternative()) {
                    if (!containsAlternative) {
                        containsAlternative = true;
                    }
                    alternativeSet.add(bean);
                    continue;
                }
                if (containsAlternative || !(temp = (AbstractOwbBean)bean).isEnabled()) continue;
                enableSet.add(bean);
            }
        }
        if (containsAlternative) {
            return alternativeSet;
        }
        return enableSet;
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Set<Bean<?>> set = new HashSet();
        for (Bean<X> bean : beans) {
            set.add(bean);
        }
        if ((set = this.findByAlternatives(set)) == null || set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            set = this.findBySpecialization(set);
        }
        if (set.size() > 1) {
            InjectionExceptionUtils.throwAmbiguousResolutionException(set);
        }
        return set.iterator().next();
    }

    private boolean isAltBeanInInjectionPointBDA(String bdaBeansXMLFilePath, Bean<?> altBean) {
        ScannerService scannerService = this.webBeansContext.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        Set definedAlternatives = beansXMLScanner.getAlternatives(bdaBeansXMLFilePath);
        if (definedAlternatives.contains(altBean.getBeanClass())) {
            return true;
        }
        Set definedStereotypes = beansXMLScanner.getStereotypes(bdaBeansXMLFilePath);
        for (Class stereoAnnotations : definedStereotypes) {
            if (!AnnotationUtil.hasClassAnnotation(altBean.getBeanClass(), stereoAnnotations)) continue;
            return true;
        }
        return false;
    }

    private Set<Bean<?>> findByQualifier(Set<Bean<?>> remainingSet, Annotation ... annotations) {
        Iterator<Bean<?>> it = remainingSet.iterator();
        HashSet result = new HashSet();
        while (it.hasNext()) {
            Bean<?> component = it.next();
            Set qTypes = component.getQualifiers();
            int i = 0;
            for (Annotation annot : annotations) {
                for (Annotation qualifier : qTypes) {
                    if (!annot.annotationType().equals(qualifier.annotationType()) || !AnnotationUtil.isQualifierEqual(qualifier, annot)) continue;
                    ++i;
                }
            }
            if (i != annotations.length) continue;
            result.add(component);
        }
        return result;
    }
}

