/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.AnnotationDB;
import org.apache.webbeans.corespi.se.BeansXmlAnnotationDB;
import org.apache.webbeans.corespi.se.DefaultBDABeansXmlScanner;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaDataDiscovery
implements ScannerService {
    protected final Logger logger = WebBeansLoggerFacade.getLogger(this.getClass());
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private final Set<URL> webBeansXmlLocations = new HashSet<URL>();
    private AnnotationDB annotationDB;
    protected boolean isBDAScannerEnabled = false;
    protected BDABeansXmlScanner bdaBeansXmlScanner;
    private boolean isCrossReferenzed = false;

    protected AbstractMetaDataDiscovery() {
        this.initAnnotationDB();
    }

    private void initAnnotationDB() {
        try {
            this.annotationDB = new AnnotationDB();
            this.annotationDB.setScanClassAnnotations(true);
            this.annotationDB.setScanFieldAnnotations(true);
            this.annotationDB.setScanMethodAnnotations(true);
            this.annotationDB.setScanParameterAnnotations(true);
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    public void release() {
        this.initAnnotationDB();
    }

    protected abstract void configure();

    protected String[] findBeansXmlBases(String resourceName, ClassLoader loader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<URL> urls = loader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.addWebBeansXmlLocation(url);
                String urlString = url.toString();
                int idx = urlString.lastIndexOf(resourceName);
                urlString = urlString.substring(0, idx);
                list.add(urlString);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list.toArray(new String[list.size()]);
    }

    public void init(Object object) {
        String usage = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
        if (this.isBDAScannerEnabled) {
            this.annotationDB = new BeansXmlAnnotationDB();
            ((BeansXmlAnnotationDB)this.annotationDB).setBdaBeansXmlScanner(this);
            this.bdaBeansXmlScanner = new DefaultBDABeansXmlScanner();
        }
    }

    protected AnnotationDB getAnnotationDB() {
        return this.annotationDB;
    }

    public Set<String> getAllAnnotations(String className) {
        return this.annotationDB.getAnnotationIndex().get(className);
    }

    protected void addWebBeansXmlLocation(URL beansXmlUrl) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("added beans.xml marker: " + beansXmlUrl.toExternalForm());
        }
        this.webBeansXmlLocations.add(beansXmlUrl);
    }

    public Set<Class<?>> getBeanClasses() {
        Set<String> strSet;
        this.crossReferenceBeans();
        HashSet classSet = new HashSet();
        Map<String, Set<String>> index = this.annotationDB.getClassIndex();
        if (index != null && (strSet = index.keySet()) != null) {
            for (String str : strSet) {
                try {
                    Class<?> clazz = ClassUtil.getClassFromName(str);
                    if (clazz == null) continue;
                    clazz.getDeclaredFields();
                    clazz.getDeclaredMethods();
                    classSet.add(clazz);
                }
                catch (NoClassDefFoundError e) {
                    if (!this.logger.isLoggable(Level.WARNING)) continue;
                    this.logger.log(Level.WARNING, "WARN_0018", new Object[]{str, e.toString()});
                }
            }
        }
        return classSet;
    }

    protected synchronized void crossReferenceBeans() {
        if (!this.isCrossReferenzed) {
            try {
                this.annotationDB.crossReferenceMetaAnnotations();
            }
            catch (AnnotationDB.CrossReferenceException e) {
                throw new RuntimeException(e);
            }
            this.isCrossReferenzed = true;
        }
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.webBeansXmlLocations);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }
}

