/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.decorator.Delegate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.AnnotatedTypeBeanCreatorImpl;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebBeansAnnotatedTypeUtil {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansAnnotatedTypeUtil.class);
    private final WebBeansContext webBeansContext;

    public WebBeansAnnotatedTypeUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public static <T> AnnotatedConstructor<T> getBeanConstructor(AnnotatedType<T> type) {
        Asserts.assertNotNull(type, "Type is null");
        AnnotatedConstructor result = null;
        Set annConsts = type.getConstructors();
        if (annConsts != null) {
            boolean found = false;
            boolean noParamConsIsDefined = false;
            for (AnnotatedConstructor annConst : annConsts) {
                List parameters;
                if (annConst.isAnnotationPresent(Inject.class)) {
                    if (found) {
                        throw new WebBeansConfigurationException("There are more than one constructor with @Inject annotation in annotation type : " + type);
                    }
                    found = true;
                    result = annConst;
                    continue;
                }
                if (found || noParamConsIsDefined || (parameters = annConst.getParameters()) == null || !parameters.isEmpty()) continue;
                result = annConst;
                noParamConsIsDefined = true;
            }
        }
        if (result == null) {
            throw new WebBeansConfigurationException("No constructor is found for the annotated type : " + type);
        }
        List parameters = result.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Disposes.class)) {
                throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Disposes annotation in annotated constructor : " + result);
            }
            if (!parameter.isAnnotationPresent(Observes.class)) continue;
            throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Observes annotation in annotated constructor : " + result);
        }
        return result;
    }

    public <T> void addConstructorInjectionPointMetaData(AbstractOwbBean<T> owner, AnnotatedConstructor<T> constructor) {
        InjectionPointFactory injectionPointFactory = owner.getWebBeansContext().getInjectionPointFactory();
        List<InjectionPoint> injectionPoints = injectionPointFactory.getConstructorInjectionPointData(owner, constructor);
        for (InjectionPoint injectionPoint : injectionPoints) {
            this.webBeansContext.getDefinitionUtil().addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public <T, X> void addMethodInjectionPointMetaData(OwbBean<T> owner, AnnotatedMethod<X> method) {
        List<InjectionPoint> injectionPoints = owner.getWebBeansContext().getInjectionPointFactory().getMethodInjectionPointData(owner, method);
        for (InjectionPoint injectionPoint : injectionPoints) {
            this.webBeansContext.getDefinitionUtil().addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public static <T, X> void addFieldInjectionPointMetaData(AbstractOwbBean<T> owner, AnnotatedField<X> annotField) {
        owner.addInjectionPoint(owner.getWebBeansContext().getInjectionPointFactory().getFieldInjectionPointData(owner, annotField));
    }

    public <X> Set<ObserverMethod<?>> defineObserverMethods(AbstractInjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        WebBeansContext webBeansContext = bean.getWebBeansContext();
        HashSet definedObservers = new HashSet();
        Set annotatedMethods = annotatedType.getMethods();
        Iterator i$ = annotatedMethods.iterator();
        while (i$.hasNext()) {
            AnnotatedMethod annotatedMethod;
            AnnotatedMethod annt = annotatedMethod = (AnnotatedMethod)i$.next();
            List parameters = annt.getParameters();
            boolean found = false;
            for (AnnotatedParameter parameter : parameters) {
                if (!parameter.isAnnotationPresent(Observes.class)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            WebBeansAnnotatedTypeUtil.checkObserverMethodConditions(annotatedMethod, annotatedMethod.getDeclaringType().getJavaClass());
            if (bean.getScope().equals(Dependent.class)) {
                AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Observes.class);
                Observes observes = AnnotationUtil.getAnnotatedMethodFirstParameterAnnotation(annotatedMethod, Observes.class);
                Reception reception = observes.notifyObserver();
                if (reception.equals((Object)Reception.IF_EXISTS)) {
                    throw new WebBeansConfigurationException("Dependent Bean : " + bean + " can not define observer method with @Receiver = IF_EXIST");
                }
            }
            bean.addObservableMethod(annotatedMethod.getJavaMember());
            this.addMethodInjectionPointMetaData(bean, annotatedMethod);
            ObserverMethod<?> definedObserver = webBeansContext.getBeanManagerImpl().getNotificationManager().getObservableMethodForAnnotatedMethod(annotatedMethod, bean);
            if (definedObserver == null) continue;
            definedObservers.add(definedObserver);
        }
        return definedObservers;
    }

    public <X> void defineDisposalMethods(AbstractInjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        AnnotationManager annotationManager = bean.getWebBeansContext().getAnnotationManager();
        Set annotatedMethods = annotatedType.getMethods();
        ProducerMethodBean previous = null;
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            Method declaredMethod = annotatedMethod.getJavaMember();
            AnnotatedMethod annt = annotatedMethod;
            List parameters = annt.getParameters();
            boolean found = false;
            for (AnnotatedParameter parameter : parameters) {
                if (!parameter.isAnnotationPresent(Disposes.class)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            WebBeansAnnotatedTypeUtil.checkProducerMethodDisposal(annotatedMethod);
            Type type = AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Disposes.class);
            Annotation[] annot = annotationManager.getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, Disposes.class);
            InjectionResolver injectionResolver = bean.getWebBeansContext().getBeanManagerImpl().getInjectionResolver();
            Set<Bean<?>> set = injectionResolver.implResolveByType(type, annot);
            if (set.isEmpty()) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(type, declaredMethod, annot);
            }
            Bean<?> foundBean = set.iterator().next();
            ProducerMethodBean pr = null;
            if (foundBean == null || !(foundBean instanceof ProducerMethodBean)) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException((Type)annotatedMethod.getDeclaringType().getJavaClass(), declaredMethod, annot);
            }
            pr = (ProducerMethodBean)foundBean;
            if (previous == null) {
                previous = pr;
            } else if (previous.equals(pr)) {
                throw new WebBeansConfigurationException("There are multiple disposal method for the producer method : " + pr.getCreatorMethod().getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass());
            }
            Method producerMethod = pr.getCreatorMethod();
            if (!producerMethod.getDeclaringClass().getName().equals(declaredMethod.getDeclaringClass().getName())) {
                throw new WebBeansConfigurationException("Producer method component of the disposal method : " + declaredMethod.getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass() + " must be in the same class!");
            }
            pr.setDisposalMethod(declaredMethod);
            this.addMethodInjectionPointMetaData(bean, annotatedMethod);
        }
    }

    public <X> void defineInjectedMethods(AbstractInjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            boolean isInitializer = annotatedMethod.isAnnotationPresent(Inject.class);
            if (!isInitializer || annotatedMethod.isStatic()) continue;
            WebBeansAnnotatedTypeUtil.checkForInjectedInitializerMethod(bean, annotatedMethod);
            Method method = annotatedMethod.getJavaMember();
            if (Modifier.isStatic(method.getModifiers())) continue;
            bean.addInjectedMethod(method);
            this.addMethodInjectionPointMetaData(bean, annotatedMethod);
        }
        this.webBeansContext.getDefinitionUtil().defineInternalInjectedMethodsRecursively(bean, annotatedType.getJavaClass());
    }

    public static <X> void defineInjectedFields(AbstractInjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        AnnotationManager annotationManager = bean.getWebBeansContext().getAnnotationManager();
        Set annotatedFields = annotatedType.getFields();
        for (AnnotatedField annotatedField : annotatedFields) {
            int mod;
            if (!annotatedField.isAnnotationPresent(Inject.class) || annotatedField.isAnnotationPresent(Produces.class) || annotatedField.isAnnotationPresent(Delegate.class)) continue;
            Field field = annotatedField.getJavaMember();
            Annotation[] anns = AnnotationUtil.getAnnotationsFromSet(annotatedField.getAnnotations());
            if (Modifier.isPublic(field.getModifiers()) && !bean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Error in annotated field : " + annotatedField + " while definining injected field. If bean has a public modifier injection point, bean scope must be defined as @Dependent");
            }
            Annotation[] qualifierAnns = annotationManager.getQualifierAnnotations(anns);
            if (qualifierAnns.length <= 0) continue;
            if (qualifierAnns.length > 0) {
                annotationManager.checkForNewQualifierForDeployment(annotatedField.getBaseType(), annotatedField.getDeclaringType().getJavaClass(), field.getName(), anns);
            }
            if (Modifier.isStatic(mod = field.getModifiers()) || Modifier.isFinal(mod)) continue;
            bean.addInjectedField(field);
            WebBeansAnnotatedTypeUtil.addFieldInjectionPointMetaData(bean, annotatedField);
        }
        bean.getWebBeansContext().getDefinitionUtil().defineInternalInjectedFieldsRecursively(bean, annotatedType.getJavaClass());
    }

    public <X> Set<ProducerFieldBean<?>> defineProducerFields(InjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        HashSet producerBeans = new HashSet();
        Set annotatedFields = annotatedType.getFields();
        for (AnnotatedField annotatedField : annotatedFields) {
            if (!annotatedField.isAnnotationPresent(Produces.class)) continue;
            Type genericType = annotatedField.getBaseType();
            if (ClassUtil.isParametrizedType(genericType) && !ClassUtil.checkParametrizedType((ParameterizedType)genericType)) {
                throw new WebBeansConfigurationException("Producer annotated field : " + annotatedField + " can not be Wildcard type or Type variable");
            }
            Annotation[] anns = AnnotationUtil.getAnnotationsFromSet(annotatedField.getAnnotations());
            Field field = annotatedField.getJavaMember();
            Annotation resourceAnnotation = AnnotationUtil.hasOwbInjectableResource(anns);
            if (resourceAnnotation != null) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                ResourceReference resourceRef = new ResourceReference(bean.getBeanClass(), field.getName(), field.getType(), resourceAnnotation);
                if (annotatedField.isAnnotationPresent(Named.class)) {
                    throw new WebBeansConfigurationException("Resource producer annotated field : " + annotatedField + " can not define EL name");
                }
                ResourceBean resourceBean = new ResourceBean(field.getType(), bean, resourceRef);
                resourceBean.getTypes().addAll(annotatedField.getTypeClosure());
                definitionUtil.defineQualifiers(resourceBean, anns);
                resourceBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
                resourceBean.setProducerField(field);
                producerBeans.add(resourceBean);
                continue;
            }
            ProducerFieldBean producerFieldBean = new ProducerFieldBean(bean, ClassUtil.getClass(annotatedField.getBaseType()));
            producerFieldBean.setProducerField(field);
            if (ClassUtil.getClass(annotatedField.getBaseType()).isPrimitive()) {
                producerFieldBean.setNullable(false);
            }
            definitionUtil.defineSerializable(producerFieldBean);
            definitionUtil.defineStereoTypes(producerFieldBean, anns);
            this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, producerFieldBean, anns);
            Set types = annotatedField.getTypeClosure();
            producerFieldBean.getTypes().addAll(types);
            definitionUtil.defineScopeType(producerFieldBean, anns, "Annotated producer field: " + annotatedField + "must declare default @Scope annotation", false);
            this.webBeansContext.getWebBeansUtil().checkUnproxiableApiType(producerFieldBean, producerFieldBean.getScope());
            WebBeansUtil.checkProducerGenericType(producerFieldBean, annotatedField.getJavaMember());
            definitionUtil.defineQualifiers(producerFieldBean, anns);
            definitionUtil.defineName(producerFieldBean, anns, WebBeansUtil.getProducerDefaultName(annotatedField.getJavaMember().getName()));
            producerBeans.add(producerFieldBean);
        }
        return producerBeans;
    }

    public <X> Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        HashSet producerBeans = new HashSet();
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (!annotatedMethod.isAnnotationPresent(Produces.class)) continue;
            WebBeansAnnotatedTypeUtil.checkProducerMethodForDeployment(annotatedMethod);
            boolean specialize = false;
            if (annotatedMethod.isAnnotationPresent(Specializes.class)) {
                if (annotatedMethod.isStatic()) {
                    throw new WebBeansConfigurationException("Specializing annotated producer method : " + annotatedMethod + " can not be static");
                }
                specialize = true;
            }
            ProducerMethodBean producerMethodBean = new ProducerMethodBean(bean, ClassUtil.getClass(annotatedMethod.getBaseType()));
            producerMethodBean.setCreatorMethod(annotatedMethod.getJavaMember());
            if (specialize) {
                WebBeansAnnotatedTypeUtil.configureProducerSpecialization(producerMethodBean, annotatedMethod);
            }
            if (ClassUtil.getClass(annotatedMethod.getBaseType()).isPrimitive()) {
                producerMethodBean.setNullable(false);
            }
            definitionUtil.defineSerializable(producerMethodBean);
            definitionUtil.defineStereoTypes(producerMethodBean, AnnotationUtil.getAnnotationsFromSet(annotatedMethod.getAnnotations()));
            this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, producerMethodBean, AnnotationUtil.getAnnotationsFromSet(annotatedMethod.getAnnotations()));
            Set types = annotatedMethod.getTypeClosure();
            producerMethodBean.getTypes().addAll(types);
            definitionUtil.defineScopeType(producerMethodBean, AnnotationUtil.getAnnotationsFromSet(annotatedMethod.getAnnotations()), "Annotated producer method : " + annotatedMethod + "must declare default @Scope annotation", false);
            this.webBeansContext.getWebBeansUtil().checkUnproxiableApiType(producerMethodBean, producerMethodBean.getScope());
            WebBeansUtil.checkProducerGenericType(producerMethodBean, annotatedMethod.getJavaMember());
            definitionUtil.defineQualifiers(producerMethodBean, AnnotationUtil.getAnnotationsFromSet(annotatedMethod.getAnnotations()));
            definitionUtil.defineName(producerMethodBean, AnnotationUtil.getAnnotationsFromSet(annotatedMethod.getAnnotations()), WebBeansUtil.getProducerDefaultName(annotatedMethod.getJavaMember().getName()));
            this.addMethodInjectionPointMetaData(producerMethodBean, annotatedMethod);
            producerBeans.add(producerMethodBean);
        }
        return producerBeans;
    }

    public static <X> void checkProducerMethodForDeployment(AnnotatedMethod<X> annotatedMethod) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        if (annotatedMethod.isAnnotationPresent(Inject.class) || annotatedMethod.isAnnotationPresent(Disposes.class) || annotatedMethod.isAnnotationPresent(Observes.class)) {
            throw new WebBeansConfigurationException("Producer annotated method : " + annotatedMethod + " can not be annotated with" + " @Initializer/@Destructor annotation or has a parameter annotated with @Disposes/@Observes");
        }
    }

    public static <X> void configureProducerSpecialization(AbstractOwbBean<X> bean, AnnotatedMethod<X> annotatedMethod) {
        List annotatedParameters = annotatedMethod.getParameters();
        ArrayList parameters = new ArrayList();
        for (AnnotatedParameter annotatedParam : annotatedParameters) {
            parameters.add(ClassUtil.getClass(annotatedParam.getBaseType()));
        }
        Method superMethod = ClassUtil.getClassMethodWithTypes(annotatedMethod.getDeclaringType().getJavaClass().getSuperclass(), annotatedMethod.getJavaMember().getName(), parameters);
        if (superMethod == null) {
            throw new WebBeansConfigurationException("Anontated producer method specialization is failed : " + annotatedMethod.getJavaMember().getName() + " not found in super class : " + annotatedMethod.getDeclaringType().getJavaClass().getSuperclass().getName() + " for annotated method : " + annotatedMethod);
        }
        if (!AnnotationUtil.hasAnnotation(superMethod.getAnnotations(), Produces.class)) {
            throw new WebBeansConfigurationException("Anontated producer method specialization is failed : " + annotatedMethod.getJavaMember().getName() + " found in super class : " + annotatedMethod.getDeclaringType().getJavaClass().getSuperclass().getName() + " is not annotated with @Produces" + " for annotated method : " + annotatedMethod);
        }
        bean.setSpecializedBean(true);
    }

    private static <X> void checkForInjectedInitializerMethod(AbstractInjectionTargetBean<X> component, AnnotatedMethod<X> annotatedMethod) {
        Method method = annotatedMethod.getJavaMember();
        TypeVariable<Method>[] args = method.getTypeParameters();
        if (args.length > 0) {
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer methods must not be generic.");
        }
        if (annotatedMethod.isAnnotationPresent(Produces.class)) {
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer method can not be annotated with @Produces.");
        }
        AnnotationManager annotationManager = component.getWebBeansContext().getAnnotationManager();
        List annotatedParameters = annotatedMethod.getParameters();
        for (AnnotatedParameter annotatedParameter : annotatedParameters) {
            annotationManager.checkForNewQualifierForDeployment(annotatedParameter.getBaseType(), annotatedMethod.getDeclaringType().getJavaClass(), method.getName(), AnnotationUtil.getAnnotationsFromSet(annotatedParameter.getAnnotations()));
            if (!annotatedParameter.isAnnotationPresent(Disposes.class) && !annotatedParameter.isAnnotationPresent(Observes.class)) continue;
            throw new WebBeansConfigurationException("Error in defining injected methods in annotated method : " + annotatedMethod + ". Reason : Initializer method parameters does not contain @Observes or @Dispose annotations.");
        }
    }

    public static <X> void checkProducerMethodDisposal(AnnotatedMethod<X> annotatedMethod) {
        List parameters = annotatedMethod.getParameters();
        boolean found = false;
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(Disposes.class)) continue;
            if (found) {
                throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Multiple disposes annotation.");
            }
            found = true;
        }
        if (annotatedMethod.isAnnotationPresent(Inject.class) || AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Observes.class) || annotatedMethod.isAnnotationPresent(Produces.class)) {
            throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Disposal methods  can not be annotated with" + " @Initializer/@Destructor/@Produces annotation or has a parameter annotated with @Observes.");
        }
    }

    public static <X> void checkObserverMethodConditions(AnnotatedMethod<X> annotatedMethod, Class<?> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        Method candidateObserverMethod = annotatedMethod.getJavaMember();
        if (AnnotationUtil.hasAnnotatedMethodMultipleParameterAnnotation(annotatedMethod, Observes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not define two parameters with annotated @Observes");
        }
        if (annotatedMethod.isAnnotationPresent(Produces.class) || annotatedMethod.isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation in the list {@Produces, @Initializer, @Destructor}");
        }
        if (AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Observer method : " + candidateObserverMethod.getName() + " in class : " + clazz.getName() + " can not annotated with annotation @Disposes");
        }
    }

    public static <T> Set<InjectionPoint> getJavaEeComponentInstanceInjectionPoints(WebBeansContext webBeansContext, AnnotatedType<T> type) throws IllegalArgumentException {
        try {
            if (type == null) {
                return Collections.emptySet();
            }
            Class clazz = type.getJavaClass();
            ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED, webBeansContext);
            managedBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
            managedBean.setAnnotatedType(type);
            AnnotatedTypeBeanCreatorImpl<T> managedBeanCreator = new AnnotatedTypeBeanCreatorImpl<T>(managedBean);
            managedBeanCreator.setAnnotatedType(type);
            managedBeanCreator.defineInjectedFields();
            managedBeanCreator.defineInjectedMethods();
            return managedBean.getInjectionPoints();
        }
        catch (Exception e) {
            String message = "Error is occured while getting injection points for the Java EE component instance class, " + type.getJavaClass();
            logger.log(Level.SEVERE, message, e);
            throw new IllegalArgumentException(message, e);
        }
    }
}

