/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.webbeans.component.spi.ProducerFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.ProducerMethodProducer;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public class MethodProducerFactory<P>
implements ProducerFactory<P> {
    private AnnotatedMethod<? super P> producerMethod;
    private AnnotatedMethod<? super P> disposalMethod;
    private Bean<P> parent;
    private WebBeansContext webBeansContext;

    public MethodProducerFactory(AnnotatedMethod<? super P> producerMethod, Bean<P> parent, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(producerMethod, "producer method may not be null");
        Asserts.assertNotNull(webBeansContext, "WebBeansContext may not be null");
        this.producerMethod = producerMethod;
        this.parent = parent;
        this.webBeansContext = webBeansContext;
        this.defineDisposalMethod();
    }

    @Override
    public <T> Producer<T> createProducer(Bean<T> bean) {
        HashSet<InjectionPoint> disposalIPs = null;
        if (this.disposalMethod != null) {
            disposalIPs = new HashSet<InjectionPoint>(this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.disposalMethod));
        }
        ProducerMethodProducer producer = new ProducerMethodProducer(this.parent, this.producerMethod, this.disposalMethod, this.createInjectionPoints(bean), disposalIPs, this.webBeansContext);
        return this.webBeansContext.getWebBeansUtil().fireProcessProducerEvent(producer, (AnnotatedMember<?>)this.producerMethod);
    }

    private void defineDisposalMethod() {
        Set<Annotation> producerQualifiers = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(this.producerMethod.getAnnotations());
        if (producerQualifiers.size() == 1 && producerQualifiers.iterator().next().annotationType().equals(Default.class)) {
            producerQualifiers = Collections.emptySet();
        }
        HashSet<Annotation> producerQualifiersWithoutNamed = new HashSet<Annotation>();
        for (Annotation qualifier : producerQualifiers) {
            if (qualifier.annotationType().equals(Named.class)) continue;
            producerQualifiersWithoutNamed.add(qualifier);
        }
        Set annotatedMethods = this.producerMethod.getDeclaringType().getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (!annotatedMethod.getDeclaringType().equals(this.producerMethod.getDeclaringType())) continue;
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                if (!annotatedParameter.isAnnotationPresent(Disposes.class) || !ClassUtil.isAssignable(annotatedParameter.getBaseType(), this.producerMethod.getBaseType())) continue;
                Set<Annotation> producerQualifiersToCompare = producerQualifiers;
                Set<Annotation> disposalQualifiers = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(annotatedParameter.getAnnotations());
                if (disposalQualifiers.size() == 1 && disposalQualifiers.iterator().next().annotationType().equals(Default.class)) {
                    disposalQualifiers = Collections.emptySet();
                }
                if (disposalQualifiers.size() == producerQualifiersToCompare.size() - 1) {
                    producerQualifiersToCompare = producerQualifiersWithoutNamed;
                }
                if (disposalQualifiers.size() != producerQualifiersToCompare.size()) continue;
                boolean same = true;
                for (Annotation disposalQualifier : disposalQualifiers) {
                    boolean found = false;
                    for (Annotation producerQualifier : producerQualifiers) {
                        if (!AnnotationUtil.isCdiAnnotationEqual(producerQualifier, disposalQualifier)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                if (this.disposalMethod != null) {
                    throw new WebBeansConfigurationException("There are multiple disposal method for the producer method : " + this.disposalMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass());
                }
                if (!annotatedMethod.getDeclaringType().equals(this.producerMethod.getDeclaringType())) {
                    throw new WebBeansConfigurationException("Producer method component of the disposal method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass() + " must be in the same class!");
                }
                this.checkDisposalMethod(annotatedMethod);
                this.disposalMethod = annotatedMethod;
            }
        }
    }

    private void checkDisposalMethod(AnnotatedMethod<? super P> annotatedMethod) {
        boolean found = false;
        for (AnnotatedParameter parameter : annotatedMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(Disposes.class)) continue;
            if (found) {
                throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Multiple disposes annotation.");
            }
            found = true;
        }
        if (annotatedMethod.isAnnotationPresent(Inject.class) || AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Observes.class) || annotatedMethod.isAnnotationPresent(Produces.class)) {
            throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Disposal methods  can not be annotated with" + " @Initializer/@Destructor/@Produces annotation or has a parameter annotated with @Observes.");
        }
    }

    protected Set<InjectionPoint> createInjectionPoints(Bean<?> bean) {
        return new HashSet<InjectionPoint>(this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.producerMethod));
    }
}

