/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.MethodProducerFactory;
import org.apache.webbeans.component.creation.ProducerMethodBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerMethodBeansBuilder<T, I extends InjectionTargetBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ProducerMethodBeansBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<T> bean) {
        HashSet producerBeans = new HashSet();
        Set annotatedMethods = this.annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            boolean enterprise = EnterpriseBeanMarker.class.isInstance(bean);
            if (!annotatedMethod.isAnnotationPresent(Produces.class) || !annotatedMethod.getDeclaringType().getJavaClass().equals(this.annotatedType.getJavaClass()) && (!enterprise || !this.annotatedType.getJavaClass().isAssignableFrom(this.annotatedType.getJavaClass()))) continue;
            this.checkProducerMethodForDeployment(annotatedMethod);
            boolean specialize = false;
            if (annotatedMethod.isAnnotationPresent(Specializes.class)) {
                if (annotatedMethod.isStatic()) {
                    throw new WebBeansConfigurationException("Specializing annotated producer method : " + annotatedMethod + " can not be static");
                }
                specialize = true;
            }
            BeanAttributesImpl beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedMethod).build();
            ProducerMethodBeanBuilder<T> producerMethodBeanCreator = new ProducerMethodBeanBuilder<T>(bean, annotatedMethod, beanAttributes);
            ProducerMethodBean<T> producerMethodBean = producerMethodBeanCreator.getBean();
            this.webBeansContext.getDeploymentValidationService().validateProxyable(producerMethodBean);
            if (specialize) {
                producerMethodBeanCreator.configureProducerSpecialization(producerMethodBean, annotatedMethod);
            }
            MethodProducerFactory<T> producerFactory = new MethodProducerFactory<T>(annotatedMethod, bean, this.webBeansContext);
            producerMethodBean.setCreatorMethod(annotatedMethod.getJavaMember());
            this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, producerMethodBean, AnnotationUtil.asArray(annotatedMethod.getAnnotations()));
            WebBeansUtil.checkProducerGenericType(producerMethodBean, annotatedMethod.getJavaMember());
            producerBeans.add(producerMethodBean);
        }
        block1: for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            for (AnnotatedParameter param : annotatedMethod.getParameters()) {
                if (!param.isAnnotationPresent(Disposes.class)) continue;
                boolean found = false;
                for (ProducerMethodBean producerMethodBean : producerBeans) {
                    if (!ClassUtil.isAssignable(param.getBaseType(), producerMethodBean.getCreatorMethod().getGenericReturnType())) continue;
                    found = true;
                    break;
                }
                if (found) continue block1;
                throw new WebBeansConfigurationException("@Disposes without @Produces " + annotatedMethod.getJavaMember());
            }
        }
        return producerBeans;
    }

    private void checkProducerMethodForDeployment(AnnotatedMethod<? super T> annotatedMethod) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        if (annotatedMethod.isAnnotationPresent(Inject.class) || annotatedMethod.isAnnotationPresent(Disposes.class) || annotatedMethod.isAnnotationPresent(Observes.class)) {
            throw new WebBeansConfigurationException("Producer annotated method : " + annotatedMethod + " can not be annotated with" + " @Initializer/@Destructor annotation or has a parameter annotated with @Disposes/@Observes");
        }
    }
}

