/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import javax.enterprise.util.Nonbinding;
import org.apache.webbeans.util.AnnotationUtil;

public final class BeanCacheKey {
    private final Type type;
    private final String path;
    private final Annotation qualifier;
    private final Annotation[] qualifiers;
    private final int hashCode;
    private static final Comparator<Annotation> ANNOTATION_COMPARATOR = new AnnotationComparator();

    public BeanCacheKey(Type type, String path, Annotation ... qualifiers) {
        int length;
        this.type = type;
        this.path = path;
        int n = length = qualifiers != null ? qualifiers.length : 0;
        if (length == 0) {
            this.qualifier = null;
            this.qualifiers = null;
        } else if (length == 1) {
            this.qualifier = qualifiers[0];
            this.qualifiers = null;
        } else {
            this.qualifier = null;
            this.qualifiers = new Annotation[length];
            System.arraycopy(qualifiers, 0, this.qualifiers, 0, length);
            Arrays.sort(this.qualifiers, ANNOTATION_COMPARATOR);
        }
        this.hashCode = this.computeHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanCacheKey cacheKey = (BeanCacheKey)o;
        if (!this.type.equals(cacheKey.type)) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifierEquals(this.qualifier, cacheKey.qualifier) : cacheKey.qualifier != null) {
            return false;
        }
        if (!this.qualifierArrayEquals(this.qualifiers, cacheKey.qualifiers)) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(cacheKey.path) : cacheKey.path != null);
    }

    private boolean qualifierArrayEquals(Annotation[] qualifiers1, Annotation[] qualifiers2) {
        if (qualifiers1 == qualifiers2) {
            return true;
        }
        if (qualifiers1 == null || qualifiers2 == null) {
            return false;
        }
        if (qualifiers1.length != qualifiers2.length) {
            return false;
        }
        for (int i = 0; i < qualifiers1.length; ++i) {
            Annotation a1 = qualifiers1[i];
            Annotation a2 = qualifiers2[i];
            if (!(a1 == null ? a2 != null : !this.qualifierEquals(a1, a2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int getTypeHashCode(Type type) {
        int typeHash = type.hashCode();
        if (typeHash == 0 && type instanceof Class) {
            return ((Class)type).getName().hashCode();
        }
        return typeHash;
    }

    private int computeHashCode() {
        int computedHashCode = 31 * this.getTypeHashCode(this.type) + (this.path != null ? this.path.hashCode() : 0);
        if (this.qualifier != null) {
            computedHashCode = 31 * computedHashCode + this.getQualifierHashCode(this.qualifier);
        }
        if (this.qualifiers != null) {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                computedHashCode = 31 * computedHashCode + this.getQualifierHashCode(this.qualifiers[i]);
            }
        }
        return computedHashCode;
    }

    private int getQualifierHashCode(Annotation a) {
        Method[] members;
        Class annotationClass = BeanCacheKey.getAnnotationClass(a.getClass());
        if (annotationClass == null) {
            return this.getTypeHashCode(a.getClass());
        }
        int hashCode = this.getTypeHashCode(annotationClass);
        for (Method member : members = annotationClass.getDeclaredMethods()) {
            Class<?> type;
            if (member.isAnnotationPresent(Nonbinding.class)) continue;
            Object object = BeanCacheKey.callMethod(a, member);
            int value = object.getClass().isArray() ? ((type = object.getClass().getComponentType()).isPrimitive() ? (Long.TYPE == type ? Arrays.hashCode((long[])object) : (Integer.TYPE == type ? Arrays.hashCode((int[])object) : (Short.TYPE == type ? Arrays.hashCode((short[])object) : (Double.TYPE == type ? Arrays.hashCode((double[])object) : (Float.TYPE == type ? Arrays.hashCode((float[])object) : (Boolean.TYPE == type ? Arrays.hashCode((boolean[])object) : (Byte.TYPE == type ? Arrays.hashCode((byte[])object) : (Character.TYPE == type ? Arrays.hashCode((char[])object) : 0)))))))) : Arrays.hashCode((Object[])object)) : object.hashCode();
            hashCode = 29 * hashCode + value;
            hashCode = 29 * hashCode + member.getName().hashCode();
        }
        return hashCode;
    }

    private boolean qualifierEquals(Annotation qualifier1, Annotation qualifier2) {
        return ANNOTATION_COMPARATOR.compare(qualifier1, qualifier2) == 0;
    }

    private static Class getAnnotationClass(Class a) {
        for (Class<?> i : a.getInterfaces()) {
            if (!i.isAnnotation()) continue;
            return i;
        }
        return null;
    }

    private static Object callMethod(Object instance, Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, AnnotationUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in method call : " + method.getName(), e);
        }
    }

    public String toString() {
        return "BeanCacheKey{type=" + this.type + ", path='" + this.path + '\'' + ", qualifiers=" + (this.qualifiers == null ? this.qualifier : Arrays.asList(this.qualifiers)) + ", hashCode=" + this.hashCode + '}';
    }

    private static class AnnotationComparator
    implements Comparator<Annotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation annotation1, Annotation annotation2) {
            Class<? extends Annotation> type1 = annotation1.annotationType();
            Class<? extends Annotation> type2 = annotation2.annotationType();
            int temp = type1.getName().compareTo(type2.getName());
            if (temp != 0) {
                return temp;
            }
            Method[] member1 = type1.getDeclaredMethods();
            Method[] member2 = type2.getDeclaredMethods();
            int i = 0;
            int j = 0;
            int length1 = member1.length;
            int length2 = member2.length;
            while (true) {
                if (i < length1 && member1[i].isAnnotationPresent(Nonbinding.class)) {
                    ++i;
                    continue;
                }
                while (j < length2 && member2[j].isAnnotationPresent(Nonbinding.class)) {
                    ++j;
                }
                if (i >= length1 && j >= length2) {
                    return 0;
                }
                if (i >= length1) {
                    return 1;
                }
                if (j >= length2) {
                    return -1;
                }
                int c = member1[i].getName().compareTo(member2[j].getName());
                if (c != 0) {
                    return c;
                }
                Object value1 = BeanCacheKey.callMethod(annotation1, member1[i]);
                Object value2 = BeanCacheKey.callMethod(annotation2, member2[j]);
                assert (value1.getClass().equals(value2.getClass()));
                if (value1 instanceof Comparable) {
                    c = ((Comparable)value1).compareTo(value2);
                    if (c != 0) {
                        return c;
                    }
                } else if (value1.getClass().isArray()) {
                    c = value1.getClass().getComponentType().getName().compareTo(value2.getClass().getComponentType().getName());
                    if (c != 0) {
                        return c;
                    }
                    int length = Array.getLength(value1);
                    c = length - Array.getLength(value2);
                    if (c != 0) {
                        return c;
                    }
                    for (int k = 0; k < length; ++k) {
                        c = ((Comparable)Array.get(value1, k)).compareTo(Array.get(value2, k));
                        if (c == 0) continue;
                        return c;
                    }
                } else if (value1 instanceof Class) {
                    c = ((Class)value1).getName().compareTo(((Class)value2).getName());
                    if (c != 0) {
                        return c;
                    }
                } else assert (false);
                ++i;
                ++j;
            }
        }
    }
}

