/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient T delegate;
    private transient Stack<InjectionPoint> injectionPoints = null;
    private List<DependentCreationalContext<?>> dependentObjects = null;
    private Contextual<T> contextual = null;
    private WebBeansContext webBeansContext;
    private boolean destroying = false;

    CreationalContextImpl(Contextual<T> contextual, WebBeansContext webBeansContext) {
        this.contextual = contextual;
        this.webBeansContext = webBeansContext;
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public T getDelegate() {
        return this.delegate;
    }

    public T putDelegate(T delegate) {
        T oldValue = this.delegate;
        this.delegate = delegate;
        return oldValue;
    }

    public InjectionPoint getInjectionPoint() {
        if (this.injectionPoints == null || this.injectionPoints.isEmpty()) {
            return null;
        }
        return this.injectionPoints.peek();
    }

    public void putInjectionPoint(InjectionPoint injectionPoint) {
        if (this.injectionPoints == null) {
            this.injectionPoints = new Stack();
        }
        this.injectionPoints.push(injectionPoint);
    }

    public InjectionPoint removeInjectionPoint() {
        if (this.injectionPoints == null || this.injectionPoints.isEmpty()) {
            return null;
        }
        return this.injectionPoints.pop();
    }

    public void push(T incompleteInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> void addDependent(Contextual<K> dependent, Object instance) {
        Asserts.assertNotNull(dependent, "dependent parameter cannot be null");
        if (instance != null) {
            DependentCreationalContext<K> dependentCreational = new DependentCreationalContext<K>(dependent);
            dependentCreational.setInstance(instance);
            CreationalContextImpl creationalContextImpl = this;
            synchronized (creationalContextImpl) {
                if (this.dependentObjects == null) {
                    this.dependentObjects = new ArrayList();
                }
                if (dependent == this.contextual) {
                    this.dependentObjects.add(0, dependentCreational);
                } else {
                    this.dependentObjects.add(dependentCreational);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDependent(Contextual<?> contextual, Object instance) {
        if (this.dependentObjects == null) {
            return false;
        }
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            for (DependentCreationalContext<?> dependentCreationalContext : this.dependentObjects) {
                if (!dependentCreationalContext.getContextual().equals(contextual) || dependentCreationalContext.getInstance() != instance) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> void destroyDependent(X instance) {
        if (this.dependentObjects == null) {
            return;
        }
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            Iterator<DependentCreationalContext<?>> i = this.dependentObjects.iterator();
            while (i.hasNext()) {
                DependentCreationalContext<?> dependentContext = i.next();
                if (dependentContext.getInstance() != instance) continue;
                Contextual<?> dependentContextual = dependentContext.getContextual();
                CreationalContextImpl creationalContext = this;
                dependentContextual.destroy(instance, (CreationalContext)creationalContext);
                i.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDependents() {
        if (this.dependentObjects == null || this.destroying) {
            return;
        }
        this.destroying = true;
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            if (this.dependentObjects != null) {
                int maxRemoval;
                for (maxRemoval = this.dependentObjects.size() * 3; !this.dependentObjects.isEmpty() && maxRemoval > 0; --maxRemoval) {
                    DependentCreationalContext<?> dependent = this.dependentObjects.get(0);
                    this.dependentObjects.remove(0);
                    dependent.getContextual().destroy(dependent.getInstance(), (CreationalContext)this);
                }
                if (maxRemoval == 0) {
                    throw new WebBeansException("infinite loop detected while destroying bean " + this.contextual);
                }
            }
        }
        this.dependentObjects = null;
    }

    public void release() {
        this.removeAllDependents();
    }

    public Contextual<T> getBean() {
        return this.contextual;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.dependentObjects);
        String id = WebBeansUtil.getPassivationId(this.contextual);
        if (this.contextual != null && id != null) {
            s.writeObject(id);
        } else {
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        this.dependentObjects = (List)s.readObject();
        String id = (String)s.readObject();
        if (id != null) {
            this.contextual = this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreationalContext{name=");
        if (this.contextual instanceof Bean) {
            Bean bean = (Bean)this.contextual;
            sb.append(bean.getBeanClass().getSimpleName());
        } else {
            sb.append("unknown");
        }
        return sb.append("}").toString();
    }
}

