/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;

public class InjectableConstructor<T>
extends AbstractInjectable<T> {
    protected Constructor<T> con;

    public InjectableConstructor(Constructor<T> cons, InjectionTarget<T> owner, CreationalContextImpl<T> creationalContext) {
        super((Producer<?>)owner, creationalContext);
        this.con = cons;
    }

    public T doInjection() {
        T instance;
        List<InjectionPoint> injectedPoints = this.getInjectionPoints(this.con);
        ArrayList list = new ArrayList();
        block2: for (int i = 0; i < injectedPoints.size(); ++i) {
            for (InjectionPoint point : injectedPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                if (point.isDelegate()) {
                    list.add(this.creationalContext.getDelegate());
                    continue block2;
                }
                list.add(this.inject(point));
                continue block2;
            }
        }
        try {
            if (!this.con.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible(this.con, true);
            }
            instance = this.con.newInstance(list.toArray());
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
        return instance;
    }
}

