/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorInvocationContext;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.util.ExceptionUtil;

public class DefaultInterceptorHandler<T>
implements InterceptorHandler {
    private T target;
    private T delegate;
    private String beanPassivationId;
    private Map<Method, List<Interceptor<?>>> interceptors;
    private Map<Interceptor<?>, ?> instances;

    public DefaultInterceptorHandler(T target, T delegate, Map<Method, List<Interceptor<?>>> interceptors, Map<Interceptor<?>, ?> instances, String beanPassivationId) {
        this.target = target;
        this.delegate = delegate;
        this.instances = instances;
        this.interceptors = interceptors;
        this.beanPassivationId = beanPassivationId;
    }

    public T getTarget() {
        return this.target;
    }

    public T getDelegate() {
        return this.delegate;
    }

    public Map<Interceptor<?>, ?> getInstances() {
        return this.instances;
    }

    public Map<Method, List<Interceptor<?>>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Object invoke(Method method, Object[] parameters) {
        try {
            List<Object> methodInterceptors = this.interceptors.get(method);
            if (methodInterceptors == null) {
                methodInterceptors = Collections.emptyList();
            }
            InterceptorInvocationContext<T> ctx = new InterceptorInvocationContext<T>(this.delegate, InterceptionType.AROUND_INVOKE, methodInterceptors, this.instances, method, parameters);
            return ctx.proceed();
        }
        catch (Exception e) {
            return ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    Object readResolve() throws ObjectStreamException {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        Bean bean = beanManager.getPassivationCapableBean(this.beanPassivationId);
        return webBeansContext.getInterceptorDecoratorProxyFactory().getCachedProxyClass(bean);
    }
}

