/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.proxy.AbstractProxyFactory;
import org.apache.webbeans.proxy.OwbDecoratorProxy;
import org.apache.webbeans.proxy.ProxyGenerationException;
import org.apache.webbeans.util.ClassUtil;
import org.apache.xbean.asm.ClassWriter;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.asm.Type;

public class SubclassProxyFactory
extends AbstractProxyFactory {
    public SubclassProxyFactory(WebBeansContext webBeansContext) {
        super(webBeansContext);
    }

    @Override
    protected Class getMarkerInterface() {
        return OwbDecoratorProxy.class;
    }

    public <T> Class<T> createImplementedSubclass(ClassLoader classLoader, Class<T> classToProxy) {
        if (!Modifier.isAbstract(classToProxy.getModifiers())) {
            throw new WebBeansConfigurationException("Only abstract classes should get subclassed, not " + classToProxy);
        }
        Class<T> proxyClass = this.tryToLoadClass(classLoader, classToProxy);
        if (proxyClass != null) {
            return proxyClass;
        }
        proxyClass = this.createSubClass(classLoader, classToProxy);
        return proxyClass;
    }

    private <T> Class<T> tryToLoadClass(ClassLoader classLoader, Class<T> classToProxy) {
        String proxyClassName = this.getSubClassName(classToProxy);
        try {
            return Class.forName(proxyClassName, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private <T> String getSubClassName(Class<T> classToProxy) {
        return this.fixPreservedPackages(classToProxy.getName() + "$$OwbSubClass");
    }

    public synchronized <T> Class<T> createSubClass(ClassLoader classLoader, Class<T> classToProxy) throws ProxyGenerationException {
        Class<T> clazz = this.tryToLoadClass(classLoader, classToProxy);
        if (clazz != null) {
            return clazz;
        }
        String proxyClassName = this.getSubClassName(classToProxy);
        List<Method> methods = ClassUtil.getNonPrivateMethods(classToProxy, true);
        Method[] businessMethods = methods.toArray(new Method[methods.size()]);
        clazz = this.createProxyClass(classLoader, proxyClassName, classToProxy, businessMethods, new Method[0]);
        return clazz;
    }

    @Override
    protected void createConstructor(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName) throws ProxyGenerationException {
        try {
            Constructor<Object> superDefaultCt;
            String parentClassFileName;
            if (classToProxy.isInterface()) {
                parentClassFileName = Type.getInternalName(Object.class);
                superDefaultCt = Object.class.getConstructor(null);
            } else {
                parentClassFileName = classFileName;
                superDefaultCt = classToProxy.getConstructor(null);
            }
            String descriptor = Type.getConstructorDescriptor(superDefaultCt);
            MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, parentClassFileName, "<init>", descriptor);
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new ProxyGenerationException(e);
        }
    }

    @Override
    protected void createInstanceVariables(ClassWriter cw, Class<?> classToProxy, String classFileName) {
    }

    @Override
    protected void delegateInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] interceptedMethods) throws ProxyGenerationException {
    }

    @Override
    protected void createSerialisation(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName) {
    }

    @Override
    protected void delegateNonInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] noninterceptedMethods) throws ProxyGenerationException {
        for (Method delegatedMethod : noninterceptedMethods) {
            if (this.unproxyableMethod(delegatedMethod)) continue;
            String methodDescriptor = Type.getMethodDescriptor((Method)delegatedMethod);
            Class<?>[] exceptionTypes = delegatedMethod.getExceptionTypes();
            String[] exceptionTypeNames = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptionTypeNames[i] = Type.getType(exceptionTypes[i]).getInternalName();
            }
            int targetModifiers = delegatedMethod.getModifiers() & 5;
            MethodVisitor mv = cw.visitMethod(targetModifiers, delegatedMethod.getName(), methodDescriptor, null, exceptionTypeNames);
            mv.visitCode();
            boolean abstractMethod = Modifier.isAbstract(delegatedMethod.getModifiers());
            int offset = 1;
            for (Class<?> aClass : delegatedMethod.getParameterTypes()) {
                Type type = Type.getType(aClass);
                mv.visitVarInsn(type.getOpcode(21), offset);
                offset += type.getSize();
            }
            Type declaringClass = Type.getType(delegatedMethod.getDeclaringClass());
            if (!abstractMethod) {
                mv.visitMethodInsn(183, declaringClass.getInternalName(), delegatedMethod.getName(), methodDescriptor);
            }
            this.generateReturn(mv, delegatedMethod);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }
}

