/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.webbeans.config.BeanTypeSetResolver;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class ClassUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPERS_MAP = new HashMap();
    private static volatile Set<String> objectMethodNames;

    private ClassUtil() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> getClassFromName(String name) {
        try {
            ClassLoader loader = WebBeansUtil.getCurrentClassLoader();
            Class<?> clazz = Class.forName(name, true, loader);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            try {
                ClassLoader loader = ClassUtil.class.getClassLoader();
                Class<?> clazz = Class.forName(name, true, loader);
                return clazz;
            }
            catch (ClassNotFoundException e1) {
                try {
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    Class<?> clazz = Class.forName(name, true, loader);
                    return clazz;
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
            }
        }
    }

    public static boolean isInnerClazz(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isMemberClass();
    }

    public static Class<?> getPrimitiveWrapper(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return PRIMITIVE_TO_WRAPPERS_MAP.get(clazz);
    }

    public static Class<?> identityOrGetPrimitiveWrapper(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassUtil.getPrimitiveWrapper(clazz);
        }
        return clazz;
    }

    public static Class<?> getClass(Type type) {
        return ClassUtil.getClazz(type);
    }

    public static boolean isMethodHasCheckedException(Method method) {
        Asserts.nullCheckForMethod(method);
        Class<?>[] et = method.getExceptionTypes();
        if (et.length > 0) {
            for (Class<?> type : et) {
                if (Error.class.isAssignableFrom(type) || RuntimeException.class.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object callInstanceMethod(Method method, Object instance, Object[] args) {
        Asserts.nullCheckForMethod(method);
        Asserts.assertNotNull(instance, "instance parameter can not be null");
        try {
            if (args == null) {
                args = new Object[]{};
            }
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new WebBeansException("Exception occurs in the method call with method : " + method.getName() + " in class : " + instance.getClass().getName(), e);
        }
    }

    private static Set<String> getObjectMethodNames() {
        if (objectMethodNames == null) {
            Method[] methods;
            HashSet<String> list = new HashSet<String>();
            Class<Object> clazz = Object.class;
            for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
                list.add(method.getName());
            }
            objectMethodNames = list;
        }
        return objectMethodNames;
    }

    public static List<Method> getNonPrivateMethods(Class<?> clazz, boolean noFinalMethods) {
        HashMap methodMap = new HashMap();
        ArrayList<Method> allMethods = new ArrayList<Method>(10);
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || noFinalMethods && Modifier.isFinal(modifiers) || "finalize".equals(method.getName())) continue;
                ArrayList<Method> methods = (ArrayList<Method>)methodMap.get(method.getName());
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    methods.add(method);
                    allMethods.add(method);
                    methodMap.put(method.getName(), methods);
                    continue;
                }
                if (ClassUtil.isOverridden((List<Method>)methods, method)) continue;
                methods.add(method);
                allMethods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return allMethods;
    }

    public static boolean isOverridden(List<Method> subclassMethods, Method superclassMethod) {
        for (Method m : subclassMethods) {
            if (!ClassUtil.isOverridden(m, superclassMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectMethod(String methodName) {
        return ClassUtil.getObjectMethodNames().contains(methodName);
    }

    public static boolean isParametrizedType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof ParameterizedType;
    }

    public static boolean isWildCardType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof WildcardType;
    }

    public static boolean isUnboundedTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof TypeVariable) {
            TypeVariable wc = (TypeVariable)type;
            Type[] upper = wc.getBounds();
            if (upper.length > 1) {
                return false;
            }
            Type arg = upper[0];
            if (!(arg instanceof Class)) {
                return false;
            }
            Class clazz = (Class)arg;
            return clazz.equals(Object.class);
        }
        return false;
    }

    public static boolean isTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof TypeVariable;
    }

    public static boolean isConcrete(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Integer modifier = clazz.getModifiers();
        return !Modifier.isAbstract(modifier) && !Modifier.isInterface(modifier);
    }

    public static boolean isAssignable(Type beanType, Type requiredType) {
        Asserts.assertNotNull(beanType, "beanType parameter can not be null");
        Asserts.assertNotNull(requiredType, "requiredType parameter can not be null");
        if (beanType instanceof ParameterizedType && requiredType instanceof ParameterizedType) {
            return ClassUtil.isAssignableForParametrized((ParameterizedType)beanType, (ParameterizedType)requiredType);
        }
        if (beanType instanceof Class && requiredType instanceof Class) {
            Class<?> clzBeanType = (Class<?>)beanType;
            Class<?> clzReqType = (Class<?>)requiredType;
            if (clzBeanType.isPrimitive()) {
                clzBeanType = ClassUtil.getPrimitiveWrapper(clzBeanType);
            }
            if (clzReqType.isPrimitive()) {
                clzReqType = ClassUtil.getPrimitiveWrapper(clzReqType);
            }
            return clzReqType.equals(clzBeanType);
        }
        if (beanType instanceof ParameterizedType && requiredType instanceof Class) {
            Class<?> clazzReqType;
            boolean ok = true;
            ParameterizedType ptBean = (ParameterizedType)beanType;
            Class<?> clazzBeanType = ClassUtil.identityOrGetPrimitiveWrapper((Class)ptBean.getRawType());
            if (clazzBeanType.equals(clazzReqType = ClassUtil.identityOrGetPrimitiveWrapper((Class)requiredType))) {
                Type[] beanTypeArgs;
                for (Type actual : beanTypeArgs = ptBean.getActualTypeArguments()) {
                    if (ClassUtil.isUnboundedTypeVariable(actual)) continue;
                    if (actual instanceof Class) {
                        Class clazz = (Class)actual;
                        if (clazz.equals(Object.class)) continue;
                        ok = false;
                    } else {
                        ok = false;
                    }
                    break;
                }
            } else {
                ok = false;
            }
            return ok;
        }
        if (beanType instanceof Class && requiredType instanceof ParameterizedType) {
            Class clazzBeanType = (Class)beanType;
            ParameterizedType ptReq = (ParameterizedType)requiredType;
            Class clazzReqType = (Class)ptReq.getRawType();
            Type genericSuperClass = clazzBeanType.getGenericSuperclass();
            if (Provider.class.isAssignableFrom(clazzReqType) || Event.class.isAssignableFrom(clazzReqType)) {
                if (ClassUtil.isClassAssignable(clazzReqType, clazzBeanType)) {
                    return true;
                }
            } else if (genericSuperClass instanceof ParameterizedType) {
                Type[] requiredParams;
                Type[] params = ((ParameterizedType)genericSuperClass).getActualTypeArguments();
                if (params.length != (requiredParams = ((ParameterizedType)requiredType).getActualTypeArguments()).length) {
                    return false;
                }
                for (int i = 0; i < params.length; ++i) {
                    if (ClassUtil.isAssignable(params[i], requiredParams[i])) continue;
                    return false;
                }
                return ClassUtil.isClassAssignable(clazzReqType, clazzBeanType);
            }
            return false;
        }
        return false;
    }

    public static boolean checkEventTypeAssignability(Type eventType, Type observerType) {
        if (ClassUtil.isTypeVariable(observerType)) {
            Class clazzTvBound;
            Class<?> eventClass = ClassUtil.getClass(eventType);
            TypeVariable tvBeanTypeArg = (TypeVariable)observerType;
            Type tvBound = tvBeanTypeArg.getBounds()[0];
            if (tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(eventClass)) {
                return true;
            }
        } else {
            if (observerType instanceof ParameterizedType && eventType instanceof ParameterizedType) {
                return ClassUtil.isAssignableForParametrized((ParameterizedType)eventType, (ParameterizedType)observerType);
            }
            if (observerType instanceof Class && eventType instanceof ParameterizedType) {
                Class clazzBeanType = (Class)observerType;
                ParameterizedType ptEvent = (ParameterizedType)eventType;
                Class eventClazz = (Class)ptEvent.getRawType();
                return ClassUtil.isClassAssignable(clazzBeanType, eventClazz);
            }
            if (observerType instanceof Class && eventType instanceof Class) {
                return ClassUtil.isClassAssignable((Class)observerType, (Class)eventType);
            }
        }
        return false;
    }

    public static boolean isClassAssignable(Class<?> lhs, Class<?> rhs) {
        Asserts.assertNotNull(lhs, "lhs parameter can not be null");
        Asserts.assertNotNull(rhs, "rhs parameter can not be null");
        if (lhs.isPrimitive()) {
            lhs = ClassUtil.getPrimitiveWrapper(lhs);
        }
        if (rhs.isPrimitive()) {
            rhs = ClassUtil.getPrimitiveWrapper(rhs);
        }
        return lhs.isAssignableFrom(rhs);
    }

    public static boolean isAssignableForParametrized(ParameterizedType beanType, ParameterizedType requiredType) {
        Class beanRawType = (Class)beanType.getRawType();
        Class requiredRawType = (Class)requiredType.getRawType();
        if (ClassUtil.isClassAssignable(requiredRawType, beanRawType)) {
            Type[] requiredTypeArgs;
            Type[] beanTypeArgs = beanType.getActualTypeArguments();
            if (beanTypeArgs.length != (requiredTypeArgs = requiredType.getActualTypeArguments()).length) {
                return false;
            }
            return ClassUtil.isAssignableForParametrizedCheckArguments(beanTypeArgs, requiredTypeArgs);
        }
        return false;
    }

    private static boolean isAssignableForParametrizedCheckArguments(Type[] beanTypeArgs, Type[] requiredTypeArgs) {
        Type requiredTypeArg = null;
        Type beanTypeArg = null;
        int ok = 0;
        for (int i = 0; i < requiredTypeArgs.length; ++i) {
            requiredTypeArg = requiredTypeArgs[i];
            beanTypeArg = beanTypeArgs[i];
            if (ClassUtil.isParametrizedType(requiredTypeArg) && ClassUtil.isParametrizedType(beanTypeArg)) {
                if (!ClassUtil.checkBeanAndRequiredTypeIsParametrized(beanTypeArg, requiredTypeArg)) continue;
                ++ok;
                continue;
            }
            if (ClassUtil.isWildCardType(requiredTypeArg)) {
                if (!ClassUtil.checkRequiredTypeIsWildCard(beanTypeArg, requiredTypeArg)) continue;
                ++ok;
                continue;
            }
            if (requiredTypeArg instanceof Class && ClassUtil.isTypeVariable(beanTypeArg)) {
                if (!ClassUtil.checkRequiredTypeIsClassAndBeanTypeIsVariable(beanTypeArg, requiredTypeArg)) continue;
                ++ok;
                continue;
            }
            if (ClassUtil.isTypeVariable(requiredTypeArg) && ClassUtil.isTypeVariable(beanTypeArg)) {
                if (!ClassUtil.checkBeanTypeAndRequiredIsTypeVariable(beanTypeArg, requiredTypeArg)) continue;
                ++ok;
                continue;
            }
            if (beanTypeArg instanceof Class && requiredTypeArg instanceof Class) {
                if (!ClassUtil.isClassAssignable((Class)requiredTypeArg, (Class)beanTypeArg)) continue;
                ++ok;
                continue;
            }
            if (!(beanTypeArg instanceof Class) || !ClassUtil.isTypeVariable(requiredTypeArg) || !ClassUtil.checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(beanTypeArg, requiredTypeArg)) continue;
            ++ok;
        }
        return ok == requiredTypeArgs.length;
    }

    public static boolean checkBeanAndRequiredTypeIsParametrized(Type beanTypeArg, Type requiredTypeArg) {
        ParameterizedType ptRequiredTypeArg = (ParameterizedType)requiredTypeArg;
        ParameterizedType ptBeanTypeArg = (ParameterizedType)beanTypeArg;
        if (ptRequiredTypeArg.getRawType().equals(ptBeanTypeArg.getRawType())) {
            Type[] actualArgsRequiredType = ptRequiredTypeArg.getActualTypeArguments();
            Type[] actualArgsBeanType = ptRequiredTypeArg.getActualTypeArguments();
            if (actualArgsRequiredType.length > 0 && actualArgsBeanType.length == actualArgsRequiredType.length) {
                return ClassUtil.isAssignableForParametrizedCheckArguments(actualArgsBeanType, actualArgsRequiredType);
            }
            return true;
        }
        return false;
    }

    public static boolean checkRequiredTypeIsWildCard(Type beanTypeArg, Type requiredTypeArg) {
        TypeVariable tvBeanTypeArg;
        Type tvBound;
        WildcardType wctRequiredTypeArg = (WildcardType)requiredTypeArg;
        Type upperBoundRequiredTypeArg = wctRequiredTypeArg.getUpperBounds()[0];
        Type[] lowerBoundRequiredTypeArgs = wctRequiredTypeArg.getLowerBounds();
        if (beanTypeArg instanceof Class) {
            Class clazzBeanTypeArg = (Class)beanTypeArg;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzBeanTypeArg)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzBeanTypeArg.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        } else if (ClassUtil.isTypeVariable(beanTypeArg) && (tvBound = (tvBeanTypeArg = (TypeVariable)beanTypeArg).getBounds()[0]) instanceof Class) {
            Class clazzTvBound = (Class)tvBound;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && clazzTvBound != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzTvBound)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzTvBound.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkRequiredTypeIsClassAndBeanTypeIsVariable(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvBound;
        Class clazzRequiredType = (Class)requiredTypeArg;
        TypeVariable tvBeanTypeArg = (TypeVariable)beanTypeArg;
        Type tvBound = tvBeanTypeArg.getBounds()[0];
        return !(tvBound instanceof Class) || (clazzTvBound = (Class)tvBound) == Object.class || clazzTvBound.isAssignableFrom(clazzRequiredType);
    }

    public static boolean checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvBound;
        Class clazzBeanType = (Class)beanTypeArg;
        TypeVariable tvRequiredTypeArg = (TypeVariable)requiredTypeArg;
        Type tvBound = tvRequiredTypeArg.getBounds()[0];
        return tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(clazzBeanType);
    }

    public static boolean checkBeanTypeAndRequiredIsTypeVariable(Type beanTypeArg, Type requiredTypeArg) {
        Class clazzTvRequiredBound;
        Class clazzTvBeanBound;
        TypeVariable tvBeanTypeArg = (TypeVariable)beanTypeArg;
        Type tvBeanBound = tvBeanTypeArg.getBounds()[0];
        TypeVariable tvRequiredTypeArg = (TypeVariable)requiredTypeArg;
        Type tvRequiredBound = tvRequiredTypeArg.getBounds()[0];
        return tvBeanBound instanceof Class && tvRequiredBound instanceof Class && (clazzTvBeanBound = (Class)tvBeanBound).isAssignableFrom(clazzTvRequiredBound = (Class)tvRequiredBound);
    }

    public static boolean isDefinitionContainsTypeVariables(Type type) {
        Class<?> clazz = ClassUtil.getClass(type);
        Asserts.nullCheckForClass(clazz);
        return clazz.getTypeParameters().length > 0;
    }

    public static Type[] getActualTypeArguments(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static Set<Type> setTypeHierarchy(Set<Type> set, Type clazz) {
        BeanTypeSetResolver resolver = new BeanTypeSetResolver(clazz);
        resolver.startConfiguration();
        set.addAll(resolver.getHierarchy());
        return set;
    }

    public static Class<?> getClazz(Type type) {
        Class<?> raw = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            raw = (Class)pt.getRawType();
        } else if (type instanceof Class) {
            raw = (Class<?>)type;
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            raw = ClassUtil.getClazz(arrayType.getGenericComponentType());
        }
        return raw;
    }

    public static boolean checkParametrizedType(ParameterizedType pType) {
        Type[] types;
        Asserts.assertNotNull(pType, "pType argument can not be null");
        for (Type type : types = pType.getActualTypeArguments()) {
            if (type instanceof ParameterizedType) {
                return ClassUtil.checkParametrizedType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable) && !(type instanceof WildcardType)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getRawTypeForInjectionPoint(InjectionPoint injectionPoint) {
        Class rawType = null;
        Type type = injectionPoint.getType();
        if (type instanceof Class) {
            rawType = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            rawType = (Class)pt.getRawType();
        }
        return rawType;
    }

    public static boolean isOverridden(Method subClassMethod, Method superClassMethod) {
        if (ClassUtil.isSuperClass(superClassMethod.getDeclaringClass(), subClassMethod.getDeclaringClass()) && subClassMethod.getName().equals(superClassMethod.getName()) && Arrays.equals(subClassMethod.getParameterTypes(), superClassMethod.getParameterTypes())) {
            int modifiers = superClassMethod.getModifiers();
            if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) {
                return false;
            }
            if (!Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers)) {
                Class<?> superClass = superClassMethod.getDeclaringClass();
                Class<?> subClass = subClassMethod.getDeclaringClass();
                if (!subClass.getPackage().getName().equals(superClass.getPackage().getName())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isSuperClass(Class<?> superClass, Class<?> subClass) {
        return superClass.isAssignableFrom(subClass) && !superClass.equals(subClass);
    }

    static {
        PRIMITIVE_TO_WRAPPERS_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPERS_MAP.put(Void.TYPE, Void.class);
        objectMethodNames = null;
    }
}

