/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.util.ClassUtil;

public class InjectionExceptionUtil {
    private InjectionExceptionUtil() {
    }

    public static void throwUnproxyableResolutionException(ViolationMessageBuilder violationMessage) {
        throw new UnproxyableResolutionException(ViolationMessageBuilder.newViolation("WebBeans with api type with normal scope must be proxiable to inject.").addLine(violationMessage.toString()).toString());
    }

    public static void throwUnsatisfiedResolutionException(Type type, Method producerMethod, Annotation ... qualifiers) {
        ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation(InjectionExceptionUtil.createProducerMethodMessage(producerMethod));
        violationMessage.append(" in class: ", ClassUtil.getClass(type).getName());
        violationMessage.addLine(InjectionExceptionUtil.createQualifierMessage(qualifiers));
        throw new UnsatisfiedResolutionException(violationMessage.toString());
    }

    private static String createProducerMethodMessage(Method producerMethod) {
        return "Producer method component of the disposal method : " + producerMethod.getName() + "is not found";
    }

    public static void throwUnsatisfiedResolutionException(Class type, InjectionPoint injectionPoint, Annotation ... qualifiers) {
        ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation("Api type [", type.getName(), "] is not found with the qualifiers ");
        violationMessage.addLine(InjectionExceptionUtil.createQualifierMessage(qualifiers));
        if (injectionPoint != null) {
            violationMessage.addLine("for injection into ", injectionPoint.toString());
        }
        throw new UnsatisfiedResolutionException(violationMessage.toString());
    }

    public static void throwAmbiguousResolutionExceptionForBeanName(Set<Bean<?>> beans, String beanName) {
        InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeans(beans, ViolationMessageBuilder.newViolation("There are more than one WebBeans with name : ", beanName));
    }

    public static void throwAmbiguousResolutionException(Set<Bean<?>> beans) {
        InjectionExceptionUtil.throwAmbiguousResolutionException(beans, null, null, new Annotation[0]);
    }

    public static void throwAmbiguousResolutionException(Set<Bean<?>> beans, Class type, InjectionPoint injectionPoint, Annotation ... qualifiers) {
        ViolationMessageBuilder violationMessage;
        String qualifierMessage = InjectionExceptionUtil.createQualifierMessage(qualifiers);
        if (type != null) {
            violationMessage = ViolationMessageBuilder.newViolation("There is more than one api type with : ", ClassUtil.getClass(type).getName(), " with qualifiers : ", qualifierMessage);
            if (injectionPoint != null) {
                violationMessage.addLine("for injection into ", injectionPoint.toString());
            }
        } else {
            violationMessage = ViolationMessageBuilder.newViolation("Ambiguous resolution");
        }
        InjectionExceptionUtil.throwAmbiguousResolutionExceptionForBeans(beans, violationMessage);
    }

    private static void throwAmbiguousResolutionExceptionForBeans(Set<Bean<?>> beans, ViolationMessageBuilder violationMessage) {
        violationMessage.addLine("found beans: ");
        InjectionExceptionUtil.addBeanInfo(beans, violationMessage);
        throw new AmbiguousResolutionException(violationMessage.toString());
    }

    private static void addBeanInfo(Set<Bean<?>> beans, ViolationMessageBuilder violationMessage) {
        for (Bean<?> currentBean : beans) {
            violationMessage.addLine(currentBean.toString());
        }
    }

    private static String createQualifierMessage(Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            return null;
        }
        StringBuilder qualifierMessage = new StringBuilder("Qualifiers: [");
        int i = 0;
        for (Annotation annot : qualifiers) {
            qualifierMessage.append(annot);
            if (++i == qualifiers.length) continue;
            qualifierMessage.append(",");
        }
        qualifierMessage.append("]");
        return qualifierMessage.toString();
    }
}

