/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.instance.InstanceImpl;
import org.apache.webbeans.portable.AbstractProducer;

public class InstanceProducer<T>
extends AbstractProducer<Instance<T>> {
    private Class<Instance<T>> returnType;
    private Set<Annotation> qualifiers;
    private WebBeansContext webBeansContext;

    public InstanceProducer(Class<Instance<T>> returnType, Set<Annotation> qualifiers, WebBeansContext webBeansContext) {
        this.returnType = returnType;
        this.qualifiers = qualifiers;
        this.webBeansContext = webBeansContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance<T> produce(CreationalContext<Instance<T>> creationalContext) {
        try {
            InstanceImpl instance;
            Type type;
            Set qualifiers;
            InjectionPoint injectionPoint = null;
            CreationalContextImpl<Instance<T>> creationalContextImpl = null;
            if (creationalContext instanceof CreationalContextImpl) {
                creationalContextImpl = (CreationalContextImpl<Instance<T>>)creationalContext;
            } else {
                InstanceBean instanceBean = this.webBeansContext.getWebBeansUtil().getInstanceBean();
                creationalContextImpl = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, instanceBean);
            }
            injectionPoint = creationalContextImpl.getInjectionPoint();
            if (injectionPoint != null) {
                ParameterizedType injectedType = (ParameterizedType)injectionPoint.getType();
                qualifiers = injectionPoint.getQualifiers();
                type = injectedType.getActualTypeArguments()[0];
            } else {
                qualifiers = this.qualifiers;
                type = this.returnType;
            }
            InstanceImpl instanceImpl = instance = new InstanceImpl(type, injectionPoint, this.webBeansContext, creationalContextImpl, qualifiers.toArray(new Annotation[qualifiers.size()]));
            return instanceImpl;
        }
        finally {
            if (creationalContext instanceof CreationalContextImpl) {
                ((CreationalContextImpl)creationalContext).removeInjectionPoint();
            }
        }
    }
}

