/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.util.Nonbinding;
import javax.inject.Named;
import javax.inject.Scope;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.NamedLiteral;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class BeanAttributesBuilder<T, A extends Annotated> {
    protected A annotated;
    protected WebBeansContext webBeansContext;
    protected Set<Type> types = new HashSet<Type>();
    protected Set<Annotation> qualifiers = new HashSet<Annotation>();
    protected Class<? extends Annotation> scope;
    protected String name;
    protected boolean nullable;
    protected Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
    protected boolean alternative;

    public static BeanAttributesBuilderFactory forContext(WebBeansContext webBeansContext) {
        return new BeanAttributesBuilderFactory(webBeansContext);
    }

    protected BeanAttributesBuilder(WebBeansContext webBeansContext, A annotated) {
        this.annotated = annotated;
        this.webBeansContext = webBeansContext;
    }

    public BeanAttributesImpl<T> build() {
        this.defineTypes();
        this.defineStereotypes();
        this.defineScope();
        this.defineName();
        this.defineQualifiers();
        this.defineNullable();
        this.defineAlternative();
        return new BeanAttributesImpl(this.types, this.qualifiers, this.scope, this.name, this.nullable, this.stereotypes, this.alternative);
    }

    protected A getAnnotated() {
        return this.annotated;
    }

    protected void defineTypes() {
        Class<?> baseType = ClassUtil.getClass(this.annotated.getBaseType());
        if (baseType.isArray()) {
            this.types.add((Type)((Object)Object.class));
            this.types.add(baseType);
        } else {
            Set types = this.annotated.getTypeClosure();
            this.types.addAll(types);
            Set<String> ignored = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            Iterator<Type> i = this.types.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                if (!(t instanceof Class) || !ignored.contains(((Class)t).getName())) continue;
                i.remove();
            }
        }
    }

    protected void defineQualifiers() {
        HashSet<Class<? extends Annotation>> qualifiedTypes = new HashSet<Class<? extends Annotation>>();
        if (this.annotated.isAnnotationPresent(Specializes.class)) {
            this.defineQualifiers(this.getSuperAnnotated(), qualifiedTypes);
        }
        this.defineQualifiers((Annotated)this.annotated, (Set<Class<? extends Annotation>>)qualifiedTypes);
    }

    private void defineQualifiers(Annotated annotated, Set<Class<? extends Annotation>> qualifiedTypes) {
        Annotation annot;
        Annotation[] annotations = AnnotationUtil.asArray(annotated.getAnnotations());
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        for (Annotation annotation : annotations) {
            Method[] methods;
            Class<? extends Annotation> type = annotation.annotationType();
            if (!annotationManager.isQualifierAnnotation(type)) continue;
            for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(type)) {
                Class<?> clazz = method.getReturnType();
                if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
                throw new WebBeansConfigurationException("WebBeans definition class : " + method.getDeclaringClass().getName() + " @Qualifier : " + annotation.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
            }
            if (qualifiedTypes.contains(annotation.annotationType())) continue;
            qualifiedTypes.add(annotation.annotationType());
            if (annotation.annotationType().equals(Named.class) && this.name != null) {
                this.qualifiers.add((Annotation)((Object)new NamedLiteral(this.name)));
                continue;
            }
            this.qualifiers.add(annotation);
        }
        if (this.qualifiers.size() == 0) {
            this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        } else if (this.qualifiers.size() == 1 && (annot = this.qualifiers.iterator().next()).annotationType().equals(Named.class)) {
            this.qualifiers.add((Annotation)((Object)DefaultLiteral.INSTANCE));
        }
        if (!this.hasAnyQualifier()) {
            this.qualifiers.add((Annotation)((Object)AnyLiteral.INSTANCE));
        }
    }

    private boolean hasAnyQualifier() {
        return AnnotationUtil.getAnnotation(this.qualifiers, Any.class) != null;
    }

    protected abstract void defineScope();

    protected void defineScope(String errorMessage) {
        this.defineScope(null, errorMessage);
    }

    protected void defineScope(Class<?> declaringClass, String errorMessage) {
        Annotation[] annotations = AnnotationUtil.asArray(this.annotated.getAnnotations());
        boolean found = false;
        List<ExternalScope> additionalScopes = this.webBeansContext.getBeanManagerImpl().getAdditionalScopes();
        for (Annotation annotation : annotations) {
            if (declaringClass != null && AnnotationUtil.getDeclaringClass(annotation, declaringClass) != null && !AnnotationUtil.isDeclaringClass(declaringClass, annotation)) continue;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Object var = annotationType.getAnnotation(NormalScope.class);
            Object pseudo = annotationType.getAnnotation(Scope.class);
            if (var == null && pseudo == null) {
                for (ExternalScope additionalScope : additionalScopes) {
                    if (!annotationType.equals(additionalScope.getScope())) continue;
                    Annotation scopeAnnotation = additionalScope.getScopeAnnotation();
                    if (additionalScope.isNormal()) {
                        var = scopeAnnotation;
                        continue;
                    }
                    pseudo = scopeAnnotation;
                }
            }
            if (var != null) {
                if (pseudo != null) {
                    throw new WebBeansConfigurationException("Not to define both @Scope and @NormalScope on bean : " + ClassUtil.getClass(this.annotated.getBaseType()).getName());
                }
                if (found) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                found = true;
                this.scope = annotation.annotationType();
                continue;
            }
            if (pseudo == null) continue;
            if (found) {
                throw new WebBeansConfigurationException(errorMessage);
            }
            found = true;
            this.scope = annotation.annotationType();
        }
        if (!found && declaringClass != null && !this.hasDeclaredNonInheritedScope(declaringClass)) {
            this.defineScope(declaringClass.getSuperclass(), errorMessage);
        } else if (!found) {
            this.defineDefaultScope(errorMessage);
        }
    }

    private void defineDefaultScope(String exceptionMessage) {
        if (this.scope == null) {
            Set<Class<? extends Annotation>> stereos = this.stereotypes;
            if (stereos.size() == 0) {
                this.scope = Dependent.class;
            } else {
                Annotation defined = null;
                Set<Class<? extends Annotation>> anns = this.stereotypes;
                for (Class<? extends Annotation> stero : anns) {
                    boolean containsNormal = AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class);
                    if (!AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class) && !AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), Scope.class)) continue;
                    Annotation next = containsNormal ? AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), NormalScope.class)[0] : AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), Scope.class)[0];
                    if (defined == null) {
                        defined = next;
                        continue;
                    }
                    if (((Object)defined).equals(next)) continue;
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                this.scope = defined != null ? defined.annotationType() : Dependent.class;
            }
        }
    }

    private boolean hasDeclaredNonInheritedScope(Class<?> type) {
        return this.webBeansContext.getAnnotationManager().getDeclaredScopeAnnotation(type) != null;
    }

    protected abstract void defineName();

    protected void defineName(Annotated annotated, String name) {
        Annotation[] anns = AnnotationUtil.asArray(annotated.getAnnotations());
        Named nameAnnot = null;
        boolean isDefault = false;
        for (Annotation ann : anns) {
            if (!ann.annotationType().equals(Named.class)) continue;
            nameAnnot = (Named)ann;
            break;
        }
        if (nameAnnot == null) {
            if (this.webBeansContext.getAnnotationManager().hasNamedOnStereoTypes(this.stereotypes)) {
                isDefault = true;
            }
        } else if (nameAnnot.value().equals("")) {
            isDefault = true;
        } else {
            this.name = nameAnnot.value();
        }
        if (isDefault) {
            this.name = name;
        }
    }

    protected abstract Annotated getSuperAnnotated();

    protected abstract void defineNullable();

    protected void defineNullable(boolean nullable) {
        this.nullable = nullable;
    }

    protected void defineStereotypes() {
        Annotation[] anns = AnnotationUtil.asArray(this.annotated.getAnnotations());
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.hasStereoTypeMetaAnnotation(anns)) {
            Annotation[] steroAnns;
            for (Annotation stereo : steroAnns = annotationManager.getStereotypeMetaAnnotations(anns)) {
                this.stereotypes.add(stereo.annotationType());
            }
        }
    }

    protected void defineAlternative() {
        this.alternative = false;
    }

    private static abstract class AnnotatedMemberBeanAttributesBuilder<M, A extends AnnotatedMember<M>>
    extends BeanAttributesBuilder<M, A> {
        protected AnnotatedMemberBeanAttributesBuilder(WebBeansContext webBeansContext, A annotated) {
            super(webBeansContext, annotated);
        }

        protected AnnotatedType<? super M> getSuperType() {
            Class superclass = ((AnnotatedMember)this.getAnnotated()).getDeclaringType().getJavaClass().getSuperclass();
            if (superclass == null) {
                return null;
            }
            return this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(superclass);
        }
    }

    private static class AnnotatedMethodBeanAttributesBuilder<M>
    extends AnnotatedMemberBeanAttributesBuilder<M, AnnotatedMethod<M>> {
        protected AnnotatedMethodBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedMethod<M> annotated) {
            super(webBeansContext, annotated);
        }

        @Override
        protected void defineScope() {
            this.defineScope("Annotated producer method : " + ((AnnotatedMethod)this.getAnnotated()).getJavaMember() + "must declare default @Scope annotation");
        }

        @Override
        protected void defineName() {
            if (((AnnotatedMethod)this.getAnnotated()).isAnnotationPresent(Specializes.class)) {
                AnnotatedMethod<M> superAnnotated = this.getSuperAnnotated();
                this.defineName((Annotated)superAnnotated, WebBeansUtil.getProducerDefaultName(superAnnotated.getJavaMember().getName()));
            }
            if (this.name == null) {
                this.defineName((Annotated)this.getAnnotated(), WebBeansUtil.getProducerDefaultName(((AnnotatedMethod)this.getAnnotated()).getJavaMember().getName()));
            } else if (((AnnotatedMethod)this.getAnnotated()).isAnnotationPresent(Named.class)) {
                throw new DefinitionException("@Specialized Producer method : " + ((AnnotatedMethod)this.getAnnotated()).getJavaMember().getName() + " may not explicitly declare a bean name");
            }
        }

        @Override
        protected void defineNullable() {
            this.defineNullable(!((AnnotatedMethod)this.getAnnotated()).getJavaMember().getReturnType().isPrimitive());
        }

        protected AnnotatedMethod<? super M> getSuperAnnotated() {
            AnnotatedMethod thisMethod = (AnnotatedMethod)this.getAnnotated();
            for (AnnotatedMethod superMethod : this.getSuperType().getMethods()) {
                List thisParameters = thisMethod.getParameters();
                if (!thisMethod.getJavaMember().getName().equals(superMethod.getJavaMember().getName()) || !thisMethod.getBaseType().equals(superMethod.getBaseType()) || thisParameters.size() != superMethod.getParameters().size()) continue;
                List superParameters = superMethod.getParameters();
                boolean match = true;
                for (int i = 0; i < thisParameters.size(); ++i) {
                    if (((AnnotatedParameter)thisParameters.get(i)).getBaseType().equals(((AnnotatedParameter)superParameters.get(i)).getBaseType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return superMethod;
            }
            return null;
        }
    }

    private static class AnnotatedFieldBeanAttributesBuilder<M>
    extends AnnotatedMemberBeanAttributesBuilder<M, AnnotatedField<M>> {
        protected AnnotatedFieldBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedField<M> annotated) {
            super(webBeansContext, annotated);
        }

        @Override
        protected void defineScope() {
            this.defineScope("Annotated producer field: " + ((AnnotatedField)this.getAnnotated()).getJavaMember() + "must declare default @Scope annotation");
        }

        @Override
        protected void defineName() {
            this.defineName((Annotated)this.getAnnotated(), WebBeansUtil.getProducerDefaultName(((AnnotatedField)this.getAnnotated()).getJavaMember().getName()));
        }

        @Override
        protected void defineNullable() {
            this.defineNullable(!((AnnotatedField)this.getAnnotated()).getJavaMember().getType().isPrimitive());
        }

        protected AnnotatedField<? super M> getSuperAnnotated() {
            AnnotatedField thisField = (AnnotatedField)this.getAnnotated();
            for (AnnotatedField superField : this.getSuperType().getFields()) {
                if (!thisField.getJavaMember().getName().equals(superField.getJavaMember().getName()) || !thisField.getBaseType().equals(superField.getBaseType())) continue;
                return superField;
            }
            return null;
        }
    }

    private static class AnnotatedTypeBeanAttributesBuilder<C>
    extends BeanAttributesBuilder<C, AnnotatedType<C>> {
        public AnnotatedTypeBeanAttributesBuilder(WebBeansContext webBeansContext, AnnotatedType<C> annotated) {
            super(webBeansContext, annotated);
        }

        @Override
        protected void defineScope() {
            this.defineScope(((AnnotatedType)this.getAnnotated()).getJavaClass(), WebBeansLoggerFacade.getTokenString("TEXT_MB_IMPL") + ((AnnotatedType)this.getAnnotated()).getJavaClass().getName() + WebBeansLoggerFacade.getTokenString("TEXT_SAME_SCOPE"));
        }

        @Override
        protected void defineName() {
            if (((AnnotatedType)this.getAnnotated()).isAnnotationPresent(Specializes.class)) {
                Class classToSpecialize = ((AnnotatedType)this.getAnnotated()).getJavaClass().getSuperclass();
                while (classToSpecialize.isAnnotationPresent(Specializes.class)) {
                    classToSpecialize = classToSpecialize.getSuperclass();
                }
                AnnotatedType annotatedToSpecialize = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(classToSpecialize);
                this.defineName((Annotated)annotatedToSpecialize, WebBeansUtil.getManagedBeanDefaultName(classToSpecialize.getSimpleName()));
            }
            if (this.name == null) {
                this.defineName((Annotated)this.getAnnotated(), WebBeansUtil.getManagedBeanDefaultName(((AnnotatedType)this.getAnnotated()).getJavaClass().getSimpleName()));
            } else if (((AnnotatedType)this.getAnnotated()).getJavaClass().isAnnotationPresent(Named.class)) {
                throw new DefinitionException("@Specialized Class : " + ((AnnotatedType)this.getAnnotated()).getJavaClass().getName() + " may not explicitly declare a bean name");
            }
        }

        @Override
        protected void defineNullable() {
            this.defineNullable(false);
        }

        protected AnnotatedType<? super C> getSuperAnnotated() {
            Class superclass = ((AnnotatedType)this.getAnnotated()).getJavaClass().getSuperclass();
            if (superclass == null) {
                return null;
            }
            return this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(superclass);
        }
    }

    public static class BeanAttributesBuilderFactory {
        private WebBeansContext webBeansContext;

        private BeanAttributesBuilderFactory(WebBeansContext webBeansContext) {
            Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
            this.webBeansContext = webBeansContext;
        }

        public <T> BeanAttributesBuilder<T, AnnotatedType<T>> newBeanAttibutes(AnnotatedType<T> annotatedType) {
            return new AnnotatedTypeBeanAttributesBuilder<T>(this.webBeansContext, annotatedType);
        }

        public <T> BeanAttributesBuilder<T, AnnotatedField<T>> newBeanAttibutes(AnnotatedField<T> annotatedField) {
            return new AnnotatedFieldBeanAttributesBuilder<T>(this.webBeansContext, annotatedField);
        }

        public <T> BeanAttributesBuilder<T, AnnotatedMethod<T>> newBeanAttibutes(AnnotatedMethod<T> annotatedMethod) {
            return new AnnotatedMethodBeanAttributesBuilder<T>(this.webBeansContext, annotatedMethod);
        }
    }
}

