/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class EventUtil {
    private EventUtil() {
    }

    public static void checkEventType(Class<?> eventType) {
        Asserts.assertNotNull(eventType, "eventType parameter can not be null");
        if (ClassUtil.isDefinitionContainsTypeVariables(eventType)) {
            throw new IllegalArgumentException("Event type : " + eventType.getName() + " can not be generic");
        }
    }

    public static void checkQualifierImplementations(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            Retention retention = qualifier.annotationType().getAnnotation(Retention.class);
            RetentionPolicy policy = retention.value();
            if (policy.equals((Object)RetentionPolicy.RUNTIME)) continue;
            throw new IllegalArgumentException("Event qualifier RetentionPolicy must be RUNTIME for qualifier : " + qualifier.annotationType().getName());
        }
    }

    public static void checkEventBindings(WebBeansContext webBeansContext, Set<Annotation> annotations) {
        webBeansContext.getAnnotationManager().checkQualifierConditions(annotations);
    }

    public static TransactionPhase getObserverMethodTransactionType(AnnotatedMethod<?> observerMethod) {
        Observes observes = AnnotationUtil.getAnnotatedMethodFirstParameterAnnotation(observerMethod, Observes.class);
        if (observes != null) {
            return observes.during();
        }
        return null;
    }

    public static boolean checkObservableInjectionPointConditions(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Type type = injectionPoint.getType();
        Class candidateClazz = null;
        if (type instanceof Class) {
            candidateClazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            candidateClazz = (Class)pt.getRawType();
        }
        if (!candidateClazz.equals(Event.class)) {
            return false;
        }
        if (!ClassUtil.isParametrizedType(injectionPoint.getType())) {
            throw new WebBeansConfigurationException("@Observable field injection " + injectionPoint + " must be ParametrizedType with actual type argument");
        }
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            pt = (ParameterizedType)injectionPoint.getType();
            Class rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.equals(Event.class)) {
                return false;
            }
            if (typeArgs.length != 1) {
                throw new IllegalArgumentException("@Observable field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new IllegalArgumentException("@Observable field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }
}

