/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.SelfInterceptorBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.SelfInterceptorBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.intercept.InterceptorComparator;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public class InterceptorResolutionService {
    private final WebBeansContext webBeansContext;
    private static volatile Boolean enforceCheckedException;

    public InterceptorResolutionService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <T> BeanInterceptorInfo calculateInterceptorInfo(Set<Type> beanTypes, Set<Annotation> qualifiers, AnnotatedType<T> annotatedType) {
        boolean interceptedBean;
        List<Interceptor<?>> classLevelInterceptors;
        Asserts.assertNotNull(beanTypes, "beanTypes");
        Asserts.assertNotNull(qualifiers, "qualifiers");
        Asserts.assertNotNull(annotatedType, "AnnotatedType");
        List<AnnotatedMethod> interceptableAnnotatedMethods = this.getInterceptableBusinessMethods(annotatedType);
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        ArrayList classLevelEjbInterceptors = new ArrayList();
        this.collectEjbInterceptors(classLevelEjbInterceptors, (Annotated)annotatedType, false, beanTypes);
        List<Object> decorators = beanManager.unsafeResolveDecorators(beanTypes, AnnotationUtil.asArray(qualifiers));
        if (decorators.size() == 0) {
            decorators = Collections.emptyList();
        }
        HashSet allUsedCdiInterceptors = new HashSet();
        Set<Annotation> classInterceptorBindings = annotationManager.getInterceptorAnnotations(annotatedType.getAnnotations());
        if (classInterceptorBindings.size() > 0) {
            classLevelInterceptors = this.webBeansContext.getBeanManagerImpl().resolveInterceptors(InterceptionType.AROUND_INVOKE, AnnotationUtil.asArray(classInterceptorBindings));
            allUsedCdiInterceptors.addAll(classLevelInterceptors);
        } else {
            classLevelInterceptors = Collections.EMPTY_LIST;
        }
        HashSet allUsedConstructorCdiInterceptors = new HashSet();
        this.addCdiClassLifecycleInterceptors(annotatedType, classInterceptorBindings, allUsedCdiInterceptors, allUsedConstructorCdiInterceptors);
        LinkedHashSet allUsedEjbInterceptors = new LinkedHashSet();
        allUsedEjbInterceptors.addAll(classLevelEjbInterceptors);
        HashMap<Method, BusinessMethodInterceptorInfo> businessMethodInterceptorInfos = new HashMap<Method, BusinessMethodInterceptorInfo>();
        HashMap constructorInterceptorInfos = new HashMap();
        ArrayList<Method> nonInterceptedMethods = new ArrayList<Method>();
        SelfInterceptorBean<T> selfInterceptorBean = this.resolveSelfInterceptorBean(annotatedType);
        for (AnnotatedMethod annotatedMethod : interceptableAnnotatedMethods) {
            BusinessMethodInterceptorInfo methodInterceptorInfo = new BusinessMethodInterceptorInfo();
            this.calculateEjbMethodInterceptors(methodInterceptorInfo, allUsedEjbInterceptors, classLevelEjbInterceptors, (AnnotatedCallable)annotatedMethod);
            this.calculateCdiMethodInterceptors(methodInterceptorInfo, InterceptionType.AROUND_INVOKE, allUsedCdiInterceptors, (AnnotatedCallable)annotatedMethod, classInterceptorBindings, classLevelInterceptors);
            this.calculateCdiMethodDecorators(methodInterceptorInfo, decorators, annotatedMethod);
            if (methodInterceptorInfo.isEmpty() && (selfInterceptorBean == null || !selfInterceptorBean.isAroundInvoke())) {
                nonInterceptedMethods.add(annotatedMethod.getJavaMember());
                continue;
            }
            businessMethodInterceptorInfos.put(annotatedMethod.getJavaMember(), methodInterceptorInfo);
        }
        for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
            BusinessMethodInterceptorInfo constructorInterceptorInfo = new BusinessMethodInterceptorInfo();
            this.calculateEjbMethodInterceptors(constructorInterceptorInfo, allUsedEjbInterceptors, classLevelEjbInterceptors, (AnnotatedCallable)annotatedConstructor);
            if (constructorInterceptorInfo.isEmpty() && (selfInterceptorBean == null || !selfInterceptorBean.isAroundInvoke())) continue;
            constructorInterceptorInfos.put(annotatedConstructor.getJavaMember(), constructorInterceptorInfo);
        }
        HashMap<InterceptionType, LifecycleMethodInfo> lifecycleMethodInterceptorInfos = new HashMap<InterceptionType, LifecycleMethodInfo>();
        this.addLifecycleMethods(lifecycleMethodInterceptorInfos, annotatedType, InterceptionType.POST_CONSTRUCT, PostConstruct.class, allUsedCdiInterceptors, allUsedEjbInterceptors, classLevelEjbInterceptors, classInterceptorBindings);
        this.addLifecycleMethods(lifecycleMethodInterceptorInfos, annotatedType, InterceptionType.PRE_DESTROY, PreDestroy.class, allUsedCdiInterceptors, allUsedEjbInterceptors, classLevelEjbInterceptors, classInterceptorBindings);
        ArrayList cdiInterceptors = new ArrayList(allUsedCdiInterceptors);
        Collections.sort(cdiInterceptors, new InterceptorComparator(this.webBeansContext));
        ArrayList cdiConstructorInterceptors = new ArrayList(allUsedConstructorCdiInterceptors);
        Collections.sort(cdiConstructorInterceptors, new InterceptorComparator(this.webBeansContext));
        boolean bl = interceptedBean = allUsedEjbInterceptors.size() > 0 || allUsedCdiInterceptors.size() > 0 || lifecycleMethodInterceptorInfos.size() > 0;
        if ((interceptedBean || decorators.size() > 0) && Modifier.isFinal(annotatedType.getJavaClass().getModifiers())) {
            throw new WebBeansDeploymentException("Cannot apply Decorators or Interceptors on a final class: " + annotatedType.getJavaClass().getName());
        }
        if (interceptedBean) {
            boolean proxyable = false;
            for (AnnotatedConstructor constructor : annotatedType.getConstructors()) {
                if ((!constructor.getParameters().isEmpty() || this.isUnproxyable((AnnotatedCallable)constructor)) && !constructor.isAnnotationPresent(Inject.class)) continue;
                proxyable = true;
                break;
            }
            if (!proxyable) {
                throw new WebBeansDeploymentException("Intercepted Bean " + annotatedType.getBaseType() + " must be proxyable");
            }
        }
        return new BeanInterceptorInfo(decorators, allUsedEjbInterceptors, cdiInterceptors, cdiConstructorInterceptors, selfInterceptorBean, constructorInterceptorInfos, businessMethodInterceptorInfos, nonInterceptedMethods, lifecycleMethodInterceptorInfos);
    }

    private boolean isNoCheckedExceptionEnforced() {
        if (enforceCheckedException == null) {
            enforceCheckedException = Boolean.parseBoolean(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.forceNoCheckedExceptions", "true"));
        }
        return enforceCheckedException;
    }

    private <T> void addCdiClassLifecycleInterceptors(AnnotatedType<T> annotatedType, Set<Annotation> classInterceptorBindings, Set<Interceptor<?>> allUsedCdiInterceptors, Set<Interceptor<?>> allUsedConstructorCdiInterceptors) {
        BeanManagerImpl beanManagerImpl = this.webBeansContext.getBeanManagerImpl();
        Annotation[] interceptorBindings = null;
        if (classInterceptorBindings.size() > 0) {
            interceptorBindings = AnnotationUtil.asArray(classInterceptorBindings);
            allUsedCdiInterceptors.addAll(beanManagerImpl.resolveInterceptors(InterceptionType.POST_CONSTRUCT, interceptorBindings));
            allUsedCdiInterceptors.addAll(beanManagerImpl.resolveInterceptors(InterceptionType.PRE_DESTROY, interceptorBindings));
        }
        AnnotatedConstructor constructorToUse = null;
        if (!annotatedType.getConstructors().isEmpty()) {
            for (AnnotatedConstructor c : annotatedType.getConstructors()) {
                if (constructorToUse == null && c.getParameters().isEmpty()) {
                    constructorToUse = c;
                    continue;
                }
                if (c.getAnnotation(Inject.class) == null) continue;
                constructorToUse = c;
                break;
            }
        }
        if (constructorToUse != null) {
            Set<Annotation> constructorAnnot = this.webBeansContext.getAnnotationManager().getInterceptorAnnotations(constructorToUse.getAnnotations());
            for (Annotation classA : classInterceptorBindings) {
                boolean overriden = false;
                for (Annotation consA : constructorAnnot) {
                    if (classA.annotationType() != consA.annotationType()) continue;
                    overriden = true;
                    break;
                }
                if (overriden) continue;
                constructorAnnot.add(classA);
            }
            if (!constructorAnnot.isEmpty()) {
                allUsedConstructorCdiInterceptors.addAll(beanManagerImpl.resolveInterceptors(InterceptionType.AROUND_CONSTRUCT, AnnotationUtil.asArray(constructorAnnot)));
            }
        } else if (interceptorBindings != null) {
            allUsedConstructorCdiInterceptors.addAll(beanManagerImpl.resolveInterceptors(InterceptionType.AROUND_CONSTRUCT, interceptorBindings));
        }
        allUsedCdiInterceptors.addAll(allUsedConstructorCdiInterceptors);
    }

    private <T> SelfInterceptorBean<T> resolveSelfInterceptorBean(AnnotatedType<T> annotatedType) {
        BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
        SelfInterceptorBeanBuilder<T> sibb = new SelfInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, beanAttributes);
        sibb.defineSelfInterceptorRules();
        if (!sibb.isInterceptorEnabled()) {
            return null;
        }
        return (SelfInterceptorBean)sibb.getBean();
    }

    private void addLifecycleMethods(Map<InterceptionType, LifecycleMethodInfo> lifecycleMethodInterceptorInfos, AnnotatedType<?> annotatedType, InterceptionType interceptionType, Class<? extends Annotation> lifeycleAnnotation, Set<Interceptor<?>> allUsedCdiInterceptors, Set<Interceptor<?>> allUsedEjbInterceptors, List<Interceptor<?>> classLevelEjbInterceptors, Set<Annotation> classInterceptorBindings) {
        ArrayList foundMethods = new ArrayList();
        BusinessMethodInterceptorInfo methodInterceptorInfo = new BusinessMethodInterceptorInfo();
        List<AnnotatedMethod<?>> lifecycleMethodCandidates = this.webBeansContext.getInterceptorUtil().getLifecycleMethods(annotatedType, lifeycleAnnotation);
        for (AnnotatedMethod<?> annotatedMethod : lifecycleMethodCandidates) {
            this.verifyLifecycleMethod(lifeycleAnnotation, annotatedMethod);
            if (annotatedMethod.getParameters().size() != 0) continue;
            foundMethods.add(annotatedMethod);
            this.calculateEjbMethodInterceptors(methodInterceptorInfo, allUsedEjbInterceptors, classLevelEjbInterceptors, (AnnotatedCallable)annotatedMethod);
            this.calculateCdiMethodInterceptors(methodInterceptorInfo, interceptionType, allUsedCdiInterceptors, (AnnotatedCallable)annotatedMethod, classInterceptorBindings, null);
        }
        for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
            this.calculateEjbMethodInterceptors(methodInterceptorInfo, allUsedEjbInterceptors, classLevelEjbInterceptors, (AnnotatedCallable)annotatedConstructor);
            this.calculateCdiMethodInterceptors(methodInterceptorInfo, interceptionType, allUsedCdiInterceptors, (AnnotatedCallable)annotatedConstructor, classInterceptorBindings, null);
        }
        if (foundMethods.size() > 0) {
            lifecycleMethodInterceptorInfos.put(interceptionType, new LifecycleMethodInfo(foundMethods, methodInterceptorInfo));
        }
    }

    private void collectEjbInterceptors(List<Interceptor<?>> ejbInterceptors, Annotated annotated, boolean unproxyable, Set<Type> types) {
        Interceptors interceptorsAnnot = (Interceptors)annotated.getAnnotation(Interceptors.class);
        if (interceptorsAnnot != null) {
            if (unproxyable) {
                throw new WebBeansConfigurationException(annotated + " is not proxyable, but an Interceptor got defined on it!");
            }
            if (types == null) {
                types = Collections.emptySet();
            }
            for (Class interceptorClass : interceptorsAnnot.value()) {
                if (types.contains(interceptorClass)) continue;
                Interceptor ejbInterceptor = this.webBeansContext.getInterceptorsManager().getEjbInterceptorForClass(interceptorClass);
                ejbInterceptors.add(ejbInterceptor);
            }
        }
    }

    private void calculateEjbMethodInterceptors(BusinessMethodInterceptorInfo methodInterceptorInfo, Set<Interceptor<?>> allUsedEjbInterceptors, List<Interceptor<?>> classLevelEjbInterceptors, AnnotatedCallable annotatedMethod) {
        ExcludeClassInterceptors excludeClassInterceptors;
        boolean unproxyable = this.isUnproxyable(annotatedMethod);
        ArrayList methodInterceptors = new ArrayList();
        if (classLevelEjbInterceptors != null && classLevelEjbInterceptors.size() > 0 && !unproxyable && (excludeClassInterceptors = (ExcludeClassInterceptors)annotatedMethod.getAnnotation(ExcludeClassInterceptors.class)) == null) {
            methodInterceptors.addAll(classLevelEjbInterceptors);
        }
        this.collectEjbInterceptors(methodInterceptors, (Annotated)annotatedMethod, unproxyable, Collections.singleton(annotatedMethod.getJavaMember().getDeclaringClass()));
        allUsedEjbInterceptors.addAll(methodInterceptors);
        if (methodInterceptors.size() > 0) {
            methodInterceptorInfo.setEjbInterceptors(methodInterceptors);
        }
    }

    private boolean isUnproxyable(AnnotatedCallable annotatedMethod) {
        int modifiers = annotatedMethod.getJavaMember().getModifiers();
        return Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers);
    }

    private void calculateCdiMethodDecorators(BusinessMethodInterceptorInfo methodInterceptorInfo, List<Decorator<?>> decorators, AnnotatedMethod annotatedMethod) {
        if (decorators == null || decorators.isEmpty()) {
            return;
        }
        LinkedHashMap appliedDecorators = new LinkedHashMap();
        for (Decorator<?> decorator : decorators) {
            Method decoratingMethod;
            if (!this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(decorator.getBeanClass()) || (decoratingMethod = this.getDecoratingMethod(decorator, annotatedMethod)) == null) continue;
            if (this.isUnproxyable((AnnotatedCallable)annotatedMethod)) {
                throw new WebBeansDeploymentException(annotatedMethod + " is not proxyable, but an Decorator got defined on it!");
            }
            appliedDecorators.put(decorator, decoratingMethod);
        }
        if (appliedDecorators.size() > 0) {
            methodInterceptorInfo.setMethodDecorators(appliedDecorators);
        }
    }

    private Method getDecoratingMethod(Decorator decorator, AnnotatedMethod annotatedMethod) {
        Set decoratedTypes = decorator.getDecoratedTypes();
        for (Type decoratedType : decoratedTypes) {
            Method[] decoratorMethods;
            if (decoratedType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
                decoratedType = parameterizedType.getRawType();
            }
            if (!(decoratedType instanceof Class)) continue;
            Class decoratedClass = (Class)decoratedType;
            for (Method decoratorMethod : decoratorMethods = decoratedClass.getDeclaredMethods()) {
                int modifiers = decoratorMethod.getModifiers();
                if (Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || !this.methodEquals(decoratorMethod, annotatedMethod.getJavaMember())) continue;
                if (Modifier.isAbstract(decorator.getBeanClass().getModifiers())) {
                    for (Class decoratorClass = decorator.getBeanClass(); decoratorClass != Object.class; decoratorClass = decoratorClass.getSuperclass()) {
                        try {
                            Method m = decoratorClass.getDeclaredMethod(decoratorMethod.getName(), decoratorMethod.getParameterTypes());
                            if (Modifier.isAbstract(m.getModifiers())) {
                                return null;
                            }
                            return decoratorMethod;
                        }
                        catch (NoSuchMethodException e) {
                            continue;
                        }
                    }
                    return null;
                }
                return decoratorMethod;
            }
        }
        return null;
    }

    private boolean methodEquals(Method method1, Method method2) {
        Class<?>[] method2Params;
        Class<?>[] method1Params;
        if (method1.getName().equals(method2.getName()) && (method1Params = method1.getParameterTypes()).length == (method2Params = method2.getParameterTypes()).length) {
            boolean paramsMatch = true;
            for (int i = 0; i < method1Params.length; ++i) {
                if (method1Params[i].isAssignableFrom(method2Params[i])) continue;
                paramsMatch = false;
                break;
            }
            if (paramsMatch) {
                return true;
            }
        }
        return false;
    }

    private void calculateCdiMethodInterceptors(BusinessMethodInterceptorInfo methodInterceptorInfo, InterceptionType interceptionType, Set<Interceptor<?>> allUsedCdiInterceptors, AnnotatedCallable annotatedMethod, Set<Annotation> classInterceptorBindings, List<Interceptor<?>> classLevelInterceptors) {
        List<Interceptor<?>> methodInterceptors;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        boolean unproxyable = this.isUnproxyable(annotatedMethod);
        boolean hasMethodInterceptors = false;
        HashMap<Class<? extends Annotation>, Annotation> cummulatedInterceptorBindings = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation interceptorBinding : annotationManager.getInterceptorAnnotations(annotatedMethod.getAnnotations())) {
            cummulatedInterceptorBindings.put(interceptorBinding.annotationType(), interceptorBinding);
            hasMethodInterceptors = true;
        }
        if (unproxyable && hasMethodInterceptors) {
            throw new WebBeansConfigurationException(annotatedMethod + " is not proxyable, but an Interceptor got defined on it!");
        }
        if (unproxyable) {
            return;
        }
        for (Annotation interceptorBinding : classInterceptorBindings) {
            if (cummulatedInterceptorBindings.containsKey(interceptorBinding.annotationType())) continue;
            cummulatedInterceptorBindings.put(interceptorBinding.annotationType(), interceptorBinding);
        }
        if (cummulatedInterceptorBindings.size() == 0) {
            return;
        }
        if (hasMethodInterceptors || classLevelInterceptors == null) {
            methodInterceptors = this.webBeansContext.getBeanManagerImpl().resolveInterceptors(interceptionType, AnnotationUtil.asArray(cummulatedInterceptorBindings.values()));
            allUsedCdiInterceptors.addAll(methodInterceptors);
        } else {
            methodInterceptors = classLevelInterceptors;
        }
        methodInterceptorInfo.setCdiInterceptors(methodInterceptors);
    }

    private <T> void verifyLifecycleMethod(Class<? extends Annotation> lifecycleAnnotation, AnnotatedMethod<T> annotatedMethod) {
        List params = annotatedMethod.getParameters();
        Method method = annotatedMethod.getJavaMember();
        if (!(params.size() <= 0 || params.size() <= 1 && ((AnnotatedParameter)params.get(0)).getBaseType().equals(InvocationContext.class))) {
            throw new WebBeansConfigurationException(lifecycleAnnotation.getName() + " LifecycleMethod " + method + " must either have no parameter or InvocationContext but has:" + Arrays.toString(method.getParameterTypes()));
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new WebBeansConfigurationException("@" + lifecycleAnnotation.getName() + " annotated method : " + method.getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass().getName() + " must return void type");
        }
        if (this.isNoCheckedExceptionEnforced() && ClassUtil.isMethodHasCheckedException(method)) {
            throw new WebBeansConfigurationException("@" + lifecycleAnnotation.getName() + " annotated method : " + method.getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass().getName() + " can not throw any checked exception");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new WebBeansConfigurationException("@" + lifecycleAnnotation.getName() + " annotated method : " + method.getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass().getName() + " can not be static");
        }
    }

    private List<AnnotatedMethod> getInterceptableBusinessMethods(AnnotatedType annotatedType) {
        Class javaClass = annotatedType.getJavaClass();
        List<Method> interceptableMethods = ClassUtil.getNonPrivateMethods(javaClass, false);
        ArrayList<AnnotatedMethod> interceptableAnnotatedMethods = new ArrayList<AnnotatedMethod>();
        AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
        Set annotatedMethods = annotatedElementFactory.getFilteredAnnotatedMethods(annotatedType);
        if (!javaClass.isAnnotation() && javaClass.isInterface()) {
            HashSet types = new HashSet(annotatedType.getTypeClosure());
            types.remove(javaClass);
            types.remove(Object.class);
            if (!types.isEmpty()) {
                annotatedMethods = new HashSet(annotatedMethods);
                for (Type c : types) {
                    if (!Class.class.isInstance(c)) continue;
                    Class parent = (Class)Class.class.cast(c);
                    AnnotatedType at = annotatedElementFactory.getAnnotatedType(parent);
                    if (at == null) {
                        at = annotatedElementFactory.newAnnotatedType(parent);
                    }
                    if (at == null) continue;
                    annotatedMethods.addAll(annotatedElementFactory.getFilteredAnnotatedMethods(at));
                }
            }
        }
        for (Method interceptableMethod : interceptableMethods) {
            for (AnnotatedMethod annotatedMethod : annotatedMethods) {
                int modifiers;
                if (!annotatedMethod.getJavaMember().equals(interceptableMethod) || Modifier.isPrivate(modifiers = annotatedMethod.getJavaMember().getModifiers()) || Modifier.isStatic(modifiers)) continue;
                interceptableAnnotatedMethods.add(annotatedMethod);
            }
        }
        return interceptableAnnotatedMethods;
    }

    public static class LifecycleMethodInfo {
        private List<AnnotatedMethod<?>> methods = new ArrayList();
        private BusinessMethodInterceptorInfo methodInterceptorInfo;

        public LifecycleMethodInfo(List<AnnotatedMethod<?>> methods, BusinessMethodInterceptorInfo methodInterceptorInfo) {
            this.methods = methods;
            this.methodInterceptorInfo = methodInterceptorInfo;
        }

        public List<AnnotatedMethod<?>> getMethods() {
            return this.methods;
        }

        public BusinessMethodInterceptorInfo getMethodInterceptorInfo() {
            return this.methodInterceptorInfo;
        }
    }

    public static class BusinessMethodInterceptorInfo {
        private Interceptor<?>[] ejbInterceptors = null;
        private Interceptor<?>[] cdiInterceptors = null;
        private LinkedHashMap<Decorator<?>, Method> methodDecorators = null;

        public Interceptor<?>[] getEjbInterceptors() {
            return this.ejbInterceptors;
        }

        public Interceptor<?>[] getCdiInterceptors() {
            return this.cdiInterceptors;
        }

        public LinkedHashMap<Decorator<?>, Method> getMethodDecorators() {
            return this.methodDecorators;
        }

        public void setCdiInterceptors(List<Interceptor<?>> cdiInterceptors) {
            this.cdiInterceptors = cdiInterceptors == null || cdiInterceptors.isEmpty() ? null : cdiInterceptors.toArray(new Interceptor[cdiInterceptors.size()]);
        }

        public void setMethodDecorators(LinkedHashMap<Decorator<?>, Method> methodDecorators) {
            this.methodDecorators = methodDecorators == null || methodDecorators.isEmpty() ? null : methodDecorators;
        }

        public void setEjbInterceptors(List<Interceptor<?>> ejbInterceptors) {
            this.ejbInterceptors = ejbInterceptors == null || ejbInterceptors.isEmpty() ? null : ejbInterceptors.toArray(new Interceptor[ejbInterceptors.size()]);
        }

        public boolean isEmpty() {
            return this.cdiInterceptors == null && this.ejbInterceptors == null && this.methodDecorators == null;
        }
    }

    public static class BeanInterceptorInfo {
        private LinkedHashSet<Interceptor<?>> ejbInterceptors;
        private List<Interceptor<?>> cdiInterceptors;
        private final List<Interceptor<?>> constructorCdiInterceptors;
        private SelfInterceptorBean<?> selfInterceptorBean;
        private List<Decorator<?>> decorators = null;
        private Map<Method, BusinessMethodInterceptorInfo> businessMethodsInfo;
        private Map<Constructor<?>, BusinessMethodInterceptorInfo> constructorInterceptorInfos;
        private List<Method> nonInterceptedMethods;
        private Map<InterceptionType, LifecycleMethodInfo> lifecycleMethodInterceptorInfos;

        public BeanInterceptorInfo(List<Decorator<?>> decorators, LinkedHashSet<Interceptor<?>> ejbInterceptors, List<Interceptor<?>> cdiInterceptors, List<Interceptor<?>> constructorCdiInterceptors, SelfInterceptorBean<?> selfInterceptorBean, Map<Constructor<?>, BusinessMethodInterceptorInfo> constructorInterceptorInfos, Map<Method, BusinessMethodInterceptorInfo> businessMethodsInfo, List<Method> nonInterceptedMethods, Map<InterceptionType, LifecycleMethodInfo> lifecycleMethodInterceptorInfos) {
            this.decorators = decorators;
            this.ejbInterceptors = ejbInterceptors;
            this.cdiInterceptors = cdiInterceptors;
            this.constructorCdiInterceptors = constructorCdiInterceptors;
            this.selfInterceptorBean = selfInterceptorBean;
            this.businessMethodsInfo = businessMethodsInfo;
            this.constructorInterceptorInfos = constructorInterceptorInfos;
            this.nonInterceptedMethods = nonInterceptedMethods;
            this.lifecycleMethodInterceptorInfos = lifecycleMethodInterceptorInfos;
        }

        public List<Decorator<?>> getDecorators() {
            return this.decorators;
        }

        public LinkedHashSet<Interceptor<?>> getEjbInterceptors() {
            return this.ejbInterceptors;
        }

        public List<Interceptor<?>> getCdiInterceptors() {
            return this.cdiInterceptors;
        }

        public List<Interceptor<?>> getConstructorCdiInterceptors() {
            return this.constructorCdiInterceptors;
        }

        public SelfInterceptorBean<?> getSelfInterceptorBean() {
            return this.selfInterceptorBean;
        }

        public Map<Method, BusinessMethodInterceptorInfo> getBusinessMethodsInfo() {
            return this.businessMethodsInfo;
        }

        public Map<Constructor<?>, BusinessMethodInterceptorInfo> getConstructorInterceptorInfos() {
            return this.constructorInterceptorInfos;
        }

        public List<Method> getNonInterceptedMethods() {
            return this.nonInterceptedMethods;
        }

        public Map<InterceptionType, LifecycleMethodInfo> getLifecycleMethodInterceptorInfos() {
            return this.lifecycleMethodInterceptorInfos;
        }
    }
}

