/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.PriorityClasses;

public class AlternativesManager {
    private final WebBeansContext webBeansContext;
    private final Set<Class<?>> configuredAlternatives = new HashSet();
    private final Set<Class<? extends Annotation>> configuredStereotypeAlternatives = new HashSet<Class<? extends Annotation>>();
    private final PriorityClasses priorityAlternatives = new PriorityClasses();

    public AlternativesManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void addXmlStereoTypeAlternative(Class<?> alternative) {
        if (Annotation.class.isAssignableFrom(alternative)) {
            Class<?> stereo = alternative;
            boolean ok = false;
            if (this.webBeansContext.getAnnotationManager().isStereoTypeAnnotation(stereo) && AnnotationUtil.hasClassAnnotation(stereo, Alternative.class)) {
                ok = true;
                this.configuredStereotypeAlternatives.add(stereo);
            }
            if (!ok) {
                throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not an annotation");
            }
        } else {
            throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not an annotation");
        }
    }

    public void addXmlClazzAlternative(Class<?> alternative) {
        this.configuredAlternatives.add(alternative);
    }

    public void addPriorityClazzAlternative(Class<?> clazz, Priority priority) {
        this.priorityAlternatives.add(clazz, priority);
    }

    public List<Class<?>> getPrioritizedAlternatives() {
        return this.priorityAlternatives.getSorted();
    }

    public boolean isAlternative(Bean<?> bean) {
        return this.isAlternative(bean.getBeanClass(), bean.getStereotypes());
    }

    public boolean isAlternative(Class<?> beanType, Set<Class<? extends Annotation>> stereotypes) {
        if (this.configuredAlternatives.contains(beanType) || this.priorityAlternatives.contains(beanType)) {
            return true;
        }
        for (Class<? extends Annotation> ann : stereotypes) {
            if (!this.configuredStereotypeAlternatives.contains(ann)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getXmlConfiguredAlternatives() {
        return this.configuredAlternatives;
    }

    public void clear() {
        this.configuredAlternatives.clear();
        this.configuredStereotypeAlternatives.clear();
        this.priorityAlternatives.clear();
    }
}

