/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.DefinitionException;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.AbstractProducerBeanBuilder;
import org.apache.webbeans.component.creation.MethodProducerFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

public class ProducerMethodBeanBuilder<T>
extends AbstractProducerBeanBuilder<T, AnnotatedMethod<?>, ProducerMethodBean<T>> {
    public ProducerMethodBeanBuilder(InjectionTargetBean<T> parent, AnnotatedMethod<?> annotatedMethod, BeanAttributes<T> beanAttributes) {
        super(parent, annotatedMethod, beanAttributes);
    }

    public void configureProducerSpecialization(ProducerMethodBean<T> bean, AnnotatedMethod<T> annotatedMethod) {
        List annotatedParameters = annotatedMethod.getParameters();
        ArrayList parameters = new ArrayList();
        for (AnnotatedParameter annotatedParam : annotatedParameters) {
            parameters.add(ClassUtil.getClass(annotatedParam.getBaseType()));
        }
        Method superMethod = bean.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredMethod(annotatedMethod.getDeclaringType().getJavaClass().getSuperclass(), annotatedMethod.getJavaMember().getName(), parameters.toArray(new Class[parameters.size()]));
        if (superMethod == null) {
            throw new WebBeansConfigurationException("Annotated producer method specialization failed : " + annotatedMethod.getJavaMember().getName() + " not found in super class : " + annotatedMethod.getDeclaringType().getJavaClass().getSuperclass().getName() + " for annotated method : " + annotatedMethod);
        }
        if (!AnnotationUtil.hasAnnotation(superMethod.getAnnotations(), Produces.class)) {
            throw new WebBeansConfigurationException("Annotated producer method specialization failed : " + annotatedMethod.getJavaMember().getName() + " found in super class : " + annotatedMethod.getDeclaringType().getJavaClass().getSuperclass().getName() + " is not annotated with @Produces" + " for annotated method : " + annotatedMethod);
        }
        bean.setSpecializedBean(true);
    }

    @Override
    protected <P> ProducerMethodBean<T> createBean(InjectionTargetBean<P> parent, Class<T> beanClass) {
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)this.annotatedMember;
        ProducerMethodBean<T> producerMethodBean = new ProducerMethodBean<T>(parent, this.beanAttributes, beanClass, new MethodProducerFactory<P>(annotatedMethod, parent, parent.getWebBeansContext()));
        return producerMethodBean;
    }

    public ProducerMethodBean<T> getBean() {
        return (ProducerMethodBean)this.createBean(((AnnotatedMethod)this.annotatedMember).getJavaMember().getReturnType());
    }

    @Override
    public void validate() throws DefinitionException {
        super.validate();
        for (AnnotatedParameter parameter : ((AnnotatedMethod)this.annotatedMember).getParameters()) {
            Type type = parameter.getBaseType();
            if (!Bean.class.equals(ClassUtil.getClass(type)) || ((AnnotatedMethod)this.annotatedMember).getBaseType().equals(ClassUtil.getActualTypeArguments(type)[0])) continue;
            throw new WebBeansConfigurationException("Type parameter of the injected bean must be the same as the return type. Producer method: " + this.annotatedMember);
        }
    }
}

