/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.xbean.asm5.ClassWriter;
import org.apache.xbean.asm5.MethodVisitor;
import org.apache.xbean.asm5.Type;

public abstract class AbstractProxyFactory {
    public static final int MAX_CLASSLOAD_TRIES = 10000;
    public static final int MODIFIER_VARARGS = 128;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(AbstractProxyFactory.class);
    protected WebBeansContext webBeansContext;
    private Object unsafe;
    private Method unsafeAllocateInstance;
    private Method unsafeDefineClass;
    private final int javaVersion;
    public static final String FIELD_BEAN_PASSIVATION_ID = "owbBeanPassivationId";

    protected AbstractProxyFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.javaVersion = this.determineJavaVersion();
        this.initializeUnsafe();
    }

    private int determineJavaVersion() {
        String javaVersionProp = this.webBeansContext.getOpenWebBeansConfiguration().getGeneratorJavaVersion();
        if (javaVersionProp != null) {
            if (javaVersionProp.startsWith("1.7")) {
                return 51;
            }
            if (javaVersionProp.startsWith("1.8")) {
                return 52;
            }
            if (javaVersionProp.startsWith("1.9")) {
                return 52;
            }
        }
        return 50;
    }

    protected ClassLoader getProxyClassLoader(Class<?> beanClass) {
        return this.webBeansContext.getApplicationBoundaryService().getBoundaryClassLoader(beanClass);
    }

    protected abstract Class getMarkerInterface();

    protected abstract void createInstanceVariables(ClassWriter var1, Class<?> var2, String var3);

    protected abstract void createSerialisation(ClassWriter var1, String var2, Class<?> var3, String var4);

    protected abstract void createConstructor(ClassWriter var1, String var2, Class<?> var3, String var4, Constructor<?> var5) throws ProxyGenerationException;

    protected abstract void delegateInterceptedMethods(ClassLoader var1, ClassWriter var2, String var3, Class<?> var4, Method[] var5) throws ProxyGenerationException;

    protected abstract void delegateNonInterceptedMethods(ClassLoader var1, ClassWriter var2, String var3, Class<?> var4, Method[] var5) throws ProxyGenerationException;

    protected String getUnusedProxyClassName(ClassLoader classLoader, String proxyClassName) {
        String finalName = proxyClassName = this.fixPreservedPackages(proxyClassName);
        for (int i = 0; i < 10000; ++i) {
            try {
                finalName = proxyClassName + i;
                Class.forName(finalName, true, classLoader);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                return finalName;
            }
        }
        throw new WebBeansException("Unable to detect a free proxy class name based on: " + proxyClassName);
    }

    protected <T> String getSignedClassProxyName(Class<T> classToProxy) {
        return "org.apache.webbeans.custom.signed." + classToProxy.getName();
    }

    protected String fixPreservedPackages(String proxyClassName) {
        proxyClassName = this.fixPreservedPackage(proxyClassName, "java.");
        proxyClassName = this.fixPreservedPackage(proxyClassName, "javax.");
        proxyClassName = this.fixPreservedPackage(proxyClassName, "sun.misc.");
        return proxyClassName;
    }

    private String fixPreservedPackage(String className, String forbiddenPackagePrefix) {
        String fixedClassName = className;
        if (className.startsWith(forbiddenPackagePrefix)) {
            fixedClassName = "org.apache.webbeans.custom." + className.substring(forbiddenPackagePrefix.length());
        }
        return fixedClassName;
    }

    protected <T> Class<T> createProxyClass(ClassLoader classLoader, String proxyClassName, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods) throws ProxyGenerationException {
        return this.createProxyClass(classLoader, proxyClassName, classToProxy, interceptedMethods, nonInterceptedMethods, null);
    }

    protected <T> Class<T> createProxyClass(ClassLoader classLoader, String proxyClassName, Class<T> classToProxy, Method[] interceptedMethods, Method[] nonInterceptedMethods, Constructor<T> constructor) throws ProxyGenerationException {
        String proxyClassFileName = proxyClassName.replace('.', '/');
        byte[] proxyBytes = this.generateProxy(classLoader, classToProxy, proxyClassName, proxyClassFileName, this.sortOutDuplicateMethods(interceptedMethods), this.sortOutDuplicateMethods(nonInterceptedMethods), constructor);
        return this.defineAndLoadClass(classLoader, proxyClassName, proxyBytes);
    }

    private Method[] sortOutDuplicateMethods(Method[] methods) {
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<Method> duplicates = new ArrayList<Method>();
        for (Method outer : methods) {
            for (Method inner : methods) {
                if (inner == outer || !this.hasSameSignature(outer, inner) || duplicates.contains(outer) || duplicates.contains(inner)) continue;
                duplicates.add(inner);
            }
        }
        ArrayList<Method> outsorted = new ArrayList<Method>(Arrays.asList(methods));
        outsorted.removeAll(duplicates);
        return outsorted.toArray(new Method[outsorted.size()]);
    }

    private boolean hasSameSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }

    private byte[] generateProxy(ClassLoader classLoader, Class<?> classToProxy, String proxyClassName, String proxyClassFileName, Method[] interceptedMethods, Method[] nonInterceptedMethods, Constructor<?> constructor) throws ProxyGenerationException {
        ClassWriter cw = new ClassWriter(2);
        String classFileName = classToProxy.getName().replace('.', '/');
        String[] interfaceNames = new String[]{Type.getInternalName((Class)this.getMarkerInterface())};
        String superClassName = classFileName;
        if (classToProxy.isInterface()) {
            interfaceNames = new String[]{Type.getInternalName(classToProxy), interfaceNames[0]};
            superClassName = Type.getInternalName(Object.class);
        }
        cw.visit(this.javaVersion, 4129, proxyClassFileName, null, superClassName, interfaceNames);
        cw.visitSource(classFileName + ".java", null);
        this.createInstanceVariables(cw, classToProxy, classFileName);
        this.createSerialisation(cw, proxyClassFileName, classToProxy, classFileName);
        cw.visitField(10, FIELD_BEAN_PASSIVATION_ID, Type.getDescriptor(String.class), null, null).visitEnd();
        this.createConstructor(cw, proxyClassFileName, classToProxy, classFileName, constructor);
        if (nonInterceptedMethods != null) {
            this.delegateNonInterceptedMethods(classLoader, cw, proxyClassFileName, classToProxy, nonInterceptedMethods);
        }
        if (interceptedMethods != null) {
            this.delegateInterceptedMethods(classLoader, cw, proxyClassFileName, classToProxy, interceptedMethods);
        }
        return cw.toByteArray();
    }

    private <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes) throws ProxyGenerationException {
        Class<?> clazz = classLoader.getClass();
        AccessibleObject defineClassMethod = null;
        do {
            try {
                defineClassMethod = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (defineClassMethod == null && clazz != Object.class);
        if (defineClassMethod != null && !defineClassMethod.isAccessible()) {
            try {
                ((Method)defineClassMethod).setAccessible(true);
            }
            catch (RuntimeException re) {
                defineClassMethod = null;
            }
        }
        try {
            Class definedClass = defineClassMethod != null ? (Class)((Method)defineClassMethod).invoke(classLoader, proxyName, proxyBytes, 0, proxyBytes.length) : (Class)this.unsafeDefineClass.invoke(this.unsafe, proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null);
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (InvocationTargetException le) {
            if (LinkageError.class.isInstance(le.getCause())) {
                try {
                    return Class.forName(proxyName.replace('/', '.'), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ProxyGenerationException(le.getCause());
        }
        catch (Throwable e) {
            throw new ProxyGenerationException(e);
        }
    }

    protected boolean unproxyableMethod(Method delegatedMethod) {
        int modifiers = delegatedMethod.getModifiers();
        return (modifiers & 0x11A) > 0 || "finalize".equals(delegatedMethod.getName()) || delegatedMethod.isBridge();
    }

    protected String getWrapperType(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return Integer.class.getCanonicalName().replace('.', '/');
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class.getCanonicalName().replace('.', '/');
        }
        if (Character.TYPE.equals(type)) {
            return Character.class.getCanonicalName().replace('.', '/');
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class.getCanonicalName().replace('.', '/');
        }
        if (Short.TYPE.equals(type)) {
            return Short.class.getCanonicalName().replace('.', '/');
        }
        if (Float.TYPE.equals(type)) {
            return Float.class.getCanonicalName().replace('.', '/');
        }
        if (Long.TYPE.equals(type)) {
            return Long.class.getCanonicalName().replace('.', '/');
        }
        if (Double.TYPE.equals(type)) {
            return Double.class.getCanonicalName().replace('.', '/');
        }
        if (Void.TYPE.equals(type)) {
            return Void.class.getCanonicalName().replace('.', '/');
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected int getVarInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Integer.TYPE.equals(type)) {
                return 21;
            }
            if (Boolean.TYPE.equals(type)) {
                return 21;
            }
            if (Character.TYPE.equals(type)) {
                return 21;
            }
            if (Byte.TYPE.equals(type)) {
                return 21;
            }
            if (Short.TYPE.equals(type)) {
                return 21;
            }
            if (Float.TYPE.equals(type)) {
                return 23;
            }
            if (Long.TYPE.equals(type)) {
                return 22;
            }
            if (Double.TYPE.equals(type)) {
                return 24;
            }
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected void pushIntOntoStack(MethodVisitor mv, int i) {
        if (i == 0) {
            mv.visitInsn(3);
        } else if (i == 1) {
            mv.visitInsn(4);
        } else if (i == 2) {
            mv.visitInsn(5);
        } else if (i == 3) {
            mv.visitInsn(6);
        } else if (i == 4) {
            mv.visitInsn(7);
        } else if (i == 5) {
            mv.visitInsn(8);
        } else if (i > 5 && i <= 255) {
            mv.visitIntInsn(16, i);
        } else {
            mv.visitIntInsn(17, i);
        }
    }

    protected int getReturnInsn(Class<?> type) {
        if (type.isPrimitive()) {
            if (Void.TYPE.equals(type)) {
                return 177;
            }
            if (Integer.TYPE.equals(type)) {
                return 172;
            }
            if (Boolean.TYPE.equals(type)) {
                return 172;
            }
            if (Character.TYPE.equals(type)) {
                return 172;
            }
            if (Byte.TYPE.equals(type)) {
                return 172;
            }
            if (Short.TYPE.equals(type)) {
                return 172;
            }
            if (Float.TYPE.equals(type)) {
                return 174;
            }
            if (Long.TYPE.equals(type)) {
                return 173;
            }
            if (Double.TYPE.equals(type)) {
                return 175;
            }
        }
        return 176;
    }

    protected String getCastType(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return this.getWrapperType(returnType);
        }
        return Type.getInternalName(returnType);
    }

    protected String getPrimitiveMethod(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "intValue";
        }
        if (Boolean.TYPE.equals(type)) {
            return "booleanValue";
        }
        if (Character.TYPE.equals(type)) {
            return "charValue";
        }
        if (Byte.TYPE.equals(type)) {
            return "byteValue";
        }
        if (Short.TYPE.equals(type)) {
            return "shortValue";
        }
        if (Float.TYPE.equals(type)) {
            return "floatValue";
        }
        if (Long.TYPE.equals(type)) {
            return "longValue";
        }
        if (Double.TYPE.equals(type)) {
            return "doubleValue";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    protected void generateReturn(MethodVisitor mv, Method delegatedMethod) {
        Class<?> returnType = delegatedMethod.getReturnType();
        mv.visitInsn(this.getReturnInsn(returnType));
    }

    protected <T> T unsafeNewInstance(Class<T> clazz) {
        try {
            if (this.unsafeAllocateInstance != null) {
                return (T)this.unsafeAllocateInstance.invoke(this.unsafe, clazz);
            }
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException() != null ? e.getTargetException() : e;
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), throwable);
        }
    }

    private void initializeUnsafe() {
        Object unsafe;
        Class unsafeClass;
        try {
            unsafeClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return Thread.currentThread().getContextClassLoader().loadClass("sun.misc.Unsafe");
                    }
                    catch (Exception e) {
                        try {
                            return ClassLoader.getSystemClassLoader().loadClass("sun.misc.Unsafe");
                        }
                        catch (ClassNotFoundException e1) {
                            throw new IllegalStateException("Cannot get sun.misc.Unsafe", e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get sun.misc.Unsafe class", e);
        }
        this.unsafe = unsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field field = unsafeClass.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return field.get(null);
                }
                catch (Exception e) {
                    logger.warning("ATTENTION: Cannot get sun.misc.Unsafe - will use newInstance() instead! Intended for GAE only!");
                    return null;
                }
            }
        });
        if (unsafe != null) {
            this.unsafeAllocateInstance = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method mtd = unsafeClass.getDeclaredMethod("allocateInstance", Class.class);
                        mtd.setAccessible(true);
                        return mtd;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot get sun.misc.Unsafe.allocateInstance", e);
                    }
                }
            });
            this.unsafeDefineClass = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot get Unsafe.defineClass", e);
                    }
                }
            });
        }
    }

    protected void pushMethodParameterArray(MethodVisitor mv, Class<?>[] parameterTypes) {
        this.createArrayDefinition(mv, parameterTypes.length, Object.class);
        int index = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.visitInsn(89);
            Class<?> parameterType = parameterTypes[i];
            this.pushIntOntoStack(mv, i);
            if (parameterType.isPrimitive()) {
                String wrapperType = this.getWrapperType(parameterType);
                mv.visitVarInsn(this.getVarInsn(parameterType), index);
                mv.visitMethodInsn(184, wrapperType, "valueOf", "(" + Type.getDescriptor(parameterType) + ")L" + wrapperType + ";", false);
                mv.visitInsn(83);
                if (Long.TYPE.equals(parameterType) || Double.TYPE.equals(parameterType)) {
                    index += 2;
                    continue;
                }
                ++index;
                continue;
            }
            mv.visitVarInsn(25, index);
            mv.visitInsn(83);
            ++index;
        }
    }

    protected void createArrayDefinition(MethodVisitor mv, int size, Class<?> type) throws ProxyGenerationException {
        if (size < 0) {
            throw new ProxyGenerationException("Array size cannot be less than zero");
        }
        this.pushIntOntoStack(mv, size);
        mv.visitTypeInsn(189, type.getCanonicalName().replace('.', '/'));
    }
}

