/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.glassfish.grizzly.http.server.Request;

@Provider
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Set<String> UNPROTECTED_PATHS = new HashSet<String>(Arrays.asList("", "help", "auth/info", "auth/verify"));
    @Inject
    javax.inject.Provider<Request> _requestProvider;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Context
    ResourceInfo _resourceInfo;
    @Context
    HttpHeaders _httpHeaders;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method endpointMethod = this._resourceInfo.getResourceMethod();
        AccessControl accessControl = this._accessControlFactory.create();
        String endpointUrl = ((Request)this._requestProvider.get()).getRequestURL().toString();
        UriInfo uriInfo = requestContext.getUriInfo();
        if (AuthenticationFilter.isBaseFile(uriInfo.getPath()) || UNPROTECTED_PATHS.contains(uriInfo.getPath())) {
            return;
        }
        if (accessControl.protectAnnotatedOnly() && !endpointMethod.isAnnotationPresent(Authenticate.class)) {
            return;
        }
        Optional<String> tableName = this.extractTableName((MultivaluedMap<String, String>)uriInfo.getPathParameters(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        AccessType accessType = AccessType.READ;
        if (endpointMethod.isAnnotationPresent(Authenticate.class)) {
            accessType = endpointMethod.getAnnotation(Authenticate.class).value();
        } else if (accessControl.protectAnnotatedOnly()) {
            if (endpointMethod.getAnnotation(POST.class) != null) {
                accessType = AccessType.CREATE;
            } else if (endpointMethod.getAnnotation(PUT.class) != null) {
                accessType = AccessType.UPDATE;
            } else if (endpointMethod.getAnnotation(DELETE.class) != null) {
                accessType = AccessType.DELETE;
            }
        }
        new AccessControlUtils().validatePermission(tableName, accessType, this._httpHeaders, endpointUrl, accessControl);
    }

    @VisibleForTesting
    Optional<String> extractTableName(MultivaluedMap<String, String> pathParameters, MultivaluedMap<String, String> queryParameters) {
        Optional<String> tableName = this.extractTableName(pathParameters);
        if (tableName.isPresent()) {
            return tableName;
        }
        return this.extractTableName(queryParameters);
    }

    private Optional<String> extractTableName(MultivaluedMap<String, String> mmap) {
        String tableName = (String)mmap.getFirst((Object)"tableName");
        if (tableName == null && (tableName = (String)mmap.getFirst((Object)"tableNameWithType")) == null) {
            tableName = (String)mmap.getFirst((Object)"schemaName");
        }
        return Optional.ofNullable(tableName);
    }

    private static boolean isBaseFile(String path) {
        return !path.contains("/") && path.contains(".");
    }
}

