/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;

@Api(tags={"Auth"})
@Path(value="/")
public class PinotControllerAuthResource {
    @Inject
    private AccessControlFactory _accessControlFactory;
    @Context
    HttpHeaders _httpHeaders;

    @GET
    @Path(value="auth/verify")
    @Produces(value={"application/json"})
    @ApiOperation(value="Check whether authentication is enabled")
    @ApiResponses(value={@ApiResponse(code=200, message="Verification result provided"), @ApiResponse(code=500, message="Verification error")})
    public boolean verify(@ApiParam(value="Table name without type") @QueryParam(value="tableName") String tableName, @ApiParam(value="API access type") @QueryParam(value="accessType") AccessType accessType, @ApiParam(value="Endpoint URL") @QueryParam(value="endpointUrl") String endpointUrl) {
        AccessControl accessControl = this._accessControlFactory.create();
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return accessControl.hasAccess(accessType, this._httpHeaders, endpointUrl);
        }
        return accessControl.hasAccess(tableName, accessType, this._httpHeaders, endpointUrl);
    }

    @GET
    @Path(value="auth/info")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve auth workflow info")
    @ApiResponses(value={@ApiResponse(code=200, message="Auth workflow info provided")})
    public AccessControl.AuthWorkflowInfo info() {
        return this._accessControlFactory.create().getAuthWorkflowInfo();
    }
}

